/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.common.base.Objects;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfReportKind;
import io.flutter.perf.PerfTip;
import io.flutter.perf.SummaryStats;
import io.netty.util.collection.IntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class PerfTipRule {
    final PerfReportKind kind;
    final int priority;
    final String hackFileName;
    final String message;
    final String id;
    final String url;
    WidgetPattern pattern;
    final int minProblemLocationsInSubtree;
    final int minSinceNavigate;
    final int minPerSecond;
    final Icon icon;

    PerfTipRule(PerfReportKind kind, int priority, String hackFileName, String message, String id, String url, WidgetPattern pattern, int minProblemLocationsInSubtree, int minSinceNavigate, int minPerSecond, Icon icon) {
        this.kind = kind;
        this.priority = priority;
        this.hackFileName = hackFileName;
        this.message = message;
        this.id = id;
        this.url = url;
        this.pattern = pattern;
        this.minProblemLocationsInSubtree = minProblemLocationsInSubtree;
        this.minSinceNavigate = minSinceNavigate;
        this.minPerSecond = minPerSecond;
        this.icon = icon;
    }

    public static WidgetPattern matchParent(String name) {
        return new WidgetPattern(name, null);
    }

    public static WidgetPattern matchWidget(String name) {
        return new WidgetPattern(null, name);
    }

    public String getId() {
        return this.id;
    }

    public static boolean equalTipRule(PerfTip a, PerfTip b) {
        if (a == null || b == null) {
            return a == b;
        }
        return Objects.equal((Object)a.getRule(), (Object)b.getRule());
    }

    public static boolean equivalentPerfTips(List<PerfTip> a, List<PerfTip> b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (PerfTipRule.equalTipRule(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUrl() {
        return this.url;
    }

    public Icon getIcon() {
        return this.icon;
    }

    String getHtmlFragmentDescription() {
        return "<p><a href='" + this.url + "'>" + this.message + "</a></p>";
    }

    boolean maybeMatches(SummaryStats summary) {
        if (!this.matchesFrequency(summary)) {
            return false;
        }
        return this.pattern.widget == null || this.pattern.widget.equals(summary.getDescription());
    }

    boolean matchesFrequency(SummaryStats summary) {
        return this.minSinceNavigate > 0 && summary.getValue(PerfMetric.totalSinceEnteringCurrentScreen) >= this.minSinceNavigate || this.minPerSecond > 0 && summary.getValue(PerfMetric.pastSecond) >= this.minPerSecond;
    }

    boolean matches(SummaryStats summary, Collection<DiagnosticsNode> candidates, IntObjectHashMap<SummaryStats> statsInFile) {
        if (!this.maybeMatches(summary)) {
            return false;
        }
        if (this.pattern.parentWidget != null) {
            boolean patternIsStateful = Objects.equal((Object)this.pattern.parentWidget, (Object)"StatefulWidget");
            for (DiagnosticsNode candidate : candidates) {
                if (!this.ancestorMatches(statsInFile, patternIsStateful, candidate, candidate.getParent())) continue;
                return true;
            }
            return false;
        }
        if (this.pattern.widget != null) {
            for (DiagnosticsNode candidate : candidates) {
                if (!this.pattern.widget.equals(candidate.getWidgetRuntimeType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ancestorMatches(IntObjectHashMap<SummaryStats> statsInFile, boolean patternIsStateful, DiagnosticsNode candidate, DiagnosticsNode parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isStateful() && patternIsStateful || this.pattern.parentWidget.equals(parent.getWidgetRuntimeType())) {
            return this.minProblemLocationsInSubtree <= 1 || this.minProblemLocationsInSubtree <= this.countSubtreeMatches(candidate, statsInFile);
        }
        if ((parent = parent.getParent()) != null && Objects.equal((Object)parent.getCreationLocation().getPath(), (Object)candidate.getCreationLocation().getPath())) {
            return this.ancestorMatches(statsInFile, patternIsStateful, candidate, parent);
        }
        return false;
    }

    private int countSubtreeMatches(DiagnosticsNode candidate, IntObjectHashMap<SummaryStats> statsInFile) {
        ArrayList children;
        SummaryStats stats;
        int id = candidate.getLocationId();
        int matches = 0;
        if (id >= 0 && (stats = (SummaryStats)statsInFile.get(id)) != null && this.maybeMatches(stats)) {
            ++matches;
        }
        if ((children = (ArrayList)candidate.getChildren().getNow(null)) != null) {
            for (DiagnosticsNode child : children) {
                matches += this.countSubtreeMatches(child, statsInFile);
            }
        }
        return matches;
    }

    public static class WidgetPattern {
        final String parentWidget;
        final String widget;

        WidgetPattern(String parentWidget, String widget) {
            this.parentWidget = parentWidget;
            this.widget = widget;
        }
    }
}

