/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.xdebugger.XSourcePosition;
import io.flutter.perf.EditorPerfDecorations;
import io.flutter.perf.EditorPerfModel;
import io.flutter.perf.Icons;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfReportKind;
import io.flutter.perf.SummaryStats;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.AsyncUtils;
import io.flutter.view.FlutterPerfView;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PerfGutterIconRenderer
extends GutterIconRenderer {
    private static final double ANIMATION_SPEED = 4.0;
    private final RangeHighlighter highlighter;
    private final TextRange range;
    private final EditorPerfModel perfModelForFile;
    private Icon lastIcon;

    PerfGutterIconRenderer(TextRange range, EditorPerfModel perfModelForFile, RangeHighlighter highlighter) {
        this.highlighter = highlighter;
        this.range = range;
        this.perfModelForFile = perfModelForFile;
        TextAttributes textAttributes = highlighter.getTextAttributes();
        assert (textAttributes != null);
        textAttributes.setEffectType(EffectType.LINE_UNDERSCORE);
        this.updateUI(false);
    }

    public boolean isNavigateAction() {
        return this.isActive();
    }

    private FlutterApp getApp() {
        return this.perfModelForFile.getApp();
    }

    private int getCurrentValue() {
        return this.perfModelForFile.getStats().getCurrentValue(this.range);
    }

    private int getDisplayValue() {
        int value = this.getCurrentValue();
        if (value == 0 && this.perfModelForFile.getAlwaysShowLineMarkers()) {
            return 1;
        }
        return value;
    }

    private boolean isActive() {
        return this.getDisplayValue() > 0;
    }

    RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PerfGutterIconRenderer.this.isActive()) {
                    ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx((Project)PerfGutterIconRenderer.this.getApp().getProject());
                    ToolWindow flutterPerfToolWindow = toolWindowManager.getToolWindow("Flutter Performance");
                    if (flutterPerfToolWindow.isVisible()) {
                        PerfGutterIconRenderer.this.showPerfViewMessage();
                        return;
                    }
                    flutterPerfToolWindow.show(() -> PerfGutterIconRenderer.this.showPerfViewMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/perf/PerfGutterIconRenderer$1", "actionPerformed"));
            }
        };
    }

    private void showPerfViewMessage() {
        SummaryStats first;
        XSourcePosition position;
        FlutterPerfView flutterPerfView = (FlutterPerfView)ServiceManager.getService((Project)this.getApp().getProject(), FlutterPerfView.class);
        flutterPerfView.showForAppRebuildCounts(this.getApp());
        String message = "<html><body>" + this.getTooltipHtmlFragment() + "</body></html>";
        Iterable<SummaryStats> current = this.perfModelForFile.getStats().getRangeStats(this.range);
        if (current.iterator().hasNext() && (position = (first = current.iterator().next()).getLocation().getXSourcePosition()) != null) {
            AsyncUtils.invokeLater(() -> {
                position.createNavigatable(this.getApp().getProject()).navigate(true);
                HintManager.getInstance().showInformationHint(this.perfModelForFile.getTextEditor().getEditor(), message);
            });
        }
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.LEFT;
        if (alignment == null) {
            PerfGutterIconRenderer.$$$reportNull$$$0(0);
        }
        return alignment;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.lastIcon = this.getIconInternal();
        if (icon == null) {
            PerfGutterIconRenderer.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public Icon getIconInternal() {
        return Icons.getIconForCount(this.getCurrentValue(), this.perfModelForFile.getAlwaysShowLineMarkers());
    }

    Color getErrorStripeMarkColor() {
        int count = this.getDisplayValue();
        if (count == 0) {
            return null;
        }
        if (count >= 2) {
            return JBColor.YELLOW;
        }
        return JBColor.GRAY;
    }

    public void updateUI(boolean repaint) {
        int count = this.getDisplayValue();
        TextAttributes textAttributes = this.highlighter.getTextAttributes();
        assert (textAttributes != null);
        boolean changed = false;
        if (count > 0) {
            Color targetColor = this.getErrorStripeMarkColor();
            if (EditorPerfDecorations.ANIMATE_WIDGET_NAME_HIGLIGHTS) {
                double animateTime = (double)System.currentTimeMillis() * 0.001;
                double balance = (1.0 - Math.cos(animateTime * 4.0)) * 0.5;
                targetColor = ColorUtil.mix((Color)JBColor.WHITE, (Color)targetColor, (double)balance);
            }
            if (!targetColor.equals(textAttributes.getEffectColor())) {
                textAttributes.setEffectColor(targetColor);
                changed = true;
            }
        } else {
            textAttributes.setEffectColor(null);
        }
        Color errorStripeColor = this.getErrorStripeMarkColor();
        this.highlighter.setErrorStripeMarkColor(errorStripeColor);
        if (repaint && this.lastIcon != this.getIconInternal()) {
            changed = true;
        }
        if (changed && repaint) {
            MarkupModel markupModel = this.perfModelForFile.getTextEditor().getEditor().getMarkupModel();
            ((MarkupModelEx)markupModel).fireAttributesChanged((RangeHighlighterEx)this.highlighter, true, false);
        }
    }

    String getTooltipHtmlFragment() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (SummaryStats stats : this.perfModelForFile.getStats().getRangeStats(this.range)) {
            String style = first ? "" : "margin-top: 8px";
            first = false;
            sb.append("<p style='" + style + "'>");
            if (stats.getKind() == PerfReportKind.rebuild) {
                sb.append("Rebuild");
            } else if (stats.getKind() == PerfReportKind.repaint) {
                sb.append("Repaint");
            }
            sb.append(" counts for: <strong>" + stats.getDescription());
            sb.append("</strong></p>");
            sb.append("<p style='padding-left: 8px'>");
            sb.append("For last frame: " + stats.getValue(PerfMetric.lastFrame) + "<br>");
            sb.append("In past second: " + stats.getValue(PerfMetric.pastSecond) + "<br>");
            sb.append("Since entering the current screen: " + stats.getValue(PerfMetric.totalSinceEnteringCurrentScreen) + "<br>");
            sb.append("Since last hot reload/restart: " + stats.getValue(PerfMetric.total));
            sb.append("</p>");
        }
        if (sb.length() == 0) {
            sb.append("<p><b>No widget rebuilds detected for line.</b></p>");
        }
        return sb.toString();
    }

    public String getTooltipText() {
        return "<html><body>" + this.getTooltipHtmlFragment() + "</body></html>";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PerfGutterIconRenderer)) {
            return false;
        }
        PerfGutterIconRenderer other = (PerfGutterIconRenderer)((Object)obj);
        return other.getCurrentValue() == this.getCurrentValue();
    }

    public int hashCode() {
        return this.getCurrentValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/flutter/perf/PerfGutterIconRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

