/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.TextRange;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.SummaryStats;
import java.util.Arrays;
import java.util.Collection;

class FilePerfInfo {
    private final Multimap<TextRange, SummaryStats> stats = LinkedListMultimap.create();
    long maxTimestamp = -1L;
    private final int[] totalForMetric = new int[PerfMetric.values().length];

    FilePerfInfo() {
    }

    public void clear() {
        this.stats.clear();
        this.maxTimestamp = -1L;
        Arrays.fill(this.totalForMetric, 0);
    }

    public Iterable<TextRange> getLocations() {
        return this.stats.keySet();
    }

    public Iterable<SummaryStats> getStats() {
        return this.stats.values();
    }

    public boolean hasLocation(TextRange range) {
        return this.stats.containsKey((Object)range);
    }

    public int getTotalValue(PerfMetric metric) {
        return this.totalForMetric[metric.ordinal()];
    }

    public int getValue(TextRange range, PerfMetric metric) {
        Collection entries = this.stats.get((Object)range);
        if (entries == null) {
            return 0;
        }
        int count = 0;
        for (SummaryStats entry : entries) {
            count += entry.getValue(metric);
        }
        return count;
    }

    Iterable<SummaryStats> getRangeStats(TextRange range) {
        return this.stats.get((Object)range);
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public void add(TextRange range, SummaryStats entry) {
        this.stats.put((Object)range, (Object)entry);
        for (PerfMetric metric : PerfMetric.values()) {
            int n = metric.ordinal();
            this.totalForMetric[n] = this.totalForMetric[n] + entry.getValue(metric);
        }
    }

    public void markAppIdle() {
        for (PerfMetric metric : PerfMetric.values()) {
            if (!metric.timeIntervalMetric) continue;
            this.totalForMetric[metric.ordinal()] = 0;
        }
        for (SummaryStats stats : this.stats.values()) {
            stats.markAppIdle();
        }
    }

    public int getCurrentValue(TextRange range) {
        return this.getValue(range, PerfMetric.peakRecent);
    }
}

