/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import io.flutter.FlutterBundle;
import io.flutter.actions.InstallSdkAction;
import io.flutter.sdk.FlutterSdkUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterGeneratorPeer
implements InstallSdkAction.Model {
    private final WizardContext myContext;
    private JPanel myMainPanel;
    private ComboboxWithBrowseButton mySdkPathComboWithBrowse;
    private JBLabel myVersionContent;
    private JLabel errorIcon;
    private JTextPane errorText;
    private JScrollPane errorPane;
    private LinkLabel myInstallActionLink;
    private JProgressBar myProgressBar;
    private JTextPane myProgressText;
    private JScrollPane myProgressScrollPane;
    private JLabel myCancelProgressButton;
    private final InstallSdkAction myInstallSdkAction;
    private InstallSdkAction.CancelActionListener myListener;

    public FlutterGeneratorPeer(WizardContext context) {
        this.myContext = context;
        this.$$$setupUI$$$();
        this.myInstallSdkAction = new InstallSdkAction(this);
        this.errorIcon.setText("");
        this.errorIcon.setIcon(AllIcons.Actions.Lightning);
        Messages.installHyperlinkSupport((JTextPane)this.errorText);
        this.myVersionContent.setVisible(false);
        this.myProgressBar.setVisible(false);
        this.myProgressText.setVisible(false);
        this.myCancelProgressButton.setVisible(false);
        this.init();
    }

    private void init() {
        this.mySdkPathComboWithBrowse.getComboBox().setEditable(true);
        FlutterSdkUtil.addKnownSDKPathsToCombo(this.mySdkPathComboWithBrowse.getComboBox());
        this.mySdkPathComboWithBrowse.addBrowseFolderListener(FlutterBundle.message("flutter.sdk.browse.path.label", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        JTextComponent editorComponent = (JTextComponent)this.getSdkEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterGeneratorPeer.this.validate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/module/FlutterGeneratorPeer$1", "textChanged"));
            }
        });
        this.myInstallActionLink.setIcon(this.myInstallSdkAction.getLinkIcon());
        this.myInstallActionLink.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.myInstallSdkAction.getLinkIcon()));
        this.myInstallActionLink.setText(this.myInstallSdkAction.getLinkText());
        this.myInstallActionLink.setListener((label, linkUrl) -> this.myInstallSdkAction.actionPerformed(null), null);
        this.myProgressText.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL).deriveFont(2));
        this.myCancelProgressButton.setCursor(Cursor.getPredefinedCursor(12));
        this.myCancelProgressButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FlutterGeneratorPeer.this.myListener.actionCanceled();
            }
        });
        this.myInstallActionLink.setEnabled(this.getSdkComboPath().trim().isEmpty());
        this.errorIcon.setVisible(false);
        this.errorPane.setVisible(false);
    }

    void apply() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.mySdkPathComboWithBrowse = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
    }

    @Override
    public boolean validate() {
        ValidationInfo info = this.validateSdk();
        if (info != null) {
            this.errorText.setText(XmlStringUtil.wrapInHtml((CharSequence)info.message));
        }
        this.errorIcon.setVisible(info != null);
        this.errorPane.setVisible(info != null);
        this.myInstallActionLink.setEnabled(info != null || this.getSdkComboPath().trim().isEmpty());
        return info == null;
    }

    @Nullable
    private ValidationInfo validateSdk() {
        String sdkPath = this.getSdkComboPath();
        if (StringUtils.isEmpty((String)sdkPath)) {
            return new ValidationInfo("A Flutter SDK must be specified for project creation.", (JComponent)this.mySdkPathComboWithBrowse);
        }
        String message = FlutterSdkUtil.getErrorMessageIfWrongSdkRootPath(sdkPath);
        if (message != null) {
            return new ValidationInfo(message, (JComponent)this.mySdkPathComboWithBrowse);
        }
        return null;
    }

    @NotNull
    public String getSdkComboPath() {
        String string = FileUtilRt.toSystemIndependentName((String)this.getSdkEditor().getItem().toString().trim());
        if (string == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ComboBoxEditor getSdkEditor() {
        ComboBoxEditor comboBoxEditor = this.mySdkPathComboWithBrowse.getComboBox().getEditor();
        if (comboBoxEditor == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(2);
        }
        return comboBoxEditor;
    }

    @Override
    @NotNull
    public ComboboxWithBrowseButton getSdkComboBox() {
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkPathComboWithBrowse;
        if (comboboxWithBrowseButton == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(3);
        }
        return comboboxWithBrowseButton;
    }

    @Override
    public void setSdkPath(@NotNull String sdkPath) {
        if (sdkPath == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(4);
        }
        this.getSdkEditor().setItem(sdkPath);
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.myProgressBar;
    }

    @Override
    public LinkLabel getInstallActionLink() {
        return this.myInstallActionLink;
    }

    @Override
    public JTextPane getProgressText() {
        return this.myProgressText;
    }

    @Override
    public JLabel getCancelProgressButton() {
        return this.myCancelProgressButton;
    }

    @Override
    public void setErrorDetails(@Nullable String details) {
        boolean makeVisible;
        boolean bl = makeVisible = details != null;
        if (makeVisible) {
            this.errorText.setText(details);
        }
        this.errorIcon.setVisible(makeVisible);
        this.errorPane.setVisible(makeVisible);
    }

    @Override
    public void addCancelActionListener(InstallSdkAction.CancelActionListener listener) {
        this.myListener = listener;
    }

    @Override
    public void requestNextStep() {
        Method nextAction;
        AbstractWizard wizard = this.myContext.getWizard();
        if (wizard != null && (nextAction = ReflectionUtil.getMethod(wizard.getClass(), (String)"doNextAction", (Class[])new Class[0])) != null) {
            try {
                nextAction.invoke((Object)wizard, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextPane jTextPane;
        JScrollPane jScrollPane;
        JProgressBar jProgressBar;
        LinkLabel linkLabel;
        JTextPane jTextPane2;
        JScrollPane jScrollPane2;
        JLabel jLabel2;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 10, new Insets(0, 5, 0, 8), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("flutter.sdk.path.label"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkPathComboWithBrowse;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 9, 0, 1, 7, 0, null, null, null));
        this.myVersionContent = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 10, 0, 3, 3, 3, null, null, null));
        this.errorIcon = jLabel2 = new JLabel();
        jLabel2.setText("icon_placeholder");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.errorPane = jScrollPane2 = new JScrollPane();
        jPanel2.add((Component)jScrollPane2, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.errorText = jTextPane2 = new JTextPane();
        jTextPane2.setText("Error text placeholder");
        jScrollPane2.setViewportView(jTextPane2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 32), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 2, 1, 7, 0, 3, 3, 3, null, null, null));
        this.myInstallActionLink = linkLabel = new LinkLabel();
        linkLabel.setHorizontalAlignment(0);
        linkLabel.setHorizontalTextPosition(4);
        linkLabel.setIconTextGap(4);
        linkLabel.setText("");
        linkLabel.setToolTipText("Install the Flutter SDK");
        jPanel3.add((Component)linkLabel, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 3, null, null, null, 1));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel3.add((Component)jProgressBar, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myProgressScrollPane = jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myProgressText = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        Font font = jTextPane.getFont();
        if (font != null) {
            jTextPane.setFont(new Font(font.getName(), 2, font.getSize()));
        }
        jTextPane.setText("Install progress placeholder\n");
        jScrollPane.setViewportView(jTextPane);
        this.myCancelProgressButton = jLabel = new JLabel();
        jLabel.setFocusable(true);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/cancel.png")));
        jLabel.setIconTextGap(0);
        jLabel.setOpaque(false);
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 1, 1, null, null, null));
        jBLabel2.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/module/FlutterGeneratorPeer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkComboPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkComboBox";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/module/FlutterGeneratorPeer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSdkPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

