/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging.tree;

import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogTree;
import io.flutter.logging.text.StyledText;
import io.flutter.logging.tree.AbstractEntryCellRender;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;

public class MessageCellRenderer
extends AbstractEntryCellRender {
    @NotNull
    private final FlutterApp app;

    public MessageCellRenderer(@NotNull FlutterApp app, @NotNull FlutterLogTree.EntryModel entryModel) {
        if (app == null) {
            MessageCellRenderer.$$$reportNull$$$0(0);
        }
        if (entryModel == null) {
            MessageCellRenderer.$$$reportNull$$$0(1);
        }
        super(entryModel);
        this.app = app;
        this.setIconTextGap(JBUI.scale((int)5));
        this.setIconOnTheRight(true);
        this.setIconOpaque(false);
        this.setTransparentIconBackground(true);
    }

    @Override
    void render(FlutterLogEntry entry) {
        SimpleTextAttributes style = this.entryModel.style(entry, 0);
        if (style.getBgColor() != null) {
            this.setBackground(style.getBgColor());
        }
        for (StyledText styledText : entry.getStyledText()) {
            this.append(styledText.getText(), styledText.getStyle() != null ? styledText.getStyle() : style, styledText.getTag());
        }
        Object data = entry.getData();
        if (data instanceof DiagnosticsNode || data instanceof String && JsonUtils.hasJsonData((String)data)) {
            this.setIcon(AllIcons.General.ComboArrowRight);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "app";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "entryModel";
                break;
            }
        }
        objectArray[1] = "io/flutter/logging/tree/MessageCellRenderer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

