/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging.tree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import io.flutter.inspector.DiagnosticLevel;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.DiagnosticsTreeStyle;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogEntryParser;
import io.flutter.logging.text.StyledText;
import io.flutter.utils.HtmlBuilder;
import io.flutter.utils.JsonUtils;
import io.flutter.view.InspectorColoredTreeCellRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class DataPanel
extends JPanel {
    private final Gson gsonHelper = new GsonBuilder().setPrettyPrinting().create();
    private final HTMLEditorKit editorKit;
    private final EventDispatcher<ContentListener> dispatcher = EventDispatcher.create(ContentListener.class);
    private final Project project;
    private FlutterLogEntry entry;

    private DataPanel(Project project) {
        this.project = project;
        this.setBorder((Border)JBUI.Borders.empty());
        this.editorKit = new HTMLEditorKit();
    }

    public static DataPanel create(@NotNull Project project) {
        if (project == null) {
            DataPanel.$$$reportNull$$$0(0);
        }
        DataPanel panel = new DataPanel(project);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public void onUpdate(@NotNull ContentListener listener) {
        if (listener == null) {
            DataPanel.$$$reportNull$$$0(1);
        }
        this.dispatcher.addListener((EventListener)listener);
    }

    private void linkSelected(URL url) {
    }

    public void update(@NotNull FlutterLogEntry entry) {
        if (entry == null) {
            DataPanel.$$$reportNull$$$0(2);
        }
        if (entry == this.entry) {
            return;
        }
        this.entry = entry;
        Object data = entry.getData();
        for (Component c : this.getComponents()) {
            this.remove(c);
        }
        boolean showDataPane = false;
        if (data instanceof DiagnosticsNode) {
            showDataPane = this.updateNodeData((DiagnosticsNode)data);
        } else if (data instanceof String && JsonUtils.hasJsonData((String)data)) {
            showDataPane = this.updateJsonTextData((String)data);
        }
        this.showPane(showDataPane);
    }

    private void showPane(boolean show) {
        this.setVisible(show);
        if (show) {
            this.repaint();
            this.revalidate();
        }
        ((ContentListener)this.dispatcher.getMulticaster()).hasContent(show);
    }

    private boolean updateJsonTextData(String data) {
        JsonElement jsonElement = new JsonParser().parse(data);
        String text = this.gsonHelper.toJson(jsonElement);
        if (text.isEmpty()) {
            return false;
        }
        JEditorPane editorPane = this.createEditorPane();
        editorPane.setText(HtmlBuilder.html(HtmlBuilder.pre(text)));
        this.add(editorPane);
        return true;
    }

    private boolean updateNodeData(DiagnosticsNode data) {
        this.addText(data.toString(), data);
        ArrayList<DiagnosticsNode> properties = data.getInlineProperties();
        for (DiagnosticsNode node : properties) {
            List<DiagnosticsNode> children;
            String contents = "";
            if (node.getName() != null) {
                contents = contents + node.getName();
            }
            if (!(children = DataPanel.getChildren(node)).isEmpty() || node.getDescription() != null) {
                if (!contents.isEmpty()) {
                    contents = contents + ": ";
                }
                if (node.getDescription() != null) {
                    contents = contents + node.getDescription();
                }
            }
            if (children.isEmpty()) {
                this.addText(contents, node);
                continue;
            }
            this.addTree(contents, node);
        }
        return true;
    }

    private void addText(String contents, DiagnosticsNode node) {
        JEditorPane editorPane = this.createEditorPane();
        editorPane.setText(HtmlBuilder.html(HtmlBuilder.div(CssStyle.forNode(node), HtmlBuilder.span(contents))));
        this.add(editorPane);
    }

    private void addTree(String rootLabel, DiagnosticsNode node) {
        final JTree tree = new JTree();
        tree.setModel((TreeModel)((Object)new NodeModel(node, rootLabel)));
        tree.setCellRenderer(new NodeRenderer(this.entry.getFilters()));
        tree.setShowsRootHandles(true);
        tree.collapseRow(0);
        tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                tree.clearSelection();
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DataPanel.this.selectionChanged(tree);
            }
        });
        MouseHandler mouseHandler = new MouseHandler(tree, this.project);
        tree.addMouseListener(mouseHandler);
        tree.addMouseMotionListener(mouseHandler);
        NonOpaquePanel panel = new NonOpaquePanel();
        panel.add((Component)tree);
        this.add((Component)panel);
    }

    private void selectionChanged(@NotNull JTree tree) {
        Object pathComponent;
        if (tree == null) {
            DataPanel.$$$reportNull$$$0(3);
        }
        if ((pathComponent = tree.getLastSelectedPathComponent()) instanceof DiagnosticsNode) {
            DiagnosticsNode diagnostics = (DiagnosticsNode)pathComponent;
            diagnostics.setSelection(diagnostics.getValueRef(), false);
        }
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        editorPane.setEditorKit(this.editorKit);
        editorPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.linkSelected(e.getURL());
            }
        });
        return editorPane;
    }

    private static List<DiagnosticsNode> getChildren(DiagnosticsNode node) {
        ArrayList children = node.getChildren().getNow(new ArrayList());
        return Stream.of(children, node.getInlineProperties()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "io/flutter/logging/tree/DataPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        @NotNull
        private final JTree tree;
        @NotNull
        private final Project project;

        MouseHandler(@NotNull JTree tree, @NotNull Project project) {
            if (tree == null) {
                MouseHandler.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MouseHandler.$$$reportNull$$$0(1);
            }
            this.tree = tree;
            this.project = project;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Cursor cursor = this.getTagForPosition(e) instanceof HyperlinkInfo ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor();
            this.tree.setCursor(cursor);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object tag = this.getTagForPosition(e);
            if (tag instanceof HyperlinkInfo) {
                ((HyperlinkInfo)tag).navigate(this.project);
            }
        }

        private Object getTagForPosition(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            TreeCellRenderer cellRenderer = tree.getCellRenderer();
            if (cellRenderer instanceof InspectorColoredTreeCellRenderer) {
                InspectorColoredTreeCellRenderer renderer = (InspectorColoredTreeCellRenderer)cellRenderer;
                TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
                Rectangle pathBounds = tree.getPathBounds(treePath);
                if (pathBounds != null) {
                    int x = e.getX() - pathBounds.x;
                    return renderer.getFragmentTagAt(x);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "io/flutter/logging/tree/DataPanel$MouseHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class NodeModel
    extends BaseTreeModel<Object> {
        private final DiagnosticsNode node;
        private final String rootContent;

        public NodeModel(DiagnosticsNode node, String rootContent) {
            this.node = node;
            this.rootContent = rootContent;
        }

        public List<? extends Object> getChildren(Object parent) {
            if (parent instanceof DiagnosticsNode) {
                return DataPanel.getChildren((DiagnosticsNode)parent);
            }
            if (parent == this.rootContent) {
                return DataPanel.getChildren(this.node);
            }
            return null;
        }

        public Object getRoot() {
            return this.rootContent;
        }
    }

    class NodeRenderer
    extends InspectorColoredTreeCellRenderer {
        private final List<Filter> filters;

        public NodeRenderer(List<Filter> filters) {
            this.filters = filters;
        }

        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                NodeRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof String) {
                this.appendStyledText(value.toString());
            } else if (value instanceof DiagnosticsNode) {
                Icon icon;
                DiagnosticsNode node = (DiagnosticsNode)value;
                if (!node.isProperty() && (icon = node.getIcon()) != null) {
                    this.setIcon(icon);
                }
                this.appendStyledText(value.toString());
            }
        }

        void appendStyledText(@NotNull String line) {
            if (line == null) {
                NodeRenderer.$$$reportNull$$$0(1);
            }
            FlutterLogEntryParser.LineHandler lineHandler = new FlutterLogEntryParser.LineHandler(this.filters, null);
            List<StyledText> styledTexts = lineHandler.parseLineStyle(line);
            for (StyledText styledText : styledTexts) {
                this.append(styledText.getText(), styledText.getStyle() != null ? styledText.getStyle() : SimpleTextAttributes.REGULAR_ATTRIBUTES, styledText.getTag());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/logging/tree/DataPanel$NodeRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendStyledText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CssStyle {
        private CssStyle() {
        }

        static String forNode(DiagnosticsNode node) {
            return HtmlBuilder.attr("style", CssStyle.forLevel(node.getLevel()) + CssStyle.forStyle(node.getStyle()));
        }

        static String forLevel(DiagnosticLevel level) {
            switch (level) {
                case info: {
                    return "padding-left: 16px; ";
                }
                case error: {
                    return "color: rgb(244, 67, 54); padding-left: 16px; ";
                }
                case hint: {
                    return "background-color: #fafad2; padding: 8px 8px 8px 24px; margin: 5px 0; ";
                }
            }
            return "";
        }

        static String forStyle(DiagnosticsTreeStyle style) {
            switch (style) {
                case error: {
                    return "background-color: #f97c7c; padding: 12px; margin:5px 0; ";
                }
            }
            return "";
        }
    }

    public static interface ContentListener
    extends EventListener {
        public void hasContent(boolean var1);
    }
}

