/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging.tree;

import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import io.flutter.logging.FlutterLogColors;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogTree;
import io.flutter.logging.tree.AbstractEntryCellRender;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryCellRenderer
extends SimpleColoredRenderer
implements TableCellRenderer {
    @NotNull
    private final FlutterLogTree.EntryModel entryModel;

    public CategoryCellRenderer(@NotNull FlutterLogTree.EntryModel entryModel) {
        if (entryModel == null) {
            CategoryCellRenderer.$$$reportNull$$$0(0);
        }
        this.entryModel = entryModel;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(JBColor.background());
        if (value instanceof FlutterLogEntry) {
            FlutterLogEntry entry = (FlutterLogEntry)value;
            String category = entry.getCategory();
            JLabel label = new JLabel(" " + category + " ");
            label.setBackground(FlutterLogColors.forCategory(category));
            label.setForeground(JBColor.background());
            label.setOpaque(true);
            panel.add(Box.createHorizontalGlue());
            panel.add(label);
            panel.add(Box.createHorizontalStrut(8));
            SimpleTextAttributes style = this.entryModel.style(entry, 0);
            if (style.getBgColor() != null) {
                this.setBackground(style.getBgColor());
                panel.setBackground(style.getBgColor());
            }
            AbstractEntryCellRender.updateEntryBorder(panel, entry, row);
        }
        this.clear();
        this.setPaintFocusBorder(hasFocus && table.getCellSelectionEnabled());
        this.acquireState(table, isSelected, hasFocus, row, col);
        this.getCellState().updateRenderer((JComponent)((Object)this));
        if (isSelected) {
            panel.setBackground(table.getSelectionBackground());
        }
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryModel", "io/flutter/logging/tree/CategoryCellRenderer", "<init>"));
    }
}

