/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging.tree;

import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogTree;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntryCellRender
extends ColoredTableCellRenderer {
    private static final Border RELOAD_LINE = new CompoundBorder(BorderFactory.createEmptyBorder(0, -1, -1, -1), BorderFactory.createDashedBorder((Paint)JBColor.ORANGE, 5.0f, 5.0f));
    private static final Border RESTART_LINE = new CompoundBorder(BorderFactory.createEmptyBorder(0, -1, -1, -1), BorderFactory.createDashedBorder((Paint)JBColor.GREEN, 5.0f, 5.0f));
    @NotNull
    protected final FlutterLogTree.EntryModel entryModel;

    AbstractEntryCellRender(@NotNull FlutterLogTree.EntryModel entryModel) {
        if (entryModel == null) {
            AbstractEntryCellRender.$$$reportNull$$$0(0);
        }
        this.entryModel = entryModel;
    }

    protected final void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
        if (value instanceof FlutterLogEntry) {
            FlutterLogEntry entry = (FlutterLogEntry)value;
            this.render(entry);
            AbstractEntryCellRender.updateEntryBorder((JComponent)((Object)this), entry, row);
        }
    }

    public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        super.acquireState(table, isSelected, false, row, column);
    }

    void appendStyled(FlutterLogEntry entry, String text) {
        SimpleTextAttributes style = this.entryModel.style(entry, 0);
        if (style.getBgColor() != null) {
            this.setBackground(style.getBgColor());
        }
        this.append(text, style);
    }

    abstract void render(FlutterLogEntry var1);

    public static void updateEntryBorder(@NotNull JComponent component, @NotNull FlutterLogEntry entry, int row) {
        if (component == null) {
            AbstractEntryCellRender.$$$reportNull$$$0(1);
        }
        if (entry == null) {
            AbstractEntryCellRender.$$$reportNull$$$0(2);
        }
        if (row > 0) {
            if (entry.getKind() == FlutterLogEntry.Kind.RELOAD) {
                component.setBorder(RELOAD_LINE);
            } else if (entry.getKind() == FlutterLogEntry.Kind.RESTART) {
                component.setBorder(RESTART_LINE);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "io/flutter/logging/tree/AbstractEntryCellRender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateEntryBorder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

