/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging.text;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import io.flutter.logging.text.StyledText;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineParser {
    private final StringBuilder buffer = new StringBuilder();
    protected final List<Filter> filters;
    @VisibleForTesting
    protected SimpleTextAttributes style;
    private String str;
    private int index;
    private int length;
    private boolean flush;
    private boolean reset;
    private SimpleTextAttributes previousStyle;
    private boolean flushPrevious;

    public LineParser(Filter ... filter) {
        this(Arrays.asList(filter));
    }

    public LineParser(List<Filter> filters) {
        this.filters = filters;
    }

    private static Object toStyle(String str) {
        switch (str) {
            case "1": {
                return 1;
            }
            case "3": {
                return 2;
            }
            case "4": {
                return 16;
            }
            case "9": {
                return 4;
            }
            case "30": {
                return JBColor.BLACK;
            }
            case "31": {
                return JBColor.RED;
            }
            case "32": {
                return JBColor.GREEN;
            }
            case "33": {
                return JBColor.YELLOW;
            }
            case "34": {
                return JBColor.BLUE;
            }
            case "35": {
                return JBColor.MAGENTA;
            }
            case "36": {
                return JBColor.CYAN;
            }
            case "37": {
                return JBColor.WHITE;
            }
            case "38": {
                return JBColor.GRAY;
            }
        }
        return null;
    }

    protected void write(@NotNull String string, @Nullable SimpleTextAttributes style) {
        if (string == null) {
            LineParser.$$$reportNull$$$0(0);
        }
        this.write(string, style, null);
    }

    protected void write(@NotNull String string, @Nullable SimpleTextAttributes style, @Nullable Object tag) {
        if (string == null) {
            LineParser.$$$reportNull$$$0(1);
        }
        this.write(new StyledText(string, style, tag));
    }

    public abstract void write(@NotNull StyledText var1);

    public void parse(@NotNull String str) {
        if (str == null) {
            LineParser.$$$reportNull$$$0(2);
        }
        if (str.isEmpty()) {
            return;
        }
        ArrayList<Filter.ResultItem> resultItems = new ArrayList<Filter.ResultItem>();
        for (Filter filter : this.filters) {
            Filter.Result result = filter.applyFilter(str, str.length());
            if (result == null) continue;
            resultItems.addAll(result.getResultItems());
        }
        resultItems.sort(Comparator.comparingInt(Filter.ResultItem::getHighlightStartOffset));
        int cursor = 0;
        for (Filter.ResultItem item : resultItems) {
            HyperlinkInfo hyperlinkInfo = item.getHyperlinkInfo();
            if (hyperlinkInfo == null) continue;
            int start = item.getHighlightStartOffset();
            int end = item.getHighlightEndOffset();
            if (cursor < start) {
                this.parseChunk(str.substring(cursor, start));
            }
            this.write(str.substring(start, end), SimpleTextAttributes.LINK_ATTRIBUTES, hyperlinkInfo);
            cursor = end;
        }
        if (cursor < str.length()) {
            this.parseChunk(str.substring(cursor));
        }
    }

    private void parseChunk(@NotNull String str) {
        if (str == null) {
            LineParser.$$$reportNull$$$0(3);
        }
        this.str = str;
        this.length = str.length();
        this.index = 0;
        while (this.hasNext()) {
            this.parseNext();
        }
    }

    private void parseNext() {
        while (this.hasNext()) {
            char next = this.advance();
            if (next == '\u001b') {
                boolean readEscape = this.readEscape();
                if (!readEscape) {
                    this.append(next);
                    continue;
                }
                this.flush();
                continue;
            }
            this.append(next);
        }
        this.flush = true;
        this.flush();
    }

    private boolean readEscape() {
        boolean reset = this.readReset();
        if (reset) {
            this.reset = true;
            return true;
        }
        SimpleTextAttributes style = this.readStyle();
        if (style != null) {
            this.flushPrevious = true;
            this.previousStyle = this.style;
            this.style = style;
            this.flush = true;
            return true;
        }
        return false;
    }

    private void flush() {
        if (this.flush || this.reset) {
            if (this.buffer.length() > 0) {
                this.write(this.buffer.toString(), this.flushPrevious ? this.previousStyle : this.style);
                this.buffer.setLength(0);
            }
            this.flush = false;
            this.flushPrevious = false;
        }
        if (this.reset) {
            this.style = null;
            this.reset = false;
        }
    }

    private void append(char ch) {
        this.flush();
        this.buffer.append(ch);
    }

    private boolean readReset() {
        if (this.peek(3).equals("[0m")) {
            this.eat(3);
            return true;
        }
        return false;
    }

    @Nullable
    private SimpleTextAttributes readStyle() {
        if (!this.peek(1).equals("[")) {
            return null;
        }
        String remainder = this.str.substring(this.index);
        int escapeEndIndex = remainder.indexOf("m");
        if (escapeEndIndex == -1) {
            return null;
        }
        String paramString = remainder.substring(1, escapeEndIndex);
        this.eat(paramString.length() + 2);
        Color color = null;
        int fontStyle = 0;
        for (String param : paramString.split(";")) {
            Object style = LineParser.toStyle(param);
            if (style instanceof Color) {
                color = (Color)style;
                continue;
            }
            if (!(style instanceof Integer)) continue;
            fontStyle |= ((Integer)style).intValue();
        }
        return new SimpleTextAttributes(fontStyle, color);
    }

    private String peek(int n) {
        return this.index + n > this.length ? "" : this.str.substring(this.index, this.index + n);
    }

    private void eat(int n) {
        this.index += n;
    }

    private char advance() {
        return this.str.charAt(this.index++);
    }

    boolean hasNext() {
        return this.index < this.str.length();
    }

    boolean atEnd() {
        return this.index >= this.str.length();
    }

    public void clear() {
        this.style = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        objectArray2[1] = "io/flutter/logging/text/LineParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseChunk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

