/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.FlutterUtils;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogConstants;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogFilterPanel;
import io.flutter.logging.FlutterLogPreferences;
import io.flutter.logging.FlutterLogTree;
import io.flutter.logging.LoggingChannel;
import io.flutter.logging.tree.DataPanel;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogView
extends JPanel
implements ConsoleView,
DataProvider,
FlutterLog.Listener {
    public static final boolean ENABLE_LOGGING_CHANNELS = false;
    @NotNull
    private static final Logger LOG = Logger.getInstance(FlutterLogView.class);
    private static final float DATA_PANEL_SPLITTER_PROPORTION_DEFAULT = 0.6f;
    @NotNull
    private static final Map<FlutterLog.Level, TextAttributesKey> LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP;
    @NotNull
    private static final Map<EffectType, Integer> EFFECT_TYPE_TEXT_STYLE_MAP;
    @NotNull
    private static final SimpleTextAttributes REGULAR_ATTRIBUTES;
    @NotNull
    private final Map<FlutterLog.Level, SimpleTextAttributes> textAttributesByLogLevelCache;
    float lastSplitProportion;
    @NotNull
    private final FlutterApp app;
    private final EntryModel entryModel;
    @NotNull
    private final SimpleToolWindowPanel toolWindowPanel;
    @NotNull
    private final FlutterLogTree.TreeModel logModel;
    @NotNull
    private final FlutterLogTree logTree;
    @NotNull
    private final FlutterLogFilterPanel filterPanel;
    @NotNull
    private final FlutterLogPreferences flutterLogPreferences;
    @NotNull
    private final ScrollToEndAction scrollToEndAction;
    @NotNull
    private final ClearLogAction clearLogAction;
    @NotNull
    private final DataPanel dataPanel;
    private JScrollPane dataPane;
    private Splitter treeSplitter;
    private final Gson gsonHelper;
    boolean isPinned;
    boolean prePinAutoScroll;

    public FlutterLogView(final @NotNull FlutterApp app) {
        if (app == null) {
            FlutterLogView.$$$reportNull$$$0(0);
        }
        this.textAttributesByLogLevelCache = new ConcurrentHashMap<FlutterLog.Level, SimpleTextAttributes>();
        this.lastSplitProportion = 0.6f;
        this.entryModel = new EntryModel();
        this.scrollToEndAction = new ScrollToEndAction();
        this.clearLogAction = new ClearLogAction();
        this.gsonHelper = new GsonBuilder().setPrettyPrinting().create();
        this.prePinAutoScroll = true;
        this.app = app;
        this.flutterLogPreferences = FlutterLogPreferences.getInstance(app.getProject());
        this.filterPanel = new FlutterLogFilterPanel(param -> this.doFilter());
        this.filterPanel.initFromPreferences(this.flutterLogPreferences);
        this.computeTextAttributesByLogLevelCache();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> this.computeTextAttributesByLogLevelCache());
        FlutterLog flutterLog = app.getFlutterLog();
        flutterLog.addListener(this, (Disposable)this);
        Content content = ContentFactory.SERVICE.getInstance().createContent(null, null, false);
        content.setCloseable(false);
        this.toolWindowPanel = new SimpleToolWindowPanel(true, true);
        content.setComponent((JComponent)this.toolWindowPanel);
        JPanel toolbar = this.createToolbar();
        this.toolWindowPanel.setToolbar((JComponent)toolbar);
        this.logTree = new FlutterLogTree(app, this.entryModel, (Disposable)this);
        this.logModel = this.logTree.getLogTreeModel();
        this.logModel.updateFromPreferences(this.flutterLogPreferences);
        this.entryModel.showColors = this.flutterLogPreferences.isShowColor();
        this.logTree.setTableHeader(null);
        this.logTree.setRootVisible(false);
        this.logTree.setExpandableItemsEnabled(true);
        this.logTree.getTree().setScrollsOnExpand(true);
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", FlutterLogView.this.getTreePopupActions());
                popupMenu.getComponent().show(comp, x, y);
            }

            public void mouseMoved(MouseEvent e) {
                Cursor cursor = this.getTagForPosition(e) instanceof HyperlinkInfo ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor();
                FlutterLogView.this.logTree.setCursor(cursor);
            }

            public void mouseClicked(MouseEvent e) {
                Object tag = this.getTagForPosition(e);
                if (tag instanceof HyperlinkInfo) {
                    ((HyperlinkInfo)tag).navigate(app.getProject());
                }
            }

            private Object getTagForPosition(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                int row = table.rowAtPoint(e.getPoint());
                int column = table.columnAtPoint(e.getPoint());
                if (row == -1 || column == -1) {
                    return null;
                }
                TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
                if (cellRenderer instanceof ColoredTableCellRenderer) {
                    ColoredTableCellRenderer renderer = (ColoredTableCellRenderer)cellRenderer;
                    Rectangle rc = table.getCellRect(row, column, false);
                    return renderer.getFragmentTagAt(e.getX() - rc.x);
                }
                return null;
            }
        };
        this.logTree.addMouseListener((MouseListener)popupHandler);
        this.logTree.addMouseMotionListener((MouseMotionListener)popupHandler);
        FlutterLogView.fixColumnWidth(this.logTree.getColumn("Time"), 100);
        FlutterLogView.fixColumnWidth(this.logTree.getColumn("Sequence"), 50);
        FlutterLogView.fixColumnWidth(this.logTree.getColumn("Level"), 70);
        FlutterLogView.fixColumnWidth(this.logTree.getColumn("Category"), 110);
        this.logTree.getColumn("Message").setMinWidth(100);
        this.dataPanel = DataPanel.create(app.getProject());
        this.logTree.addSelectionListener(this::updateDataPanel);
        this.setupLogTreeScrollPane();
    }

    private void updateDataPanel() {
        List<FlutterLogTree.FlutterEventNode> selectedNodes = this.logTree.getSelectedNodes();
        if (!selectedNodes.isEmpty()) {
            this.dataPanel.update(selectedNodes.get((int)0).entry);
        }
    }

    private void setupLogTreeScrollPane() {
        JScrollPane treePane = ScrollPaneFactory.createScrollPane((Component)((Object)this.logTree), (int)20, (int)30);
        treePane.getVerticalScrollBar().getModel().addChangeListener(new LogVerticalScrollChangeListener(){

            @Override
            protected void onScrollUp() {
                FlutterLogView.this.scrollToEndAction.disableIfNeeded();
            }

            @Override
            protected void onScrollToEnd() {
                FlutterLogView.this.scrollToEndAction.enableIfNeeded();
            }
        });
        this.logModel.setScrollPane(treePane);
        this.dataPane = ScrollPaneFactory.createScrollPane((Component)this.dataPanel, (int)20, (int)31);
        this.treeSplitter = new Splitter(false);
        this.treeSplitter.setProportion(0.6f);
        this.dataPane.setVisible(false);
        this.treeSplitter.setVisible(false);
        this.treeSplitter.setFirstComponent((JComponent)treePane);
        this.treeSplitter.setSecondComponent((JComponent)this.dataPane);
        this.toolWindowPanel.setContent((JComponent)this.treeSplitter);
        this.dataPanel.onUpdate(hasContent -> {
            this.dataPane.setVisible(hasContent);
            if (hasContent) {
                if (this.treeSplitter.getProportion() != this.lastSplitProportion) {
                    this.treeSplitter.setProportion(this.lastSplitProportion);
                    this.treeSplitter.revalidate();
                    this.treeSplitter.repaint();
                }
            } else {
                float proportion = this.treeSplitter.getProportion();
                if (proportion != 1.0f) {
                    this.lastSplitProportion = proportion;
                }
                this.treeSplitter.setProportion(1.0f);
            }
        });
    }

    private void computeTextAttributesByLogLevelCache() {
        EditorColorsScheme globalEditorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.textAttributesByLogLevelCache.clear();
        for (FlutterLog.Level level : FlutterLog.Level.values()) {
            try {
                TextAttributesKey key = LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.get((Object)level);
                TextAttributes attributes = globalEditorColorsScheme.getAttributes(key);
                int fontType = attributes.getFontType();
                Color effectColor = attributes.getEffectColor();
                Integer textStyle = EFFECT_TYPE_TEXT_STYLE_MAP.get(attributes.getEffectType());
                if (effectColor != null && textStyle != null) {
                    fontType |= textStyle.intValue();
                }
                SimpleTextAttributes textAttributes = new SimpleTextAttributes(attributes.getBackgroundColor(), attributes.getForegroundColor(), effectColor, fontType);
                this.textAttributesByLogLevelCache.put(level, textAttributes);
            }
            catch (Exception e) {
                FlutterUtils.warn(LOG, "Error when get text attributes by log level", e);
            }
        }
    }

    private ActionGroup getTreePopupActions() {
        return new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = new AnAction[]{new CopyToClipboardAction(), new Separator(), new ClearLogAction()};
                if (anActionArray == null) {
                    3.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/logging/FlutterLogView$3", "getChildren"));
            }
        };
    }

    private void doFilter() {
        FlutterLogFilterPanel.FilterParam param = this.filterPanel.getCurrentFilterParam();
        this.flutterLogPreferences.setToolWindowRegex(param.isRegex());
        this.flutterLogPreferences.setToolWindowMatchCase(param.isMatchCase());
        this.flutterLogPreferences.setToolWindowLogLevel(param.getLogLevel().value);
        ApplicationManager.getApplication().invokeLater(() -> this.logTree.setFilter(param));
    }

    @NotNull
    private FlutterLog getFlutterLog() {
        FlutterLog flutterLog = this.app.getFlutterLog();
        if (flutterLog == null) {
            FlutterLogView.$$$reportNull$$$0(1);
        }
        return flutterLog;
    }

    @NotNull
    private JPanel createToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new FilterStatusLabel());
        toolbarGroup.add((AnAction)new ConfigureAction());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FlutterLogViewToolbar", (ActionGroup)toolbarGroup, true);
        actionToolbar.setMiniMode(false);
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        toolbar.add((Component)this.filterPanel.getRoot(), "West");
        toolbar.add((Component)actionToolbar.getComponent(), "East");
        JPanel jPanel = toolbar;
        if (jPanel == null) {
            FlutterLogView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public void onEvent(@NotNull FlutterLogEntry entry) {
        if (entry == null) {
            FlutterLogView.$$$reportNull$$$0(3);
        }
        boolean isError = entry.getKind() == FlutterLogEntry.Kind.FLUTTER_ERROR;
        this.logTree.append(entry, isError && !this.isPinned);
        if (isError && !this.isPinned) {
            this.prePinAutoScroll = this.logModel.autoScrollToEnd;
            this.scrollToEndAction.disableIfNeeded();
            this.isPinned = true;
        }
    }

    @Override
    public void onEntryContentChange() {
        this.logModel.uiExec(this.logModel::update, 10);
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            FlutterLogView.$$$reportNull$$$0(4);
        }
        if (contentType == null) {
            FlutterLogView.$$$reportNull$$$0(5);
        }
        this.getFlutterLog().addConsoleEntry(text, contentType);
    }

    public void clear() {
        if (this.isPinned) {
            if (this.prePinAutoScroll) {
                this.scrollToEndAction.enableIfNeeded();
            } else {
                this.scrollToEndAction.disableIfNeeded();
            }
            this.isPinned = false;
        }
        this.dataPane.setVisible(false);
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.getFlutterLog().listenToProcess(processHandler, (Disposable)this);
    }

    public boolean isOutputPaused() {
        return false;
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            FlutterLogView.$$$reportNull$$$0(6);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            FlutterLogView.$$$reportNull$$$0(7);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            FlutterLogView.$$$reportNull$$$0(8);
        }
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            FlutterLogView.$$$reportNull$$$0(9);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray = new AnAction[]{this.scrollToEndAction, this.clearLogAction};
        if (anActionArray == null) {
            FlutterLogView.$$$reportNull$$$0(10);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FlutterLogView.$$$reportNull$$$0(11);
        }
        return null;
    }

    public JComponent getComponent() {
        return this.toolWindowPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.logTree;
    }

    private static void fixColumnWidth(@NotNull TableColumn column, int width) {
        if (column == null) {
            FlutterLogView.$$$reportNull$$$0(12);
        }
        column.setMinWidth(width);
        column.setMaxWidth(width);
        column.setPreferredWidth(width);
    }

    static {
        REGULAR_ATTRIBUTES = SimpleTextAttributes.GRAY_ATTRIBUTES;
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP = new HashMap<FlutterLog.Level, TextAttributesKey>();
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.NONE, FlutterLogConstants.NONE_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.FINEST, FlutterLogConstants.FINEST_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.FINER, FlutterLogConstants.FINER_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.FINE, FlutterLogConstants.FINE_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.CONFIG, FlutterLogConstants.CONFIG_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.INFO, FlutterLogConstants.INFO_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.WARNING, FlutterLogConstants.WARNING_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.SEVERE, FlutterLogConstants.SEVERE_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.SHOUT, FlutterLogConstants.SHOUT_OUTPUT_KEY);
        EFFECT_TYPE_TEXT_STYLE_MAP = new HashMap<EffectType, Integer>();
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.LINE_UNDERSCORE, 16);
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.WAVE_UNDERSCORE, 24);
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.BOLD_LINE_UNDERSCORE, 17);
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.STRIKEOUT, 4);
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.BOLD_DOTTED_LINE, 32);
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.SEARCH_MATCH, 64);
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.BOXED, null);
        EFFECT_TYPE_TEXT_STYLE_MAP.put(EffectType.ROUNDED_BOX, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlutterLog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fixColumnWidth";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class LogVerticalScrollChangeListener
    implements ChangeListener {
        private volatile int oldScrollValue = 0;

        private LogVerticalScrollChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof BoundedRangeModel) {
                boolean isScrollToEnd;
                BoundedRangeModel model = (BoundedRangeModel)e.getSource();
                int newScrollValue = model.getValue();
                boolean isScrollUp = newScrollValue < this.oldScrollValue;
                boolean bl = isScrollToEnd = newScrollValue + model.getExtent() == model.getMaximum();
                if (isScrollUp) {
                    this.onScrollUp();
                } else if (isScrollToEnd) {
                    this.onScrollToEnd();
                }
                this.oldScrollValue = newScrollValue;
            }
        }

        protected abstract void onScrollUp();

        protected abstract void onScrollToEnd();
    }

    private class FilterStatusLabel
    extends AnAction
    implements CustomComponentAction,
    RightAlignedToolbarAction,
    FlutterLogTree.EventCountListener {
        JBLabel label;
        JPanel panel;

        private FilterStatusLabel() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterStatusLabel.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation) {
            if (presentation == null) {
                FilterStatusLabel.$$$reportNull$$$0(1);
            }
            this.panel = new JPanel();
            this.label = new JBLabel();
            this.label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.label.setForeground(UIUtil.getInactiveTextColor());
            this.label.setBorder((Border)JBUI.Borders.emptyRight((int)10));
            this.panel.add((Component)this.label);
            FlutterLogView.this.logTree.addListener(this, (Disposable)FlutterLogView.this);
            JPanel jPanel = this.panel;
            if (jPanel == null) {
                FilterStatusLabel.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        @Override
        public void updated(int total, int filtered) {
            if (this.label != null && this.label.isVisible()) {
                int visibleCount = total - filtered;
                StringBuilder sb = new StringBuilder();
                sb.append(visibleCount).append(" event");
                if (visibleCount != 1) {
                    sb.append("s");
                }
                if (filtered > 0) {
                    sb.append(" (").append(filtered).append(" filtered)");
                }
                this.label.setText(sb.toString());
                SwingUtilities.invokeLater(this.panel::repaint);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/logging/FlutterLogView$FilterStatusLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/logging/FlutterLogView$FilterStatusLabel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class CopyToClipboardAction
    extends AnAction {
        CopyToClipboardAction() {
            super("Copy as Text", "Copy selected entries to the clipboard", AllIcons.Actions.Copy);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyToClipboardAction.$$$reportNull$$$0(0);
            }
            FlutterLogView.this.logTree.sendSelectedLogsToClipboard();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/logging/FlutterLogView$CopyToClipboardAction", "actionPerformed"));
        }
    }

    private class ScrollToEndAction
    extends ToggleAction {
        @NotNull
        private final AnActionEvent EMPTY_ACTION_EVENT;

        ScrollToEndAction() {
            super("Scroll to the end", "Scroll to the end", AllIcons.RunConfigurations.Scroll_down);
            this.EMPTY_ACTION_EVENT = AnActionEvent.createFromDataContext((String)"empty_action_event", null, (DataContext)DataContext.EMPTY_CONTEXT);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToEndAction.$$$reportNull$$$0(0);
            }
            return ((FlutterLogView)FlutterLogView.this).logModel.autoScrollToEnd;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ScrollToEndAction.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                ((FlutterLogView)FlutterLogView.this).logModel.autoScrollToEnd = state;
                if (state) {
                    FlutterLogView.this.logModel.scrollToEnd();
                }
            });
        }

        public void enableIfNeeded() {
            if (!this.isSelected(this.EMPTY_ACTION_EVENT)) {
                this.setSelected(this.EMPTY_ACTION_EVENT, true);
            }
        }

        public void disableIfNeeded() {
            if (this.isSelected(this.EMPTY_ACTION_EVENT)) {
                this.setSelected(this.EMPTY_ACTION_EVENT, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ScrollToEndAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClearLogAction
    extends AnAction {
        ClearLogAction() {
            super("Clear All", "Clear the log", AllIcons.Actions.GC);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearLogAction.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                FlutterLogView.this.logTree.clearEntries();
                FlutterLogView.this.clear();
            });
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearLogAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(FlutterLogView.this.logModel.getRoot().getChildCount() > 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ClearLogAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ConfigureChannelsAction
    extends AnAction {
        ConfigureChannelsAction() {
            super("Configure channels...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigureChannelsAction.$$$reportNull$$$0(0);
            }
            ((CompletableFuture)FlutterLogView.this.app.getFlutterLog().getLoggingChannels().thenAccept(channels -> ApplicationManager.getApplication().invokeAndWait(() -> {
                ChannelPanel panel = new ChannelPanel((List<LoggingChannel>)channels);
                Rectangle visibleRect = FlutterLogView.this.logTree.getVisibleRect();
                Point topRight = new Point(((FlutterLogView)FlutterLogView.this).logTree.getLocationOnScreen().x + visibleRect.width - 150, ((FlutterLogView)FlutterLogView.this).logTree.getLocationOnScreen().y + visibleRect.y);
                JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)panel).setTitle("Logging channels").setMovable(true).setRequestFocus(true).createPopup().show(RelativePoint.fromScreen((Point)topRight));
            }))).exceptionally(throwable -> {
                throwable.printStackTrace();
                return null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/logging/FlutterLogView$ConfigureChannelsAction", "actionPerformed"));
        }
    }

    private class ChannelPanel
    extends JPanel {
        ChannelPanel(List<LoggingChannel> channels) {
            this.setLayout(new GridLayout(0, 1));
            channels.forEach(c -> this.add((Component)((Object)new LoggerCheckBox((LoggingChannel)c))));
        }

        class LoggerCheckBox
        extends JBCheckBox
        implements ActionListener {
            @NotNull
            private final LoggingChannel channel;

            LoggerCheckBox(LoggingChannel channel) {
                if (channel == null) {
                    LoggerCheckBox.$$$reportNull$$$0(0);
                }
                super(channel.name);
                this.channel = channel;
                this.setToolTipText(channel.description);
                this.setSelected(channel.enabled);
                this.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FlutterLogView.this.app.getFlutterLog().enable(this.channel, this.isSelected());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "io/flutter/logging/FlutterLogView$ChannelPanel$LoggerCheckBox", "<init>"));
            }
        }
    }

    private class ShowColorsAction
    extends ToggleAction {
        ShowColorsAction() {
            super("Color entries");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowColorsAction.$$$reportNull$$$0(0);
            }
            return FlutterLogView.this.flutterLogPreferences.isShowColor();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowColorsAction.$$$reportNull$$$0(1);
            }
            FlutterLogView.this.flutterLogPreferences.setShowColor(state);
            ((FlutterLogView)FlutterLogView.this).entryModel.showColors = state;
            FlutterLogView.this.logModel.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ShowColorsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClearOnRestartAction
    extends ToggleAction {
        ClearOnRestartAction() {
            super("Clear on restart");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearOnRestartAction.$$$reportNull$$$0(0);
            }
            return FlutterLogView.this.flutterLogPreferences.isClearOnRestart();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ClearOnRestartAction.$$$reportNull$$$0(1);
            }
            FlutterLogView.this.flutterLogPreferences.setClearOnRestart(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ClearOnRestartAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClearOnReloadAction
    extends ToggleAction {
        ClearOnReloadAction() {
            super("Clear on reload");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearOnReloadAction.$$$reportNull$$$0(0);
            }
            return FlutterLogView.this.flutterLogPreferences.isClearOnReload();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ClearOnReloadAction.$$$reportNull$$$0(1);
            }
            FlutterLogView.this.flutterLogPreferences.setClearOnReload(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ClearOnReloadAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowLevelAction
    extends ToggleAction {
        ShowLevelAction() {
            super("Show log levels");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowLevelAction.$$$reportNull$$$0(0);
            }
            return FlutterLogView.this.flutterLogPreferences.isShowLogLevel();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowLevelAction.$$$reportNull$$$0(1);
            }
            FlutterLogView.this.flutterLogPreferences.setShowLogLevel(state);
            FlutterLogView.this.logModel.setShowLogLevels(state);
            FlutterLogView.this.logModel.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ShowLevelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowCategoryAction
    extends ToggleAction {
        ShowCategoryAction() {
            super("Show categories");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowCategoryAction.$$$reportNull$$$0(0);
            }
            return FlutterLogView.this.flutterLogPreferences.isShowLogCategory();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowCategoryAction.$$$reportNull$$$0(1);
            }
            FlutterLogView.this.flutterLogPreferences.setShowLogCategory(state);
            FlutterLogView.this.logModel.setShowCategories(state);
            FlutterLogView.this.logModel.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ShowCategoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowSequenceNumbersAction
    extends ToggleAction {
        ShowSequenceNumbersAction() {
            super("Show sequence numbers");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSequenceNumbersAction.$$$reportNull$$$0(0);
            }
            return FlutterLogView.this.flutterLogPreferences.isShowSequenceNumbers();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowSequenceNumbersAction.$$$reportNull$$$0(1);
            }
            FlutterLogView.this.flutterLogPreferences.setShowSequenceNumbers(state);
            FlutterLogView.this.logModel.setShowSequenceNumbers(state);
            FlutterLogView.this.logModel.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ShowSequenceNumbersAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowTimeStampsAction
    extends ToggleAction {
        ShowTimeStampsAction() {
            super("Show timestamps");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowTimeStampsAction.$$$reportNull$$$0(0);
            }
            return FlutterLogView.this.flutterLogPreferences.isShowTimestamp();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowTimeStampsAction.$$$reportNull$$$0(1);
            }
            FlutterLogView.this.flutterLogPreferences.setShowTimestamp(state);
            FlutterLogView.this.logModel.setShowTimestamps(state);
            FlutterLogView.this.logModel.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "io/flutter/logging/FlutterLogView$ShowTimeStampsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class ConfigureAction
    extends AnAction
    implements RightAlignedToolbarAction {
        @NotNull
        private final DefaultActionGroup actionGroup;

        public ConfigureAction() {
            super("Configure", null, AllIcons.General.GearPlain);
            this.actionGroup = this.createPopupActionGroup();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigureAction.$$$reportNull$$$0(0);
            }
            this.getComponentOfActionEvent(e).ifPresent(component -> {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)this.actionGroup);
                popupMenu.getComponent().show((Component)component, component.getWidth(), 0);
            });
        }

        @NotNull
        private Optional<JComponent> getComponentOfActionEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigureAction.$$$reportNull$$$0(1);
            }
            JComponent component = UIUtils.getComponentOfActionEvent(e);
            Optional<JComponent> optional = Optional.ofNullable(component);
            if (optional == null) {
                ConfigureAction.$$$reportNull$$$0(2);
            }
            return optional;
        }

        @NotNull
        private DefaultActionGroup createPopupActionGroup() {
            DefaultActionGroup actionGroup;
            DefaultActionGroup defaultActionGroup = actionGroup = new DefaultActionGroup(new AnAction[]{new ShowTimeStampsAction(), new ShowSequenceNumbersAction(), new ShowLevelAction(), new ShowCategoryAction(), new Separator(), new ClearOnRestartAction(), new ClearOnReloadAction(), new Separator(), new ShowColorsAction()});
            if (defaultActionGroup == null) {
                ConfigureAction.$$$reportNull$$$0(3);
            }
            return defaultActionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/logging/FlutterLogView$ConfigureAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/logging/FlutterLogView$ConfigureAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponentOfActionEvent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponentOfActionEvent";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class EntryModel
    implements FlutterLogTree.EntryModel {
        boolean showColors;

        private EntryModel() {
        }

        @Override
        public SimpleTextAttributes style(@Nullable FlutterLogEntry entry, int attributes) {
            if (this.showColors && entry != null) {
                FlutterLog.Level level = FlutterLog.Level.forValue(entry.getLevel());
                return this.getTextAttributesByLogLevel(level);
            }
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        @NotNull
        private SimpleTextAttributes getTextAttributesByLogLevel(@NotNull FlutterLog.Level level) {
            if (level == null) {
                EntryModel.$$$reportNull$$$0(0);
            }
            if (FlutterLogView.this.textAttributesByLogLevelCache.containsKey((Object)level)) {
                SimpleTextAttributes simpleTextAttributes = (SimpleTextAttributes)FlutterLogView.this.textAttributesByLogLevelCache.get((Object)level);
                if (simpleTextAttributes == null) {
                    EntryModel.$$$reportNull$$$0(1);
                }
                return simpleTextAttributes;
            }
            SimpleTextAttributes simpleTextAttributes = REGULAR_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                EntryModel.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/logging/FlutterLogView$EntryModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/logging/FlutterLogView$EntryModel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributesByLogLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextAttributesByLogLevel";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

