/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogEntryPopup;
import io.flutter.logging.FlutterLogFilterPanel;
import io.flutter.logging.FlutterLogPreferences;
import io.flutter.logging.FlutterTreeTableModel;
import io.flutter.logging.tree.CategoryCellRenderer;
import io.flutter.logging.tree.LevelCellRenderer;
import io.flutter.logging.tree.MessageCellRenderer;
import io.flutter.logging.tree.SequenceCellRenderer;
import io.flutter.logging.tree.TimeCellRenderer;
import io.flutter.run.daemon.FlutterApp;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogTree
extends TreeTable {
    private static final Logger LOG = Logger.getInstance(FlutterLogTree.class);
    private static final RowFilter<TableModel, Object> EMPTY_FILTER = new RowFilter<TableModel, Object>(){

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ?> entry) {
            return true;
        }
    };
    private final EventDispatcher<EventCountListener> countDispatcher;
    private final EventDispatcher<SelectionListener> selectionEventDispatcher;
    private final TreeModel model;
    private FlutterLogFilterPanel.FilterParam filter;
    @NotNull
    private final TableRowSorter<TableModel> rowSorter;
    @NotNull
    private final FlutterLogEntryPopup flutterLogPopup;

    public FlutterLogTree(@NotNull FlutterApp app, @NotNull EntryModel entryModel, @NotNull Disposable parent) {
        if (app == null) {
            FlutterLogTree.$$$reportNull$$$0(0);
        }
        if (entryModel == null) {
            FlutterLogTree.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            FlutterLogTree.$$$reportNull$$$0(2);
        }
        this(new TreeModel(app, entryModel, parent));
    }

    FlutterLogTree(@NotNull TreeModel model) {
        if (model == null) {
            FlutterLogTree.$$$reportNull$$$0(3);
        }
        super((TreeTableModel)model);
        this.countDispatcher = EventDispatcher.create(EventCountListener.class);
        this.selectionEventDispatcher = EventDispatcher.create(SelectionListener.class);
        model.setTree((JTree)this.getTree());
        this.model = model;
        TableModel tableModel = this.getModel();
        this.rowSorter = new TableRowSorter<FlutterTreeTableModel>(new FlutterTreeTableModel(this));
        this.setRowSorter(this.rowSorter);
        this.registerCopyHandler();
        this.flutterLogPopup = new FlutterLogEntryPopup();
        this.addMouseListener(new SimpleMouseListener(){

            @Override
            public void mouseDoublePressed(MouseEvent e) {
                String selectedLog = FlutterLogTree.this.getSelectedLog();
                if (StringUtils.isNotEmpty((String)selectedLog)) {
                    FlutterLogTree.this.flutterLogPopup.showLogDialog(selectedLog);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    FlutterLogTree.this.getTree().setSelectionRow(FlutterLogTree.this.getSelectedRow() + 1);
                } else if (e.getKeyCode() == 38) {
                    FlutterLogTree.this.getTree().setSelectionRow(FlutterLogTree.this.getSelectedRow() - 1);
                }
            }
        });
        this.rowSorter.setRowFilter(EMPTY_FILTER);
        this.rowSorter.addRowSorterListener(e -> this.updateCounter());
        this.getTree().addTreeSelectionListener(e -> ((SelectionListener)this.selectionEventDispatcher.getMulticaster()).selectionChanged());
    }

    List<FlutterEventNode> getSelectedNodes() {
        ArrayList<FlutterEventNode> nodes = new ArrayList<FlutterEventNode>();
        for (int row : this.getSelectedRows()) {
            Object pathComponent;
            int realRow = this.convertRowIndexToModel(row);
            TreePath pathForRow = this.getTree().getPathForRow(realRow);
            if (pathForRow == null || !((pathComponent = pathForRow.getLastPathComponent()) instanceof FlutterEventNode)) continue;
            nodes.add((FlutterEventNode)pathComponent);
        }
        return nodes;
    }

    @NotNull
    private String getSelectedLog() {
        StringBuilder logBuilder = new StringBuilder();
        for (FlutterEventNode node : this.getSelectedNodes()) {
            node.describeTo(logBuilder);
        }
        String string = logBuilder.toString();
        if (string == null) {
            FlutterLogTree.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void sendSelectedLogsToClipboard() {
        ApplicationManager.getApplication().invokeLater(() -> {
            String log = this.getSelectedLog();
            if (StringUtils.isNotEmpty((String)log)) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(log);
                clipboard.setContents(selection, selection);
            }
        });
    }

    private void registerCopyHandler() {
        AnAction actionCopy = ActionManager.getInstance().getAction("$Copy");
        ShortcutSet copyShortcutSet = actionCopy.getShortcutSet();
        String copyCommand = "flutter.log.copyCommand";
        Arrays.stream(copyShortcutSet.getShortcuts()).filter(shortcut -> shortcut instanceof KeyboardShortcut).map(shortcut -> (KeyboardShortcut)shortcut).flatMap(shortcut -> Stream.of(shortcut.getFirstKeyStroke(), shortcut.getSecondKeyStroke())).filter(Objects::nonNull).forEach(stroke -> this.getInputMap().put((KeyStroke)stroke, "flutter.log.copyCommand"));
        this.getActionMap().put("flutter.log.copyCommand", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlutterLogTree.this.sendSelectedLogsToClipboard();
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionEventDispatcher.addListener((EventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionEventDispatcher.removeListener((EventListener)listener);
    }

    public void addListener(@NotNull EventCountListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            FlutterLogTree.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            FlutterLogTree.$$$reportNull$$$0(6);
        }
        this.countDispatcher.addListener((EventListener)listener, parent);
    }

    public void removeListener(@NotNull EventCountListener listener) {
        if (listener == null) {
            FlutterLogTree.$$$reportNull$$$0(7);
        }
        this.countDispatcher.removeListener((EventListener)listener);
    }

    @NotNull
    TreeModel getLogTreeModel() {
        TreeModel treeModel = this.model;
        if (treeModel == null) {
            FlutterLogTree.$$$reportNull$$$0(8);
        }
        return treeModel;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.model.columns.getRenderer(column);
    }

    public void setFilter(@NotNull FlutterLogFilterPanel.FilterParam filter) {
        if (filter == null) {
            FlutterLogTree.$$$reportNull$$$0(9);
        }
        if (Objects.equals(this.filter, filter)) {
            return;
        }
        this.filter = filter;
        this.rowSorter.setRowFilter(this.getRowFilter(filter));
    }

    private RowFilter<TableModel, Object> getRowFilter(@NotNull FlutterLogFilterPanel.FilterParam filter) {
        if (filter == null) {
            FlutterLogTree.$$$reportNull$$$0(10);
        }
        RowFilter<TableModel, Object> logLevelFilter = RowFilter.numberFilter(RowFilter.ComparisonType.AFTER, filter.getLogLevel().value - 1, FlutterTreeTableModel.ColumnIndex.LOG_LEVEL.index);
        RowFilter<TableModel, Object> expressionFilter = this.getExpressionFilter(filter);
        return expressionFilter != null ? RowFilter.andFilter(Arrays.asList(logLevelFilter, expressionFilter)) : logLevelFilter;
    }

    private RowFilter<TableModel, Object> getExpressionFilter(@NotNull FlutterLogFilterPanel.FilterParam filter) {
        String nonNullExpression;
        if (filter == null) {
            FlutterLogTree.$$$reportNull$$$0(11);
        }
        String string = nonNullExpression = filter.getExpression() == null ? "" : filter.getExpression();
        if (!nonNullExpression.isEmpty() || filter.isMatchCase() || filter.isRegex()) {
            String quoteRegex = filter.isRegex() ? nonNullExpression : Pattern.quote(nonNullExpression);
            String matchCaseRegex = filter.isMatchCase() ? "" : "(?i)";
            String standardRegex = matchCaseRegex + "(?s).*" + quoteRegex + ".*";
            try {
                return RowFilter.regexFilter(standardRegex, FlutterTreeTableModel.ColumnIndex.MESSAGE.index, FlutterTreeTableModel.ColumnIndex.CATEGORY.index);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    void append(@NotNull FlutterLogEntry entry, boolean selectNode) {
        if (entry == null) {
            FlutterLogTree.$$$reportNull$$$0(12);
        }
        if (entry.getKind() == FlutterLogEntry.Kind.RELOAD && this.model.getLogPreferences().isClearOnReload() || entry.getKind() == FlutterLogEntry.Kind.RESTART && this.model.getLogPreferences().isClearOnRestart()) {
            this.clearEntries();
        }
        this.model.appendNode(entry, selectNode);
    }

    private void updateCounter() {
        int total = this.rowSorter.getModelRowCount();
        int filtered = total - this.rowSorter.getViewRowCount();
        ((EventCountListener)this.countDispatcher.getMulticaster()).updated(total, filtered);
    }

    public void clearEntries() {
        this.getTree().clearSelection();
        this.model.clearEntries();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryModel";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogTree";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRowFilter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionFilter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class SimpleMouseListener
    extends MouseAdapter {
        private SimpleMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.mouseDoublePressed(e);
            }
        }

        public abstract void mouseDoublePressed(MouseEvent var1);
    }

    public static interface EventCountListener
    extends EventListener {
        public void updated(int var1, int var2);
    }

    public static interface EntryModel {
        public SimpleTextAttributes style(@Nullable FlutterLogEntry var1, int var2);
    }

    public static class FlutterEventNode
    extends DefaultMutableTreeNode {
        final FlutterLogEntry entry;

        FlutterEventNode(FlutterLogEntry entry) {
            this.entry = entry;
        }

        public void describeTo(@NotNull StringBuilder buffer) {
            if (buffer == null) {
                FlutterEventNode.$$$reportNull$$$0(0);
            }
            buffer.append(TimeCellRenderer.TIMESTAMP_FORMAT.format(this.entry.getTimestamp())).append(" ").append(this.entry.getSequenceNumber()).append(" ").append(this.entry.getLevelName()).append(" ").append(this.entry.getCategory()).append(" ").append(this.entry.getMessage());
            if (!this.entry.getMessage().endsWith("\n")) {
                buffer.append("\n");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "io/flutter/logging/FlutterLogTree$FlutterEventNode", "describeTo"));
        }
    }

    static class LogRootTreeNode
    extends DefaultMutableTreeNode {
        LogRootTreeNode() {
        }
    }

    static class TreeModel
    extends ListTreeTableModelOnColumns {
        @NotNull
        private final ColumnModel columns;
        @NotNull
        private final FlutterLog log;
        @NotNull
        private final Alarm uiThreadAlarm;
        @NotNull
        final Timer updateTimer;
        boolean autoScrollToEnd;
        private List<TableColumn> tableColumns;
        private JScrollPane scrollPane;
        private TreeTable treeTable;
        private boolean color;
        private UpdateCallback updateCallback;
        @NotNull
        private final FlutterLogPreferences logPreferences;
        TreePath pathToSelectAndReveal;

        public TreeModel(@NotNull FlutterApp app, @NotNull EntryModel entryModel, @NotNull Disposable parent) {
            if (app == null) {
                TreeModel.$$$reportNull$$$0(0);
            }
            if (entryModel == null) {
                TreeModel.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                TreeModel.$$$reportNull$$$0(2);
            }
            this(new ColumnModel(app, entryModel), parent, FlutterLogPreferences.getInstance(app.getProject()));
        }

        private TreeModel(@NotNull ColumnModel columns, @NotNull Disposable parent, @NotNull FlutterLogPreferences logPreferences) {
            if (columns == null) {
                TreeModel.$$$reportNull$$$0(3);
            }
            if (parent == null) {
                TreeModel.$$$reportNull$$$0(4);
            }
            if (logPreferences == null) {
                TreeModel.$$$reportNull$$$0(5);
            }
            super((TreeNode)new LogRootTreeNode(), columns.getInfos());
            this.logPreferences = logPreferences;
            this.log = columns.app.getFlutterLog();
            this.columns = columns;
            this.autoScrollToEnd = true;
            this.setShowSequenceNumbers(false);
            this.uiThreadAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parent);
            this.updateTimer = new Timer(100, e -> this.uiExec(this::update, 0));
        }

        public void setUpdateCallback(UpdateCallback updateCallback) {
            this.updateCallback = updateCallback;
        }

        @NotNull
        public FlutterLogPreferences getLogPreferences() {
            FlutterLogPreferences flutterLogPreferences = this.logPreferences;
            if (flutterLogPreferences == null) {
                TreeModel.$$$reportNull$$$0(6);
            }
            return flutterLogPreferences;
        }

        void scrollToEnd() {
            if (this.scrollPane != null) {
                JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
                vertical.setValue(vertical.getMaximum());
            }
        }

        void uiExec(@NotNull Runnable runnable, int delayMillis) {
            if (runnable == null) {
                TreeModel.$$$reportNull$$$0(7);
            }
            if (!this.uiThreadAlarm.isDisposed()) {
                this.uiThreadAlarm.addRequest(runnable, delayMillis);
            }
        }

        void update() {
            this.columns.update();
            this.reload(this.getRoot());
            this.treeTable.updateUI();
            TreeTableTree tree = this.treeTable.getTree();
            tree.setSelectionRows(this.treeTable.getSelectedRows());
            if (this.pathToSelectAndReveal != null) {
                tree.setSelectionPath(this.pathToSelectAndReveal);
                tree.scrollPathToVisible(this.pathToSelectAndReveal);
                this.pathToSelectAndReveal = null;
            }
            if (this.updateCallback != null) {
                this.updateCallback.updated();
            }
            if (this.autoScrollToEnd) {
                this.uiExec(this::scrollToEnd, 100);
            }
        }

        public LogRootTreeNode getRoot() {
            return (LogRootTreeNode)super.getRoot();
        }

        public void setScrollPane(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
        }

        public void setTree(JTree tree) {
            super.setTree(tree);
            this.treeTable = ((TreeTableTree)tree).getTreeTable();
            this.columns.init(this.treeTable);
        }

        public void clearEntries() {
            this.log.clear();
            this.getRoot().removeAllChildren();
            this.update();
        }

        public void appendNode(FlutterLogEntry entry, boolean selectNode) {
            if (this.treeTable == null || this.uiThreadAlarm.isDisposed()) {
                return;
            }
            FlutterEventNode node = new FlutterEventNode(entry);
            this.getRoot().add(node);
            if (selectNode) {
                this.pathToSelectAndReveal = new TreePath(node.getPath());
            }
            if (this.updateTimer.isRunning()) {
                return;
            }
            this.updateTimer.restart();
        }

        public boolean shouldShowTimestamps() {
            return this.columns.isShowing("Time");
        }

        public void setShowTimestamps(boolean show) {
            this.columns.show("Time", show);
        }

        public boolean shouldShowSequenceNumbers() {
            return this.columns.isShowing("Sequence");
        }

        public void setShowSequenceNumbers(boolean show) {
            this.columns.show("Sequence", show);
        }

        public boolean shouldShowLogLevels() {
            return this.columns.isShowing("Level");
        }

        public void setShowLogLevels(boolean show) {
            this.columns.show("Level", show);
        }

        public void setShowCategories(boolean show) {
            this.columns.show("Category", show);
        }

        public boolean shouldShowCategories() {
            return this.columns.isShowing("Category");
        }

        void updateFromPreferences(@NotNull FlutterLogPreferences flutterLogPreferences) {
            if (flutterLogPreferences == null) {
                TreeModel.$$$reportNull$$$0(8);
            }
            this.setShowTimestamps(flutterLogPreferences.isShowTimestamp());
            this.setShowSequenceNumbers(flutterLogPreferences.isShowSequenceNumbers());
            this.setShowLogLevels(flutterLogPreferences.isShowLogLevel());
            this.setShowCategories(flutterLogPreferences.isShowLogCategory());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "app";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryModel";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logPreferences";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/logging/FlutterLogTree$TreeModel";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flutterLogPreferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/logging/FlutterLogTree$TreeModel";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogPreferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "uiExec";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFromPreferences";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static interface UpdateCallback {
            public void updated();
        }
    }

    static interface SelectionListener
    extends EventListener {
        public void selectionChanged();
    }

    private static class ColumnModel {
        private final List<Column> columns;
        private final FlutterApp app;
        boolean updateVisibility;
        private List<Column> visible;
        private ArrayList<TableColumn> tableColumns;
        private TreeTable treeTable;
        private static final TableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

        ColumnModel(@NotNull FlutterApp app, @NotNull EntryModel entryModel) {
            if (app == null) {
                ColumnModel.$$$reportNull$$$0(0);
            }
            if (entryModel == null) {
                ColumnModel.$$$reportNull$$$0(1);
            }
            this.columns = new ArrayList<Column>();
            this.app = app;
            this.columns.addAll(Arrays.asList(new Column("Time", (TableCellRenderer)((Object)new TimeCellRenderer(entryModel))), new Column("Sequence", (TableCellRenderer)((Object)new SequenceCellRenderer(entryModel))), new Column("Level", (TableCellRenderer)((Object)new LevelCellRenderer(entryModel))), new Column("Category", new CategoryCellRenderer(entryModel)), new Column("Message", (TableCellRenderer)((Object)new MessageCellRenderer(app, entryModel)))));
            this.visible = this.columns.stream().filter(c -> c.show).collect(Collectors.toList());
        }

        void show(String column, boolean show) {
            this.columns.forEach(c -> {
                if (Objects.equals(column, c.getName())) {
                    c.show = show;
                }
            });
            this.updateVisibility = true;
            this.visible = this.columns.stream().filter(c -> c.show).collect(Collectors.toList());
        }

        void update() {
            if (this.updateVisibility) {
                Collections.list(this.treeTable.getColumnModel().getColumns()).forEach(c -> this.treeTable.removeColumn(c));
                if (this.isShowing("Time")) {
                    this.treeTable.addColumn(this.tableColumns.get(0));
                }
                if (this.isShowing("Sequence")) {
                    this.treeTable.addColumn(this.tableColumns.get(1));
                }
                if (this.isShowing("Level")) {
                    this.treeTable.addColumn(this.tableColumns.get(2));
                }
                if (this.isShowing("Category")) {
                    this.treeTable.addColumn(this.tableColumns.get(3));
                }
                this.tableColumns.subList(4, this.tableColumns.size()).forEach(c -> this.treeTable.addColumn(c));
            }
            this.updateVisibility = false;
        }

        ColumnInfo[] getInfos() {
            return this.columns.toArray(new ColumnInfo[0]);
        }

        public TableCellRenderer getRenderer(int column) {
            return column < this.visible.size() ? this.visible.get(column).renderer : DEFAULT_RENDERER;
        }

        public boolean isShowing(String column) {
            for (Column c : this.columns) {
                if (!Objects.equals(column, c.getName())) continue;
                return c.show;
            }
            return false;
        }

        public void init(TreeTable table) {
            this.treeTable = table;
            this.tableColumns = Collections.list(table.getColumnModel().getColumns());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "app";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entryModel";
                    break;
                }
            }
            objectArray[1] = "io/flutter/logging/FlutterLogTree$ColumnModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        class Column
        extends ColumnInfo<DefaultMutableTreeNode, FlutterLogEntry> {
            boolean show;
            @NotNull
            private final TableCellRenderer renderer;

            Column(@NotNull String name, TableCellRenderer renderer) {
                if (name == null) {
                    Column.$$$reportNull$$$0(0);
                }
                if (renderer == null) {
                    Column.$$$reportNull$$$0(1);
                }
                super(name);
                this.show = true;
                this.renderer = renderer;
            }

            boolean isShowing() {
                return this.show;
            }

            @Nullable
            public FlutterLogEntry valueOf(DefaultMutableTreeNode node) {
                if (node instanceof FlutterEventNode) {
                    return ((FlutterEventNode)node).entry;
                }
                return null;
            }

            public TableCellRenderer getCustomizedRenderer(DefaultMutableTreeNode o, TableCellRenderer renderer) {
                return this.renderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "renderer";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/logging/FlutterLogTree$ColumnModel$Column";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

