/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.DefaultEditorKit;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

class FlutterLogEntryPopup {
    private static final String GOOGLE_SEARCH_QUERY = "https://www.google.com/search?q=%s";
    private static final String POPUP_TITLE = "Log Entry";
    @NotNull
    private final JTextArea logTextArea = this.createLogView();
    @NotNull
    private final JBScrollPane logScrollPane = new JBScrollPane((Component)this.logTextArea);

    void showLogDialog(@NotNull String log) {
        if (log == null) {
            FlutterLogEntryPopup.$$$reportNull$$$0(0);
        }
        this.logTextArea.setText(log);
        JOptionPane.showMessageDialog(null, this.logScrollPane, POPUP_TITLE, -1);
    }

    @NotNull
    private JTextArea createLogView() {
        JTextArea logTextArea = new JTextArea(10, 100);
        logTextArea.setWrapStyleWord(true);
        logTextArea.setLineWrap(true);
        logTextArea.setEditable(false);
        logTextArea.setComponentPopupMenu(this.createLogPopupMenu());
        JTextArea jTextArea = logTextArea;
        if (jTextArea == null) {
            FlutterLogEntryPopup.$$$reportNull$$$0(1);
        }
        return jTextArea;
    }

    @NotNull
    private JPopupMenu createLogPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        final DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
        copy.putValue("Name", "Copy");
        this.getCopyKeyStroke().ifPresent(stroke -> copy.putValue("AcceleratorKey", stroke));
        menu.add(copy);
        final AbstractAction search = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)String.format(FlutterLogEntryPopup.GOOGLE_SEARCH_QUERY, FlutterLogEntryPopup.this.logTextArea.getSelectedText()));
            }
        };
        search.putValue("Name", "Search with Google");
        menu.add(search);
        menu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                super.popupMenuWillBecomeVisible(e);
                String selectedLog = FlutterLogEntryPopup.this.logTextArea.getSelectedText();
                boolean isExistSelectedLog = StringUtils.isNotEmpty((String)selectedLog);
                copy.setEnabled(isExistSelectedLog);
                search.setEnabled(isExistSelectedLog);
            }
        });
        JPopupMenu jPopupMenu = menu;
        if (jPopupMenu == null) {
            FlutterLogEntryPopup.$$$reportNull$$$0(2);
        }
        return jPopupMenu;
    }

    @NotNull
    private Optional<KeyStroke> getCopyKeyStroke() {
        AnAction actionCopy = ActionManager.getInstance().getAction("$Copy");
        for (Shortcut shortcut : actionCopy.getShortcutSet().getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            Optional<KeyStroke> optional = Optional.of(((KeyboardShortcut)shortcut).getFirstKeyStroke());
            if (optional == null) {
                FlutterLogEntryPopup.$$$reportNull$$$0(3);
            }
            return optional;
        }
        Optional<KeyStroke> optional = Optional.empty();
        if (optional == null) {
            FlutterLogEntryPopup.$$$reportNull$$$0(4);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogEntryPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogEntryPopup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogPopupMenu";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyKeyStroke";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showLogDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

