/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import io.flutter.console.FlutterConsoleFilter;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorService;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.text.LineInfo;
import io.flutter.logging.text.LineParser;
import io.flutter.logging.text.StyledText;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StdoutJsonParser;
import io.flutter.vmService.HeapMonitor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogEntryParser {
    public static final String ERROR_CATEGORY = "flutter.error";
    public static final String GC_CATEGORY = "runtime.gc";
    public static final String LOG_CATEGORY = "flutter.log";
    public static final String TOOLS_CATEGORY = "flutter.tools";
    public static final String STDIO_STDOUT_CATEGORY = "stdout";
    public static int GC_EVENT_LEVEL = FlutterLog.Level.FINER.value;
    private static final NumberFormat nf = new DecimalFormat();
    private static final NumberFormat df1 = new DecimalFormat();
    private static final Logger LOG;
    private final EventDispatcher<FlutterLogEntry.ContentListener> contentChangedDispatcher;
    private FlutterApp app;
    private final LineHandler lineHandler;
    private CompletableFuture<InspectorService.ObjectGroup> inspectorObjectGroup;
    private final StdoutJsonParser stdoutParser;

    public void addListener(@NotNull FlutterLogEntry.ContentListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(1);
        }
        this.contentChangedDispatcher.addListener((EventListener)listener, parent);
    }

    public FlutterLogEntryParser(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(2);
        }
        this.contentChangedDispatcher = EventDispatcher.create(FlutterLogEntry.ContentListener.class);
        this.stdoutParser = new StdoutJsonParser();
        this.lineHandler = new LineHandler(FlutterLogEntryParser.createMessageFilters(project, module), null);
    }

    public FlutterDebugProcess getDebugProcess() {
        return this.app != null ? this.app.getFlutterDebugProcess() : null;
    }

    private List<FlutterLogEntry> parseLoggingEvent(@NotNull Event event) {
        Instance data;
        int setLevel;
        String str;
        if (event == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(3);
        }
        JsonObject json = event.getJson();
        JsonObject logRecord = json.get("logRecord").getAsJsonObject();
        Instance message = new Instance(logRecord.getAsJsonObject().get("message").getAsJsonObject());
        String category = LOG_CATEGORY;
        JsonObject loggerName = logRecord.getAsJsonObject().get("loggerName").getAsJsonObject();
        if (loggerName != null && (str = new Instance(loggerName).getValueAsString()) != null && !str.isEmpty()) {
            category = str;
        }
        int level = FlutterLogEntry.UNDEFINED_LEVEL.value;
        JsonElement levelElement = logRecord.getAsJsonObject().get("level");
        if (levelElement instanceof JsonPrimitive && (setLevel = levelElement.getAsInt()) > 0) {
            level = setLevel;
        }
        FlutterDebugProcess debugProcess = this.getDebugProcess();
        String messageStr = message.getValueAsString();
        final FlutterLogEntry entry = this.lineHandler.parseEntry(messageStr, category, level);
        if (message.getValueAsStringIsTruncated()) {
            entry.setMessage(messageStr + "...");
            if (debugProcess != null) {
                Isolate isolate = new Isolate(json.get("isolate").getAsJsonObject());
                debugProcess.getVmServiceWrapper().getObject(isolate.getId(), message.getId(), new GetObjectAdapter(){

                    @Override
                    public void received(Obj response) {
                        entry.setMessage(((Instance)response).getValueAsString());
                        ((FlutterLogEntry.ContentListener)FlutterLogEntryParser.this.contentChangedDispatcher.getMulticaster()).onContentUpdate();
                    }
                });
            }
        }
        if (!(data = new Instance(logRecord.getAsJsonObject().get("error").getAsJsonObject())).getValueAsStringIsTruncated()) {
            entry.setData(data.getValueAsString());
        } else if (debugProcess != null) {
            Isolate isolate = new Isolate(json.get("isolate").getAsJsonObject());
            debugProcess.getVmServiceWrapper().getObject(isolate.getId(), data.getId(), new GetObjectAdapter(){

                @Override
                public void received(Obj response) {
                    entry.setData(((Instance)response).getValueAsString());
                    ((FlutterLogEntry.ContentListener)FlutterLogEntryParser.this.contentChangedDispatcher.getMulticaster()).onContentUpdate();
                }

                @Override
                public void received(Sentinel response) {
                    entry.setData(null);
                    ((FlutterLogEntry.ContentListener)FlutterLogEntryParser.this.contentChangedDispatcher.getMulticaster()).onContentUpdate();
                }
            });
        }
        return Collections.singletonList(entry);
    }

    @NotNull
    private List<FlutterLogEntry> parseGCEvent(@NotNull Event event) {
        if (event == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(4);
        }
        IsolateRef isolateRef = event.getIsolate();
        HeapMonitor.HeapSpace newHeapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("new"));
        HeapMonitor.HeapSpace oldHeapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("old"));
        double time = newHeapSpace.getTime() + oldHeapSpace.getTime();
        int used = newHeapSpace.getUsed() + newHeapSpace.getExternal() + oldHeapSpace.getUsed() + oldHeapSpace.getExternal();
        int maxHeap = newHeapSpace.getCapacity() + oldHeapSpace.getCapacity();
        long timeMs = Math.round(time * 1000.0);
        double usedMB = (double)used / 1048576.0;
        double maxMB = (double)maxHeap / 1048576.0;
        String message = "collection time " + nf.format(timeMs) + "ms \u2022 " + df1.format(usedMB) + "MB used of " + df1.format(maxMB) + "MB \u2022 " + isolateRef.getId();
        List<FlutterLogEntry> list = Collections.singletonList(this.lineHandler.parseEntry(message, GC_CATEGORY, FlutterLogEntry.UNDEFINED_LEVEL.value));
        if (list == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static FlutterLogEntry.Kind parseKind(@NotNull String message, @NotNull String category) {
        if (message == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(6);
        }
        if (category == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(7);
        }
        if (category.equals(TOOLS_CATEGORY)) {
            if ((message = message.trim()).equals("Performing hot reload...") || message.equals("Initializing hot reload...")) {
                return FlutterLogEntry.Kind.RELOAD;
            }
            if (message.equals("Performing hot restart...") || message.equals("Initializing hot restart...")) {
                return FlutterLogEntry.Kind.RESTART;
            }
            if (message.startsWith("\u2550\u2550\u2561 EXCEPTION CAUGHT BY WIDGETS LIBRARY")) {
                return FlutterLogEntry.Kind.FLUTTER_ERROR;
            }
        }
        return FlutterLogEntry.Kind.UNSPECIFIED;
    }

    private static long timestamp(Event event) {
        return event.getTimestamp() == -1L ? System.currentTimeMillis() : event.getTimestamp();
    }

    @Nullable
    public List<FlutterLogEntry> parse(@Nullable String id, @Nullable Event event) {
        if (id != null && event != null) {
            switch (id) {
                case "Logging": 
                case "_Logging": {
                    return this.parseLoggingEvent(event);
                }
                case "GC": {
                    return this.parseGCEvent(event);
                }
                case "Extension": {
                    return this.parseExtensionEvent(event);
                }
            }
        }
        return null;
    }

    private List<FlutterLogEntry> parseExtensionEvent(@NotNull Event event) {
        JsonPrimitive extensionKind;
        if (event == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(8);
        }
        if (Objects.equals((extensionKind = event.getJson().getAsJsonPrimitive("extensionKind")).getAsString(), "Flutter.Error")) {
            return this.parseFlutterError(event.getJson());
        }
        return null;
    }

    private List<FlutterLogEntry> parseFlutterError(@NotNull JsonObject json) {
        if (json == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(9);
        }
        ArrayList<FlutterLogEntry> entries = new ArrayList<FlutterLogEntry>();
        JsonElement extensionData = json.get("extensionData");
        DiagnosticsNode diagnosticsNode = this.parseDiagnosticsNode(extensionData.getAsJsonObject());
        String description = diagnosticsNode.toString();
        FlutterLogEntry entry = this.lineHandler.parseEntry(description, ERROR_CATEGORY, FlutterLog.Level.SEVERE.value);
        entry.setKind(FlutterLogEntry.Kind.FLUTTER_ERROR);
        entry.setData(diagnosticsNode);
        entries.add(entry);
        return entries;
    }

    @NotNull
    private DiagnosticsNode parseDiagnosticsNode(@NotNull JsonObject json) {
        if (json == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(10);
        }
        assert (this.inspectorObjectGroup != null);
        assert (this.app != null);
        DiagnosticsNode diagnosticsNode = new DiagnosticsNode(json, this.inspectorObjectGroup, this.app, false, null);
        if (diagnosticsNode == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(11);
        }
        return diagnosticsNode;
    }

    @Nullable
    FlutterLogEntry parseDaemonEvent(@NotNull ProcessEvent event, @Nullable Key outputType) {
        String text;
        if (event == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(12);
        }
        if ((text = event.getText()).isEmpty()) {
            return null;
        }
        return this.parseDaemonEvent(text);
    }

    @NotNull
    static List<Filter> createMessageFilters(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(13);
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (module != null) {
            filters.add(new FlutterConsoleFilter(module));
        }
        filters.addAll(Arrays.asList(new DartConsoleFilter(project, project.getBaseDir()), new UrlFilter()));
        ArrayList<Filter> arrayList = filters;
        if (arrayList == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @VisibleForTesting
    @Nullable
    public FlutterLogEntry parseDaemonEvent(@NotNull String eventText) {
        if (eventText == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(15);
        }
        this.stdoutParser.appendOutput(eventText);
        for (String line : this.stdoutParser.getAvailableLines()) {
            if (DaemonApi.parseAndValidateDaemonEvent(line.trim()) != null) continue;
            if (line.startsWith("flutter:")) {
                line = line.substring(8);
            }
            line = line.replaceAll("\\\\\\^\\[", "\u001b");
            return this.lineHandler.parseEntry(line, TOOLS_CATEGORY, FlutterLogEntry.UNDEFINED_LEVEL.value);
        }
        return null;
    }

    public FlutterLogEntry parseConsoleEvent(String text, ConsoleViewContentType type) {
        if (type == ConsoleViewContentType.NORMAL_OUTPUT) {
            return this.parseDaemonEvent(text);
        }
        return null;
    }

    public void setVmServices(@NotNull FlutterApp app, @NotNull VmService vmService) {
        if (app == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(16);
        }
        if (vmService == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(17);
        }
        this.app = app;
        this.inspectorObjectGroup = InspectorService.createGroup(app, app.getFlutterDebugProcess(), vmService, "console-group");
    }

    static {
        df1.setMinimumFractionDigits(1);
        df1.setMaximumFractionDigits(1);
        LOG = Logger.getInstance(FlutterLogEntryParser.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogEntryParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogEntryParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGCEvent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDiagnosticsNode";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessageFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseLoggingEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseGCEvent";
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseKind";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseExtensionEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseFlutterError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseDiagnosticsNode";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseDaemonEvent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createMessageFilters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setVmServices";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineHandler
    extends LineParser {
        final List<StyledText> parsed;

        public LineHandler(@NotNull List<Filter> filters, @Nullable SimpleTextAttributes initialStyle) {
            if (filters == null) {
                LineHandler.$$$reportNull$$$0(0);
            }
            super(filters);
            this.parsed = new ArrayList<StyledText>();
            this.style = initialStyle;
        }

        @Override
        public void write(@NotNull StyledText styledText) {
            if (styledText == null) {
                LineHandler.$$$reportNull$$$0(1);
            }
            this.parsed.add(styledText);
        }

        public List<StyledText> parseLineStyle(@NotNull String line) {
            if (line == null) {
                LineHandler.$$$reportNull$$$0(2);
            }
            this.parse(line);
            ArrayList<StyledText> results = new ArrayList<StyledText>(this.parsed);
            this.parsed.clear();
            return results;
        }

        LineInfo parseLineInfo(@NotNull String line, @NotNull String category) {
            if (line == null) {
                LineHandler.$$$reportNull$$$0(3);
            }
            if (category == null) {
                LineHandler.$$$reportNull$$$0(4);
            }
            SimpleTextAttributes carriedOverStyle = this.style;
            FlutterLogEntry.Kind kind = FlutterLogEntryParser.parseKind(line, category);
            if (kind == FlutterLogEntry.Kind.RELOAD || kind == FlutterLogEntry.Kind.RESTART) {
                this.clear();
            }
            List<StyledText> styledText = this.parseLineStyle(line);
            return new LineInfo(line, styledText, kind, category, this.filters, carriedOverStyle);
        }

        FlutterLogEntry parseEntry(@NotNull String line, @NotNull String category, int level) {
            if (line == null) {
                LineHandler.$$$reportNull$$$0(5);
            }
            if (category == null) {
                LineHandler.$$$reportNull$$$0(6);
            }
            LineInfo lineInfo = this.parseLineInfo(line, category);
            return new FlutterLogEntry(System.currentTimeMillis(), lineInfo, level);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styledText";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/logging/FlutterLogEntryParser$LineHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseLineStyle";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseLineInfo";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseEntry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class GetObjectAdapter
    implements GetObjectConsumer {
        GetObjectAdapter() {
        }

        @Override
        public abstract void received(Obj var1);

        @Override
        public void received(Sentinel response) {
        }

        @Override
        public void onError(RPCError error) {
        }
    }
}

