/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogEntryParser;
import io.flutter.logging.text.LineInfo;
import io.flutter.logging.text.StyledText;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogEntry {
    public static final FlutterLog.Level UNDEFINED_LEVEL = FlutterLog.Level.INFO;
    private final long timestamp;
    @NotNull
    private final String category;
    private final int level;
    @NotNull
    private String message;
    @Nullable
    private Object data;
    private int sequenceNumber;
    @NotNull
    private Kind kind;
    private List<StyledText> styledText;
    @NotNull
    private final List<Filter> filters;
    @Nullable
    private final SimpleTextAttributes inheritedStyle;

    /*
     * WARNING - void declaration
     */
    public FlutterLogEntry(long timestamp, @NotNull String category, int level, @Nullable String message, @NotNull Kind kind, @NotNull List<StyledText> styledText, @NotNull List<Filter> filters, @Nullable SimpleTextAttributes simpleTextAttributes) {
        void inheritedStyle;
        if (category == null) {
            FlutterLogEntry.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            FlutterLogEntry.$$$reportNull$$$0(1);
        }
        if (styledText == null) {
            FlutterLogEntry.$$$reportNull$$$0(2);
        }
        if (filters == null) {
            FlutterLogEntry.$$$reportNull$$$0(3);
        }
        this.sequenceNumber = -1;
        this.timestamp = timestamp;
        this.category = category;
        this.level = level;
        this.message = StringUtil.notNullize((String)message);
        this.kind = kind;
        this.styledText = styledText;
        this.filters = filters;
        this.inheritedStyle = inheritedStyle;
    }

    /*
     * WARNING - void declaration
     */
    public FlutterLogEntry(long timestamp, @NotNull LineInfo info, int n) {
        void level;
        if (info == null) {
            FlutterLogEntry.$$$reportNull$$$0(4);
        }
        this(timestamp, info.getCategory(), (int)level, info.getLine(), info.getKind(), info.getStyledText(), info.getFilters(), info.getInheritedStyle());
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void setData(@Nullable Object data) {
        this.data = data;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = this.kind;
        if (kind == null) {
            FlutterLogEntry.$$$reportNull$$$0(5);
        }
        return kind;
    }

    public void setKind(@NotNull Kind kind) {
        if (kind == null) {
            FlutterLogEntry.$$$reportNull$$$0(6);
        }
        this.kind = kind;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getLevel() {
        return this.level;
    }

    @NotNull
    public String getLevelName() {
        String string = FlutterLog.Level.forValue(this.level).toDisplayString();
        if (string == null) {
            FlutterLogEntry.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getCategory() {
        String string = this.category;
        if (string == null) {
            FlutterLogEntry.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getMessage() {
        String string = this.message;
        if (string == null) {
            FlutterLogEntry.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setMessage(@NotNull String message) {
        if (message == null) {
            FlutterLogEntry.$$$reportNull$$$0(10);
        }
        this.message = message;
        this.styledText = null;
    }

    @NotNull
    public List<Filter> getFilters() {
        List<Filter> list = this.filters;
        if (list == null) {
            FlutterLogEntry.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<StyledText> getStyledText() {
        if (this.styledText == null) {
            this.styledText = this.calculateStyledText();
        }
        List<StyledText> list = this.styledText;
        if (list == null) {
            FlutterLogEntry.$$$reportNull$$$0(12);
        }
        return list;
    }

    private List<StyledText> calculateStyledText() {
        FlutterLogEntryParser.LineHandler lineHandler = new FlutterLogEntryParser.LineHandler(this.filters, this.inheritedStyle);
        LineInfo lineInfo = lineHandler.parseLineInfo(this.getMessage(), this.getCategory());
        return lineInfo.getStyledText();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styledText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogEntry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevelName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyledText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setKind";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Kind {
        RELOAD,
        RESTART,
        FLUTTER_ERROR,
        UNSPECIFIED;

    }

    static interface ContentListener
    extends EventListener {
        public void onContentUpdate();
    }
}

