/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.EventDispatcher;
import io.flutter.FlutterUtils;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogEntryParser;
import io.flutter.logging.LoggingChannel;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.VmServiceConsumers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLog
implements FlutterLogEntry.ContentListener {
    private static final Logger LOG = Logger.getInstance(FlutterLog.class);
    public static final String LOGGING_STREAM_ID_OLD = "_Logging";
    public static final String LOGGING_STREAM_ID = "Logging";
    private final EventDispatcher<Listener> dispatcher;
    private final FlutterLogEntryParser logEntryParser;
    private final List<FlutterLogEntry> entries;
    private FlutterApp app;

    public static boolean isLoggingEnabled() {
        return FlutterSettings.getInstance().useFlutterLogView();
    }

    public FlutterLog(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            FlutterLog.$$$reportNull$$$0(0);
        }
        this.dispatcher = EventDispatcher.create(Listener.class);
        this.entries = new ArrayList<FlutterLogEntry>();
        this.logEntryParser = new FlutterLogEntryParser(project, module);
        this.logEntryParser.addListener(this, (Disposable)project);
    }

    public void addConsoleEntry(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            FlutterLog.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            FlutterLog.$$$reportNull$$$0(2);
        }
        this.onEntry(this.logEntryParser.parseConsoleEvent(text, contentType));
    }

    public void addListener(@NotNull Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            FlutterLog.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            FlutterLog.$$$reportNull$$$0(4);
        }
        this.dispatcher.addListener((EventListener)listener, parent);
    }

    public void clear() {
        this.entries.clear();
    }

    private FlutterDebugProcess getDebugProcess() {
        return this.logEntryParser.getDebugProcess();
    }

    public CompletableFuture<List<LoggingChannel>> getLoggingChannels() {
        FlutterDebugProcess debugProcess = this.getDebugProcess();
        if (debugProcess != null) {
            return ((CompletableFuture)debugProcess.getApp().callServiceExtension("ext.flutter.logs.loggingChannels").thenApply(response -> {
                JsonObject value = response.getAsJsonObject("value");
                ArrayList<LoggingChannel> channels = new ArrayList<LoggingChannel>();
                for (String channel : value.keySet()) {
                    channels.add(LoggingChannel.fromJson(channel, value.getAsJsonObject(channel)));
                }
                return channels;
            })).exceptionally(e -> {
                FlutterUtils.warn(LOG, e);
                return Collections.emptyList();
            });
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public void enable(@NotNull LoggingChannel channel, boolean subscribe) {
        FlutterDebugProcess debugProcess;
        if (channel == null) {
            FlutterLog.$$$reportNull$$$0(5);
        }
        if ((debugProcess = this.getDebugProcess()) != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("channel", channel.name);
            params.put("enabled", subscribe);
            debugProcess.getApp().callServiceExtension("ext.flutter.logs.enable", params);
        }
    }

    public List<FlutterLogEntry> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            FlutterLog.$$$reportNull$$$0(6);
        }
        this.dispatcher.removeListener((EventListener)listener);
    }

    private void onEntry(@Nullable FlutterLogEntry entry) {
        if (entry != null) {
            this.entries.add(entry);
            entry.setSequenceNumber(this.entries.size());
            ((Listener)this.dispatcher.getMulticaster()).onEvent(entry);
        }
    }

    public void listenToProcess(@NotNull ProcessHandler processHandler, @NotNull Disposable parent) {
        if (processHandler == null) {
            FlutterLog.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            FlutterLog.$$$reportNull$$$0(8);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                FlutterLog.this.onEntry(FlutterLog.this.logEntryParser.parseDaemonEvent(event, outputType));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/logging/FlutterLog$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parent);
    }

    public void listenToVm(@NotNull VmService vmService) {
        if (vmService == null) {
            FlutterLog.$$$reportNull$$$0(9);
        }
        if (!FlutterLog.isLoggingEnabled()) {
            return;
        }
        this.logEntryParser.setVmServices(this.app, vmService);
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                FlutterLog.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
                FlutterLog.this.onVmConnectionClosed();
            }
        });
        vmService.streamListen(LOGGING_STREAM_ID_OLD, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.streamListen(LOGGING_STREAM_ID, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.streamListen("GC", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
    }

    private void onVmServiceReceived(String id, Event event) {
        List<FlutterLogEntry> entries = this.logEntryParser.parse(id, event);
        if (entries != null) {
            entries.forEach(this::onEntry);
        }
    }

    private void onVmConnectionClosed() {
    }

    public void setFlutterApp(FlutterApp app) {
        this.app = app;
    }

    @Override
    public void onContentUpdate() {
        ((Listener)this.dispatcher.getMulticaster()).onEntryContentChange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        objectArray2[1] = "io/flutter/logging/FlutterLog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addConsoleEntry";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "listenToProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "listenToVm";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Level {
        NONE(0),
        FINEST(300),
        FINER(400),
        FINE(500),
        CONFIG(700),
        INFO(800),
        WARNING(900),
        SEVERE(1000),
        SHOUT(1200);

        final int value;

        private Level(int value) {
            this.value = value;
        }

        @NotNull
        public static Level forValue(int value) {
            Level[] levels = Level.values();
            for (int i = levels.length - 1; i >= 0; --i) {
                if (value < levels[i].value) continue;
                Level level = levels[i];
                if (level == null) {
                    Level.$$$reportNull$$$0(0);
                }
                return level;
            }
            Level level = NONE;
            if (level == null) {
                Level.$$$reportNull$$$0(1);
            }
            return level;
        }

        public String toDisplayString() {
            return this.name().toLowerCase();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/logging/FlutterLog$Level", "forValue"));
        }
    }

    public static interface Listener
    extends EventListener {
        public void onEvent(@NotNull FlutterLogEntry var1);

        public void onEntryContentChange();
    }
}

