/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import io.flutter.inspector.InspectorService;
import io.flutter.utils.JsonUtils;
import java.util.ArrayList;

public class InspectorSourceLocation {
    private final JsonObject json;
    private final InspectorSourceLocation parent;

    public InspectorSourceLocation(JsonObject json, InspectorSourceLocation parent) {
        this.json = json;
        this.parent = parent;
    }

    public String getPath() {
        return JsonUtils.getStringMember(this.json, "file");
    }

    public VirtualFile getFile() {
        String fileName = this.getPath();
        if (fileName == null) {
            return this.parent != null ? this.parent.getFile() : null;
        }
        fileName = InspectorService.fromSourceLocationUri(fileName);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
        if (virtualFile != null && !virtualFile.exists()) {
            return null;
        }
        return virtualFile;
    }

    public int getLine() {
        return JsonUtils.getIntMember(this.json, "line");
    }

    public String getName() {
        return JsonUtils.getStringMember(this.json, "name");
    }

    public int getColumn() {
        return JsonUtils.getIntMember(this.json, "column");
    }

    public XSourcePosition getXSourcePosition() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        int line = this.getLine();
        int column = this.getColumn();
        if (line < 0 || column < 0) {
            return null;
        }
        return XSourcePositionImpl.create((VirtualFile)file, (int)(line - 1), (int)(column - 1));
    }

    ArrayList<InspectorSourceLocation> getParameterLocations() {
        if (this.json.has("parameterLocations")) {
            JsonArray parametersJson = this.json.getAsJsonArray("parameterLocations");
            ArrayList<InspectorSourceLocation> ret = new ArrayList<InspectorSourceLocation>();
            for (int i = 0; i < parametersJson.size(); ++i) {
                ret.add(new InspectorSourceLocation(parametersJson.get(i).getAsJsonObject(), this));
            }
            return ret;
        }
        return null;
    }
}

