/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.XSourcePosition;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.DiagnosticsPathNode;
import io.flutter.inspector.EvalOnDartLibrary;
import io.flutter.inspector.InspectorInstanceRef;
import io.flutter.inspector.InspectorSourceLocation;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.VmServiceConsumers;
import io.flutter.vmService.frame.DartVmServiceValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.SourceLocation;
import org.jetbrains.annotations.NotNull;

public class InspectorService
implements Disposable {
    private static int nextGroupId = 0;
    @NotNull
    private final FlutterApp app;
    @NotNull
    private final FlutterDebugProcess debugProcess;
    @NotNull
    private final VmService vmService;
    @NotNull
    private final Set<InspectorServiceClient> clients;
    @NotNull
    private final EvalOnDartLibrary inspectorLibrary;
    @NotNull
    private final Set<String> supportedServiceMethods;
    private final StreamSubscription<Boolean> setPubRootDirectoriesSubscription;

    public static CompletableFuture<ObjectGroup> createGroup(@NotNull FlutterApp app, @NotNull FlutterDebugProcess debugProcess, @NotNull VmService vmService, String groupName) {
        if (app == null) {
            InspectorService.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            InspectorService.$$$reportNull$$$0(1);
        }
        if (vmService == null) {
            InspectorService.$$$reportNull$$$0(2);
        }
        return InspectorService.create(app, debugProcess, vmService).thenApplyAsync(service -> service.createObjectGroup(groupName));
    }

    public static CompletableFuture<InspectorService> create(@NotNull FlutterApp app, @NotNull FlutterDebugProcess debugProcess, @NotNull VmService vmService) {
        if (app == null) {
            InspectorService.$$$reportNull$$$0(3);
        }
        if (debugProcess == null) {
            InspectorService.$$$reportNull$$$0(4);
        }
        if (vmService == null) {
            InspectorService.$$$reportNull$$$0(5);
        }
        assert (app.getVMServiceManager() != null);
        HashSet<String> inspectorLibraryNames = new HashSet<String>();
        inspectorLibraryNames.add("package:flutter/src/widgets/widget_inspector.dart");
        inspectorLibraryNames.add("package:flutter_web/src/widgets/widget_inspector.dart");
        EvalOnDartLibrary inspectorLibrary = new EvalOnDartLibrary(inspectorLibraryNames, vmService, app.getVMServiceManager());
        CompletionStage libraryFuture = inspectorLibrary.libraryRef.thenComposeAsync(library -> inspectorLibrary.getLibrary((LibraryRef)library, null));
        return ((CompletableFuture)((CompletableFuture)libraryFuture).thenComposeAsync(library -> {
            for (ClassRef classRef : library.getClasses()) {
                if (!"WidgetInspectorService".equals(classRef.getName())) continue;
                return inspectorLibrary.getClass(classRef, null).thenApplyAsync(classObj -> {
                    HashSet<String> functionNames = new HashSet<String>();
                    for (FuncRef funcRef : classObj.getFunctions()) {
                        functionNames.add(funcRef.getName());
                    }
                    return functionNames;
                });
            }
            throw new RuntimeException("WidgetInspectorService class not found");
        })).thenApplyAsync(supportedServiceMethods -> new InspectorService(app, debugProcess, vmService, inspectorLibrary, (Set<String>)supportedServiceMethods));
    }

    private InspectorService(@NotNull FlutterApp app, @NotNull FlutterDebugProcess debugProcess, @NotNull VmService vmService, @NotNull EvalOnDartLibrary inspectorLibrary, @NotNull Set<String> supportedServiceMethods) {
        if (app == null) {
            InspectorService.$$$reportNull$$$0(6);
        }
        if (debugProcess == null) {
            InspectorService.$$$reportNull$$$0(7);
        }
        if (vmService == null) {
            InspectorService.$$$reportNull$$$0(8);
        }
        if (inspectorLibrary == null) {
            InspectorService.$$$reportNull$$$0(9);
        }
        if (supportedServiceMethods == null) {
            InspectorService.$$$reportNull$$$0(10);
        }
        this.vmService = vmService;
        this.app = app;
        this.debugProcess = debugProcess;
        this.inspectorLibrary = inspectorLibrary;
        this.supportedServiceMethods = supportedServiceMethods;
        this.clients = new HashSet<InspectorServiceClient>();
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                InspectorService.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
            }
        });
        vmService.streamListen("Extension", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        assert (app.getVMServiceManager() != null);
        this.setPubRootDirectoriesSubscription = app.getVMServiceManager().hasServiceExtension("ext.flutter.inspector.setPubRootDirectories", available -> {
            if (!available.booleanValue()) {
                return;
            }
            ArrayList<String> rootDirectories = new ArrayList<String>();
            for (PubRoot root : app.getPubRoots()) {
                String path = root.getRoot().getCanonicalPath();
                if (SystemInfo.isWindows) {
                    path = "file:///" + path;
                }
                rootDirectories.add(path);
            }
            this.setPubRootDirectories(rootDirectories);
        });
    }

    private boolean useDaemonApi() {
        return !this.app.isFlutterIsolateSuspended();
    }

    public boolean isDetailsSummaryViewSupported() {
        return this.hasServiceMethod("getSelectedSummaryWidget");
    }

    private boolean hasServiceMethod(String methodName) {
        return this.supportedServiceMethods.contains(methodName);
    }

    @NotNull
    public FlutterDebugProcess getDebugProcess() {
        FlutterDebugProcess flutterDebugProcess = this.debugProcess;
        if (flutterDebugProcess == null) {
            InspectorService.$$$reportNull$$$0(11);
        }
        return flutterDebugProcess;
    }

    public FlutterApp getApp() {
        return this.debugProcess.getApp();
    }

    public ObjectGroup createObjectGroup(String debugName) {
        return new ObjectGroup(debugName);
    }

    @NotNull
    private EvalOnDartLibrary getInspectorLibrary() {
        EvalOnDartLibrary evalOnDartLibrary = this.inspectorLibrary;
        if (evalOnDartLibrary == null) {
            InspectorService.$$$reportNull$$$0(12);
        }
        return evalOnDartLibrary;
    }

    public void dispose() {
        this.inspectorLibrary.dispose();
        this.setPubRootDirectoriesSubscription.dispose();
    }

    public CompletableFuture<?> forceRefresh() {
        ArrayList futures = new ArrayList();
        for (InspectorServiceClient client : this.clients) {
            CompletableFuture<?> future = client.onForceRefresh();
            futures.add(future);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private void notifySelectionChanged() {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (InspectorServiceClient client : this.clients) {
                client.onInspectorSelectionChanged();
            }
        });
    }

    public void addClient(InspectorServiceClient client) {
        this.clients.add(client);
    }

    private void onVmServiceReceived(String streamId, Event event) {
        switch (streamId) {
            case "Debug": {
                if (event.getKind() != EventKind.Inspect) break;
                this.createObjectGroup("dummy").setSelection(event.getInspectee(), true);
                this.notifySelectionChanged();
                break;
            }
            case "Extension": {
                if (!"Flutter.Frame".equals(event.getExtensionKind())) break;
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (InspectorServiceClient client : this.clients) {
                        client.onFlutterFrame();
                    }
                });
                break;
            }
        }
    }

    public CompletableFuture<Boolean> isWidgetTreeReady() {
        if (this.useDaemonApi()) {
            return this.invokeServiceMethodDaemonNoGroup("isWidgetTreeReady", new HashMap<String, Object>()).thenApplyAsync(element -> element.getAsBoolean());
        }
        return this.invokeServiceMethodObservatoryNoGroup("isWidgetTreeReady").thenApplyAsync(ref -> "true".equals(ref.getValueAsString()));
    }

    CompletableFuture<JsonElement> invokeServiceMethodDaemonNoGroup(String methodName, List<String> args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < args.size(); ++i) {
            params.put("arg" + i, args.get(i));
        }
        return this.invokeServiceMethodDaemonNoGroup(methodName, params);
    }

    public CompletableFuture<String> inferPubRootDirectoryIfNeeded() {
        ObjectGroup group = this.createObjectGroup("temp");
        return group.getRoot(FlutterTreeType.widget).thenComposeAsync(root -> {
            if (root == null) {
                group.dispose();
                return CompletableFuture.completedFuture(null);
            }
            return root.getChildren().thenComposeAsync(children -> {
                if (children != null && !children.isEmpty()) {
                    return CompletableFuture.completedFuture(null);
                }
                return group.getChildren(root.getDartDiagnosticRef(), false, null).thenComposeAsync(allChildren -> {
                    if (allChildren == null || allChildren.isEmpty()) {
                        return null;
                    }
                    InspectorSourceLocation location = ((DiagnosticsNode)allChildren.get(0)).getCreationLocation();
                    if (location == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    String path = location.getPath();
                    if (path == null) {
                        group.dispose();
                        return CompletableFuture.completedFuture(null);
                    }
                    ArrayList<String> parts = new ArrayList<String>(Arrays.asList(path.split("/")));
                    String pubRootDirectory = null;
                    for (int i = parts.size() - 1; i >= 0; --i) {
                        String part = parts.get(i);
                        if (part.equals("lib") || part.equals("web")) {
                            pubRootDirectory = String.join((CharSequence)"/", parts.subList(0, i));
                            break;
                        }
                        if (!part.equals("packages")) continue;
                        pubRootDirectory = String.join((CharSequence)"/", parts.subList(0, i + 1));
                        break;
                    }
                    if (pubRootDirectory == null) {
                        parts.remove(parts.size() - 1);
                        pubRootDirectory = String.join((CharSequence)"/", parts);
                    }
                    String finalPubRootDirectory = pubRootDirectory;
                    return this.setPubRootDirectories(new ArrayList<Object>(Collections.singletonList(pubRootDirectory))).thenApplyAsync(ignored -> {
                        group.dispose();
                        return finalPubRootDirectory;
                    });
                });
            });
        });
    }

    private CompletableFuture<Void> setPubRootDirectories(List<String> rootDirectories) {
        if (this.useDaemonApi()) {
            return this.invokeServiceMethodDaemonNoGroup("setPubRootDirectories", rootDirectories).thenApplyAsync(ignored -> null);
        }
        JsonArray jsonArray = new JsonArray();
        for (String rootDirectory : rootDirectories) {
            jsonArray.add(rootDirectory);
        }
        return this.getInspectorLibrary().eval("WidgetInspectorService.instance.setPubRootDirectories(" + new Gson().toJson((JsonElement)jsonArray) + ")", null, null).thenApplyAsync(instance -> null);
    }

    CompletableFuture<InstanceRef> invokeServiceMethodObservatoryNoGroup(String methodName) {
        return this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "()", null, null);
    }

    CompletableFuture<JsonElement> invokeServiceMethodDaemonNoGroup(String methodName, Map<String, Object> params) {
        return this.getApp().callServiceExtension("ext.flutter.inspector." + methodName, params).thenApply(json -> {
            if (json.has("errorMessage")) {
                String message = json.get("errorMessage").getAsString();
                throw new RuntimeException(methodName + " -- " + message);
            }
            return json.get("result");
        });
    }

    public static String getFileUriPrefix() {
        return SystemInfo.isWindows ? "file:///" : "file://";
    }

    public static String toSourceLocationUri(String path) {
        return InspectorService.getFileUriPrefix() + path;
    }

    public static String fromSourceLocationUri(String path) {
        String filePrefix = InspectorService.getFileUriPrefix();
        return path.startsWith(filePrefix) ? path.substring(filePrefix.length()) : path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectorLibrary";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedServiceMethods";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspector/InspectorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspector/InspectorService";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGroup";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface InspectorServiceClient {
        public void onInspectorSelectionChanged();

        public void onFlutterFrame();

        public CompletableFuture<?> onForceRefresh();
    }

    public static enum FlutterTreeType {
        widget("Widget"),
        renderObject("Render");

        public final String displayName;

        private FlutterTreeType(String displayName) {
            this.displayName = displayName;
        }
    }

    public class ObjectGroup
    implements Disposable {
        final String groupName;
        volatile boolean disposed;
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private ObjectGroup(String debugName) {
            this.groupName = debugName + "_" + nextGroupId;
            nextGroupId++;
        }

        public void dispose() {
            this.lock.writeLock().lock();
            this.invokeVoidServiceMethod("disposeGroup", this.groupName);
            this.disposed = true;
            this.lock.writeLock().unlock();
        }

        private <T> CompletableFuture<T> nullIfDisposed(Supplier<CompletableFuture<T>> supplier) {
            this.lock.readLock().lock();
            if (this.disposed) {
                this.lock.readLock().unlock();
                return CompletableFuture.completedFuture(null);
            }
            try {
                CompletableFuture<T> completableFuture = supplier.get();
                return completableFuture;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private <T> T nullValueIfDisposed(Supplier<T> supplier) {
            this.lock.readLock().lock();
            if (this.disposed) {
                this.lock.readLock().unlock();
                return null;
            }
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void skipIfDisposed(Runnable runnable) {
            this.lock.readLock().lock();
            if (this.disposed) {
                return;
            }
            try {
                runnable.run();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public CompletableFuture<XSourcePosition> getPropertyLocation(InstanceRef instanceRef, String name) {
            return this.nullIfDisposed(() -> this.getInstance(instanceRef).thenComposeAsync(instance -> this.nullValueIfDisposed(() -> this.getPropertyLocationHelper(instance.getClassRef(), name))));
        }

        public CompletableFuture<XSourcePosition> getPropertyLocationHelper(ClassRef classRef, String name) {
            return this.nullIfDisposed(() -> InspectorService.this.inspectorLibrary.getClass(classRef, this).thenComposeAsync(clazz -> this.nullIfDisposed(() -> {
                for (FuncRef f : clazz.getFunctions()) {
                    if (!f.getName().equals(name)) continue;
                    return InspectorService.this.inspectorLibrary.getFunc(f, this).thenComposeAsync(func -> this.nullIfDisposed(() -> {
                        SourceLocation location = func.getLocation();
                        return InspectorService.this.inspectorLibrary.getSourcePosition(InspectorService.this.debugProcess, location.getScript(), location.getTokenPos(), this);
                    }));
                }
                ClassRef superClass = clazz.getSuperClass();
                return superClass == null ? CompletableFuture.completedFuture(null) : this.getPropertyLocationHelper(superClass, name);
            })));
        }

        public CompletableFuture<DiagnosticsNode> getRoot(FlutterTreeType type) {
            assert (!this.disposed);
            switch (type) {
                case widget: {
                    return this.getRootWidget();
                }
                case renderObject: {
                    return this.getRootRenderObject();
                }
            }
            throw new RuntimeException("Unexpected FlutterTreeType");
        }

        CompletableFuture<InstanceRef> invokeServiceMethodObservatory(String methodName) {
            return this.nullIfDisposed(() -> this.invokeServiceMethodObservatory(methodName, this.groupName));
        }

        CompletableFuture<InstanceRef> invokeServiceMethodObservatory(String methodName, String arg1) {
            return this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(\"" + arg1 + "\")", null, this));
        }

        CompletableFuture<JsonElement> invokeServiceMethodDaemon(String methodName) {
            return this.invokeServiceMethodDaemon(methodName, this.groupName);
        }

        CompletableFuture<JsonElement> invokeServiceMethodDaemon(String methodName, String objectGroup) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("objectGroup", objectGroup);
            return this.invokeServiceMethodDaemon(methodName, params);
        }

        CompletableFuture<JsonElement> invokeServiceMethodDaemon(String methodName, String arg, String objectGroup) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("arg", arg);
            params.put("objectGroup", objectGroup);
            return this.invokeServiceMethodDaemon(methodName, params);
        }

        CompletableFuture<JsonElement> invokeServiceMethodDaemon(String methodName, Map<String, Object> params) {
            return InspectorService.this.getInspectorLibrary().addRequest(this, () -> this.getApp().callServiceExtension("ext.flutter.inspector." + methodName, params).thenApply(json -> this.nullValueIfDisposed(() -> {
                if (json.has("errorMessage")) {
                    String message = json.get("errorMessage").getAsString();
                    throw new RuntimeException(methodName + " -- " + message);
                }
                return json.get("result");
            })));
        }

        CompletableFuture<JsonElement> invokeServiceMethodDaemon(String methodName, InspectorInstanceRef arg) {
            if (arg == null || arg.getId() == null) {
                return this.invokeServiceMethodDaemon(methodName, null, this.groupName);
            }
            return this.invokeServiceMethodDaemon(methodName, arg.getId(), this.groupName);
        }

        CompletableFuture<InstanceRef> invokeServiceMethodObservatory(String methodName, InspectorInstanceRef arg) {
            return this.nullIfDisposed(() -> {
                if (arg == null || arg.getId() == null) {
                    return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(null, \"" + this.groupName + "\")", null, this);
                }
                return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(\"" + arg.getId() + "\", \"" + this.groupName + "\")", null, this);
            });
        }

        CompletableFuture<InstanceRef> invokeServiceMethodOnRefObservatory(String methodName, InstanceRef arg) {
            return this.nullIfDisposed(() -> {
                HashMap<String, String> scope = new HashMap<String, String>();
                if (arg == null) {
                    return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(null, \"" + this.groupName + "\")", scope, this);
                }
                scope.put("arg1", arg.getId());
                return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(arg1, \"" + this.groupName + "\")", scope, this);
            });
        }

        CompletableFuture<DiagnosticsNode> parseDiagnosticsNodeObservatory(CompletableFuture<InstanceRef> instanceRefFuture) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(this::parseDiagnosticsNodeObservatory));
        }

        public CompletableFuture<Map<String, InstanceRef>> getDartObjectProperties(InspectorInstanceRef inspectorInstanceRef, String[] propertyNames) {
            return this.nullIfDisposed(() -> this.toObservatoryInstanceRef(inspectorInstanceRef).thenComposeAsync(instanceRef -> this.nullIfDisposed(() -> {
                StringBuilder sb = new StringBuilder();
                ArrayList<String> propertyAccessors = new ArrayList<String>();
                String objectName = "that";
                for (String propertyName : propertyNames) {
                    propertyAccessors.add("that." + propertyName);
                }
                sb.append("[");
                sb.append(Joiner.on((char)',').join(propertyAccessors));
                sb.append("]");
                HashMap<String, String> scope = new HashMap<String, String>();
                scope.put("that", instanceRef.getId());
                return this.getInstance(InspectorService.this.inspectorLibrary.eval(sb.toString(), scope, this)).thenApplyAsync(instance -> this.nullValueIfDisposed(() -> {
                    HashMap<String, InstanceRef> properties = new HashMap<String, InstanceRef>();
                    ElementList<InstanceRef> values = instance.getElements();
                    assert (values.size() == propertyNames.length);
                    for (int i = 0; i < propertyNames.length; ++i) {
                        properties.put(propertyNames[i], values.get(i));
                    }
                    return properties;
                }));
            })));
        }

        public CompletableFuture<InstanceRef> toObservatoryInstanceRef(InspectorInstanceRef inspectorInstanceRef) {
            return this.nullIfDisposed(() -> this.invokeServiceMethodObservatory("toObject", inspectorInstanceRef));
        }

        private CompletableFuture<Instance> getInstance(InstanceRef instanceRef) {
            return this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().getInstance(instanceRef, this));
        }

        CompletableFuture<Instance> getInstance(CompletableFuture<InstanceRef> instanceRefFuture) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(this::getInstance));
        }

        CompletableFuture<DiagnosticsNode> parseDiagnosticsNodeObservatory(InstanceRef instanceRef) {
            return this.nullIfDisposed(() -> this.instanceRefToJson(instanceRef).thenApplyAsync(this::parseDiagnosticsNodeHelper));
        }

        CompletableFuture<DiagnosticsNode> parseDiagnosticsNodeDaemon(CompletableFuture<JsonElement> json) {
            return this.nullIfDisposed(() -> json.thenApplyAsync(this::parseDiagnosticsNodeHelper));
        }

        DiagnosticsNode parseDiagnosticsNodeHelper(JsonElement jsonElement) {
            return this.nullValueIfDisposed(() -> {
                if (jsonElement == null || jsonElement.isJsonNull()) {
                    return null;
                }
                return new DiagnosticsNode(jsonElement.getAsJsonObject(), this, false, null);
            });
        }

        CompletableFuture<JsonElement> instanceRefToJson(InstanceRef instanceRef) {
            return this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().getInstance(instanceRef, this).thenApplyAsync(instance -> this.nullValueIfDisposed(() -> {
                String json = instance.getValueAsString();
                return new JsonParser().parse(json);
            })));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> parseDiagnosticsNodesObservatory(InstanceRef instanceRef, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> this.instanceRefToJson(instanceRef).thenApplyAsync(jsonElement -> this.nullValueIfDisposed(() -> {
                JsonArray jsonArray = jsonElement != null ? jsonElement.getAsJsonArray() : null;
                return this.parseDiagnosticsNodesHelper(jsonArray, parent);
            })));
        }

        ArrayList<DiagnosticsNode> parseDiagnosticsNodesHelper(JsonElement jsonObject, DiagnosticsNode parent) {
            return this.parseDiagnosticsNodesHelper(jsonObject != null ? jsonObject.getAsJsonArray() : null, parent);
        }

        ArrayList<DiagnosticsNode> parseDiagnosticsNodesHelper(JsonArray jsonArray, DiagnosticsNode parent) {
            return this.nullValueIfDisposed(() -> {
                if (jsonArray == null) {
                    return null;
                }
                ArrayList<DiagnosticsNode> nodes = new ArrayList<DiagnosticsNode>();
                for (JsonElement element : jsonArray) {
                    nodes.add(new DiagnosticsNode(element.getAsJsonObject(), this, false, parent));
                }
                return nodes;
            });
        }

        public CompletableFuture<DartVmServiceValue> toDartVmServiceValueForSourceLocation(InspectorInstanceRef inspectorInstanceRef) {
            return this.invokeServiceMethodObservatory("toObjectForSourceLocation", inspectorInstanceRef).thenApplyAsync(instanceRef -> this.nullValueIfDisposed(() -> new DartVmServiceValue(InspectorService.this.debugProcess, InspectorService.this.inspectorLibrary.getIsolateId(), "inspectedObject", (InstanceRef)instanceRef, null, null, false)));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> parseDiagnosticsNodesObservatory(CompletableFuture<InstanceRef> instanceRefFuture, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(instanceRef -> this.parseDiagnosticsNodesObservatory((InstanceRef)instanceRef, parent)));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> parseDiagnosticsNodesDaemon(CompletableFuture<JsonElement> jsonFuture, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> jsonFuture.thenApplyAsync(json -> this.parseDiagnosticsNodesHelper((JsonElement)json, parent)));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> getChildren(InspectorInstanceRef instanceRef, boolean summaryTree, DiagnosticsNode parent) {
            if (InspectorService.this.isDetailsSummaryViewSupported()) {
                return this.getListHelper(instanceRef, summaryTree ? "getChildrenSummaryTree" : "getChildrenDetailsSubtree", parent);
            }
            return this.getListHelper(instanceRef, "getChildren", parent);
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> getProperties(InspectorInstanceRef instanceRef) {
            return this.getListHelper(instanceRef, "getProperties", null);
        }

        private CompletableFuture<ArrayList<DiagnosticsNode>> getListHelper(InspectorInstanceRef instanceRef, String methodName, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useDaemonApi()) {
                    return this.parseDiagnosticsNodesDaemon(this.invokeServiceMethodDaemon(methodName, instanceRef), parent);
                }
                return this.parseDiagnosticsNodesObservatory(this.invokeServiceMethodObservatory(methodName, instanceRef), parent);
            });
        }

        public CompletableFuture<DiagnosticsNode> invokeServiceMethodReturningNode(String methodName) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useDaemonApi()) {
                    return this.parseDiagnosticsNodeDaemon(this.invokeServiceMethodDaemon(methodName));
                }
                return this.parseDiagnosticsNodeObservatory(this.invokeServiceMethodObservatory(methodName));
            });
        }

        public CompletableFuture<DiagnosticsNode> invokeServiceMethodReturningNode(String methodName, InspectorInstanceRef ref) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useDaemonApi()) {
                    return this.parseDiagnosticsNodeDaemon(this.invokeServiceMethodDaemon(methodName, ref));
                }
                return this.parseDiagnosticsNodeObservatory(this.invokeServiceMethodObservatory(methodName, ref));
            });
        }

        public CompletableFuture<Void> invokeVoidServiceMethod(String methodName, String arg1) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useDaemonApi()) {
                    return this.invokeServiceMethodDaemon(methodName, arg1).thenApply(ignored -> null);
                }
                return this.invokeServiceMethodObservatory(methodName, arg1).thenApply(ignored -> null);
            });
        }

        public CompletableFuture<Void> invokeVoidServiceMethod(String methodName, InspectorInstanceRef ref) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useDaemonApi()) {
                    return this.invokeServiceMethodDaemon(methodName, ref).thenApply(ignored -> null);
                }
                return this.invokeServiceMethodObservatory(methodName, ref).thenApply(ignored -> null);
            });
        }

        public CompletableFuture<DiagnosticsNode> getRootWidget() {
            return this.invokeServiceMethodReturningNode(InspectorService.this.isDetailsSummaryViewSupported() ? "getRootWidgetSummaryTree" : "getRootWidget");
        }

        public CompletableFuture<DiagnosticsNode> getSummaryTreeWithoutIds() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            return this.parseDiagnosticsNodeDaemon(this.invokeServiceMethodDaemon("getRootWidgetSummaryTree", params));
        }

        public CompletableFuture<DiagnosticsNode> getRootRenderObject() {
            assert (!this.disposed);
            return this.invokeServiceMethodReturningNode("getRootRenderObject");
        }

        public CompletableFuture<ArrayList<DiagnosticsPathNode>> getParentChain(DiagnosticsNode target) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useDaemonApi()) {
                    return this.parseDiagnosticsPathDaemon(this.invokeServiceMethodDaemon("getParentChain", target.getValueRef()));
                }
                return this.parseDiagnosticsPathObservatory(this.invokeServiceMethodObservatory("getParentChain", target.getValueRef()));
            });
        }

        CompletableFuture<ArrayList<DiagnosticsPathNode>> parseDiagnosticsPathObservatory(CompletableFuture<InstanceRef> instanceRefFuture) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(this::parseDiagnosticsPathObservatory));
        }

        private CompletableFuture<ArrayList<DiagnosticsPathNode>> parseDiagnosticsPathObservatory(InstanceRef pathRef) {
            return this.nullIfDisposed(() -> this.instanceRefToJson(pathRef).thenApplyAsync(this::parseDiagnosticsPathHelper));
        }

        CompletableFuture<ArrayList<DiagnosticsPathNode>> parseDiagnosticsPathDaemon(CompletableFuture<JsonElement> jsonFuture) {
            return this.nullIfDisposed(() -> jsonFuture.thenApplyAsync(this::parseDiagnosticsPathHelper));
        }

        private ArrayList<DiagnosticsPathNode> parseDiagnosticsPathHelper(JsonElement jsonElement) {
            return this.nullValueIfDisposed(() -> {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                ArrayList<DiagnosticsPathNode> pathNodes = new ArrayList<DiagnosticsPathNode>();
                for (JsonElement element : jsonArray) {
                    pathNodes.add(new DiagnosticsPathNode(element.getAsJsonObject(), this));
                }
                return pathNodes;
            });
        }

        public CompletableFuture<DiagnosticsNode> getSelection(DiagnosticsNode previousSelection, FlutterTreeType treeType, boolean localOnly) {
            assert (!this.disposed);
            return this.nullIfDisposed(() -> {
                CompletableFuture<DiagnosticsNode> result = null;
                InspectorInstanceRef previousSelectionRef = previousSelection != null ? previousSelection.getDartDiagnosticRef() : null;
                switch (treeType) {
                    case widget: {
                        result = this.invokeServiceMethodReturningNode(localOnly ? "getSelectedSummaryWidget" : "getSelectedWidget", previousSelectionRef);
                        break;
                    }
                    case renderObject: {
                        result = this.invokeServiceMethodReturningNode("getSelectedRenderObject", previousSelectionRef);
                    }
                }
                return result.thenApplyAsync(newSelection -> this.nullValueIfDisposed(() -> {
                    if (newSelection != null && newSelection.getDartDiagnosticRef().equals(previousSelectionRef)) {
                        return previousSelection;
                    }
                    return newSelection;
                }));
            });
        }

        public void setSelection(InspectorInstanceRef selection, boolean uiAlreadyUpdated) {
            if (this.disposed) {
                return;
            }
            if (InspectorService.this.useDaemonApi()) {
                this.handleSetSelectionDaemon(this.invokeServiceMethodDaemon("setSelectionById", selection), uiAlreadyUpdated);
            } else {
                this.handleSetSelectionObservatory(this.invokeServiceMethodObservatory("setSelectionById", selection), uiAlreadyUpdated);
            }
        }

        public void setSelection(InstanceRef selection, boolean uiAlreadyUpdated) {
            assert (!this.disposed);
            this.handleSetSelectionObservatory(this.invokeServiceMethodOnRefObservatory("setSelection", selection), uiAlreadyUpdated);
        }

        private void handleSetSelectionObservatory(CompletableFuture<InstanceRef> setSelectionResult, boolean uiAlreadyUpdated) {
            this.skipIfDisposed(() -> setSelectionResult.thenAcceptAsync(instanceRef -> this.skipIfDisposed(() -> this.handleSetSelectionHelper("true".equals(instanceRef.getValueAsString()), uiAlreadyUpdated))));
        }

        private void handleSetSelectionHelper(boolean selectionChanged, boolean uiAlreadyUpdated) {
            if (selectionChanged && !uiAlreadyUpdated) {
                InspectorService.this.notifySelectionChanged();
            }
        }

        private void handleSetSelectionDaemon(CompletableFuture<JsonElement> setSelectionResult, boolean uiAlreadyUpdated) {
            this.skipIfDisposed(() -> setSelectionResult.thenAcceptAsync(json -> this.skipIfDisposed(() -> this.handleSetSelectionHelper(json.getAsBoolean(), uiAlreadyUpdated))));
        }

        public CompletableFuture<Map<String, InstanceRef>> getEnumPropertyValues(InspectorInstanceRef ref) {
            return this.nullIfDisposed(() -> {
                if (ref == null || ref.getId() == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.getInstance(this.toObservatoryInstanceRef(ref)).thenComposeAsync(instance -> this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().getClass(instance.getClassRef(), this).thenApplyAsync(clazz -> this.nullValueIfDisposed(() -> {
                    LinkedHashMap<String, InstanceRef> properties = new LinkedHashMap<String, InstanceRef>();
                    for (FieldRef field : clazz.getFields()) {
                        String name = field.getName();
                        if (name.startsWith("_") || name.equals("values") || !field.isConst() || !field.isStatic()) continue;
                        properties.put(field.getName(), field.getDeclaredType());
                    }
                    return properties;
                }))));
            });
        }

        public CompletableFuture<DiagnosticsNode> getDetailsSubtree(DiagnosticsNode node) {
            if (node == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.nullIfDisposed(() -> this.invokeServiceMethodReturningNode("getDetailsSubtree", node.getDartDiagnosticRef()));
        }

        FlutterApp getApp() {
            return InspectorService.this.getApp();
        }

        public <T> void safeWhenComplete(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
            if (future == null) {
                return;
            }
            future.whenCompleteAsync((value, throwable) -> this.skipIfDisposed(() -> ApplicationManager.getApplication().invokeLater(() -> action.accept((Object)value, (Throwable)throwable))));
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

