/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.gson.JsonElement;
import io.flutter.inspector.HeapSamples;
import io.flutter.vmService.HeapMonitor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.VM;

public class HeapState
implements HeapMonitor.HeapListener {
    private static final DecimalFormat df = new DecimalFormat();
    private static final DecimalFormat df1 = new DecimalFormat();
    private int rssBytes;
    private int heapMaxInBytes;
    private final HeapSamples samples;
    private final Map<String, List<HeapMonitor.HeapSpace>> isolateHeaps = new HashMap<String, List<HeapMonitor.HeapSpace>>();

    public HeapState(int maxSampleSizeMs) {
        this.samples = new HeapSamples(maxSampleSizeMs);
    }

    public int getMaxSampleSizeMs() {
        return this.samples.maxSampleSizeMs;
    }

    public List<HeapMonitor.HeapSample> getSamples() {
        return this.samples.samples;
    }

    public int getCapacity() {
        int max = this.heapMaxInBytes;
        for (HeapMonitor.HeapSample sample : this.samples.samples) {
            max = Math.max(max, sample.getBytes());
        }
        return max;
    }

    private static String printMb(int bytes) {
        return df.format((double)bytes / 1048576.0) + "MB";
    }

    private static String printMb1(int bytes) {
        return df1.format((double)bytes / 1048576.0) + "MB";
    }

    public String getRSSSummary() {
        return HeapState.printMb(this.rssBytes) + " RSS";
    }

    public int getRssBytes() {
        return this.rssBytes;
    }

    public String getHeapSummary() {
        return HeapState.printMb1(this.samples.samples.getLast().getBytes()) + " of " + HeapState.printMb1(this.heapMaxInBytes);
    }

    public String getSimpleHeapSummary() {
        return HeapState.printMb(this.samples.samples.getLast().getBytes());
    }

    void addSample(HeapMonitor.HeapSample sample) {
        this.samples.add(sample);
    }

    @Override
    public void handleIsolatesInfo(VM vm, List<HeapMonitor.IsolateObject> isolates) {
        int current = 0;
        int total = 0;
        int external = 0;
        this.isolateHeaps.clear();
        for (HeapMonitor.IsolateObject isolate : isolates) {
            this.isolateHeaps.put(isolate.getId(), isolate.getHeaps());
            for (HeapMonitor.HeapSpace heap : isolate.getHeaps()) {
                current += heap.getUsed();
                total += heap.getCapacity();
                external += heap.getExternal();
            }
        }
        JsonElement rss = vm.getJson().get("_currentRSS");
        this.rssBytes = rss != null ? rss.getAsInt() : 0;
        this.heapMaxInBytes = total;
        this.addSample(new HeapMonitor.HeapSample(current, external, false));
    }

    @Override
    public void handleGCEvent(IsolateRef isolateRef, HeapMonitor.HeapSpace newHeapSpace, HeapMonitor.HeapSpace oldHeapSpace) {
        int current = 0;
        int external = 0;
        this.isolateHeaps.put(isolateRef.getId(), new ArrayList<HeapMonitor.HeapSpace>(Arrays.asList(newHeapSpace, oldHeapSpace)));
        for (List<HeapMonitor.HeapSpace> heaps : this.isolateHeaps.values()) {
            for (HeapMonitor.HeapSpace heap : heaps) {
                current += heap.getUsed();
                external += heap.getExternal();
            }
        }
        this.addSample(new HeapMonitor.HeapSample(current, external, true));
    }

    static {
        df.setMaximumFractionDigits(0);
        df1.setMaximumFractionDigits(1);
    }
}

