/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.inspector.HeapState;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.vmService.HeapMonitor;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.VM;
import org.jetbrains.annotations.Nullable;

public class HeapDisplay
extends JPanel {
    private static final int TEN_MB = 0xA00000;
    private static final Stroke GRAPH_STROKE = new BasicStroke(2.0f);
    @Nullable
    private final SummaryCallback summaryCallback;
    @Nullable
    private HeapState heapState;

    public static JPanel createJPanelView(Disposable parentDisposable, FlutterApp app) {
        final JPanel panel = new JPanel(new BorderLayout());
        JBLabel rssLabel = new JBLabel();
        rssLabel.setAlignmentY(1.0f);
        rssLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        rssLabel.setForeground(UIUtil.getLabelDisabledForeground());
        rssLabel.setBorder(JBUI.Borders.empty((int)4));
        JBLabel heapLabel = new JBLabel("", 4);
        heapLabel.setAlignmentY(1.0f);
        heapLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        heapLabel.setForeground(UIUtil.getLabelDisabledForeground());
        heapLabel.setBorder(JBUI.Borders.empty((int)4));
        final HeapState heapState = new HeapState(60000);
        final HeapDisplay graph = new HeapDisplay(state -> {
            rssLabel.setText(heapState.getRSSSummary());
            heapLabel.setText(heapState.getHeapSummary());
            SwingUtilities.invokeLater(() -> rssLabel.repaint());
            SwingUtilities.invokeLater(() -> heapLabel.repaint());
        });
        graph.setLayout(new BoxLayout(graph, 0));
        graph.add((Component)rssLabel);
        graph.add(Box.createHorizontalGlue());
        graph.add((Component)heapLabel);
        panel.add((Component)graph, "Center");
        HeapMonitor.HeapListener listener = new HeapMonitor.HeapListener(){

            @Override
            public void handleIsolatesInfo(VM vm, List<HeapMonitor.IsolateObject> isolates) {
                SwingUtilities.invokeLater(() -> {
                    heapState.handleIsolatesInfo(vm, isolates);
                    graph.updateFrom(heapState);
                    panel.repaint();
                });
            }

            @Override
            public void handleGCEvent(IsolateRef iIsolateRef, HeapMonitor.HeapSpace newHeapSpace, HeapMonitor.HeapSpace oldHeapSpace) {
                SwingUtilities.invokeLater(() -> {
                    heapState.handleGCEvent(iIsolateRef, newHeapSpace, oldHeapSpace);
                    graph.updateFrom(heapState);
                    panel.repaint();
                });
            }
        };
        assert (app.getVMServiceManager() != null);
        app.getVMServiceManager().addHeapListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> app.getVMServiceManager().removeHeapListener(listener));
        return panel;
    }

    private static Color getForegroundColor() {
        return UIUtil.getLabelDisabledForeground();
    }

    public HeapDisplay(@Nullable SummaryCallback summaryCallback) {
        this.summaryCallback = summaryCallback;
        this.setVisible(true);
    }

    private void updateFrom(HeapState state) {
        this.heapState = state;
        if (!this.heapState.getSamples().isEmpty()) {
            HeapMonitor.HeapSample sample = this.heapState.getSamples().get(0);
            if (this.summaryCallback != null) {
                this.summaryCallback.updatedSummary(state);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.heapState == null) {
            return;
        }
        int height = this.getHeight() - 1;
        int width = this.getWidth();
        long now = System.currentTimeMillis();
        long maxDataSize = Math.round((double)this.heapState.getCapacity() / 1.048576E7) * 0xA00000L + 0xA00000L;
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(HeapDisplay.getForegroundColor());
        graphics2D.setStroke(GRAPH_STROKE);
        Path2D.Double path = null;
        for (HeapMonitor.HeapSample sample : this.heapState.getSamples()) {
            double x = (double)width - (double)(now - sample.getSampleTime()) / (double)this.heapState.getMaxSampleSizeMs() * (double)width;
            double y = (double)height * (double)sample.getBytes() / (double)maxDataSize;
            if (path == null) {
                path = new Path2D.Double();
                ((Path2D)path).moveTo(x, (double)height - y + 1.0);
                continue;
            }
            ((Path2D)path).lineTo(x, (double)height - y + 1.0);
        }
        graphics2D.draw(path);
    }

    private static interface SummaryCallback {
        public void updatedSummary(HeapState var1);
    }
}

