/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.inspector.FrameRenderingPanel;
import io.flutter.inspector.StackLayout;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.vmService.FlutterFramesMonitor;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class FrameRenderingDisplay {
    static final DecimalFormat df = new DecimalFormat();
    private static final String TARGET_FRAME_RENDERING_TIME = "16ms";

    public static JPanel createJPanelView(Disposable parentDisposable, FlutterApp app) {
        JPanel panel = new JPanel(new StackLayout());
        panel.setDoubleBuffered(true);
        assert (app.getVMServiceManager() != null);
        FlutterFramesMonitor flutterFramesMonitor = app.getVMServiceManager().getFlutterFramesMonitor();
        FrameRenderingPanel frameRenderingPanel = new FrameRenderingPanel(flutterFramesMonitor);
        JBLabel latestFrameTimeLabel = new JBLabel();
        latestFrameTimeLabel.setAlignmentX(1.0f);
        latestFrameTimeLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        latestFrameTimeLabel.setForeground(UIUtil.getLabelDisabledForeground());
        latestFrameTimeLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        latestFrameTimeLabel.setOpaque(false);
        latestFrameTimeLabel.setToolTipText("Rendering time of latest frame.");
        JBPanel latestFrameTimePanel = new JBPanel();
        latestFrameTimePanel.setLayout((LayoutManager)new BoxLayout((Container)latestFrameTimePanel, 1));
        latestFrameTimePanel.setOpaque(false);
        latestFrameTimePanel.add((Component)latestFrameTimeLabel);
        JBLabel targetFrameTimeLabel = new JBLabel(TARGET_FRAME_RENDERING_TIME);
        targetFrameTimeLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        targetFrameTimeLabel.setForeground(UIUtil.getLabelDisabledForeground());
        targetFrameTimeLabel.setBorder(JBUI.Borders.empty((int)2));
        targetFrameTimeLabel.setOpaque(false);
        targetFrameTimeLabel.setToolTipText("Targeting 16ms per frame will\nresult in 60 frames per second.");
        JBPanel targetFrameTimePanel = new JBPanel();
        targetFrameTimePanel.setLayout((LayoutManager)new BoxLayout((Container)targetFrameTimePanel, 1));
        targetFrameTimePanel.setOpaque(false);
        targetFrameTimePanel.add(Box.createVerticalGlue());
        targetFrameTimePanel.add((Component)targetFrameTimeLabel);
        targetFrameTimePanel.add(Box.createVerticalGlue());
        panel.add(frameRenderingPanel);
        panel.add((Component)latestFrameTimePanel);
        panel.add((Component)targetFrameTimePanel);
        FlutterFramesMonitor.Listener listener = event -> {
            frameRenderingPanel.update();
            int ms = Math.round((float)event.elapsedMicros / 1000.0f);
            latestFrameTimeLabel.setText(ms + "ms");
            SwingUtilities.invokeLater(() -> latestFrameTimeLabel.repaint());
            targetFrameTimeLabel.setText(TARGET_FRAME_RENDERING_TIME);
            SwingUtilities.invokeLater(() -> targetFrameTimeLabel.repaint());
        };
        flutterFramesMonitor.addListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> flutterFramesMonitor.removeListener(listener));
        return panel;
    }

    static {
        df.setMaximumFractionDigits(1);
    }
}

