/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import icons.FlutterIcons;
import io.flutter.FlutterUtils;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterWidget {
    private static final Logger LOG = Logger.getInstance(FlutterWidget.class);
    private static final Catalog catalog = new Catalog();
    private final JsonObject json;
    private final Icon icon;

    private FlutterWidget(@NotNull JsonObject json) {
        if (json == null) {
            FlutterWidget.$$$reportNull$$$0(0);
        }
        this.json = json;
        this.icon = this.initIcon();
    }

    @Nullable
    private Icon initIcon() {
        List<String> categories = this.getCategories();
        if (categories != null) {
            for (String label : categories) {
                Icon icon;
                Category category = Category.forLabel(label);
                if (category == null || (icon = category.getIcon()) == null) continue;
                return icon;
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static Catalog getCatalog() {
        Catalog catalog = FlutterWidget.catalog;
        if (catalog == null) {
            FlutterWidget.$$$reportNull$$$0(1);
        }
        return catalog;
    }

    @Contract(pure=true)
    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public String getName() {
        return JsonUtils.getStringMember(this.json, "name");
    }

    @Nullable
    public List<String> getCategories() {
        return JsonUtils.getValues(this.json, "categories");
    }

    @Nullable
    public List<String> getSubCategories() {
        return JsonUtils.getValues(this.json, "subcategories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspector/FlutterWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspector/FlutterWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatalog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Catalog {
        @NotNull
        private final Map<String, FlutterWidget> widgets = new HashMap<String, FlutterWidget>();
        @Nullable
        private JsonElement json;

        private Catalog() {
            this.init();
        }

        private void init() {
            try {
                URL resource = this.getClass().getResource("widgets.json");
                byte[] contentBytes = ByteStreams.toByteArray((InputStream)((InputStream)resource.getContent()));
                String content = new String(contentBytes, Charsets.UTF_8);
                JsonParser parser = new JsonParser();
                this.json = parser.parse(content);
                if (!(this.json instanceof JsonArray)) {
                    throw new IllegalStateException("Unexpected Json format: expected array");
                }
                ((JsonArray)this.json).forEach(element -> {
                    if (!(element instanceof JsonObject)) {
                        throw new IllegalStateException("Unexpected Json format: expected object");
                    }
                    FlutterWidget widget = new FlutterWidget((JsonObject)element);
                    String name = widget.getName();
                    this.widgets.put(name, widget);
                });
            }
            catch (IOException e) {
                FlutterUtils.warn(LOG, e);
            }
        }

        @Contract(pure=true)
        @NotNull
        public Collection<FlutterWidget> getWidgets() {
            Collection<FlutterWidget> collection = this.widgets.values();
            if (collection == null) {
                Catalog.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Contract(value="null -> null")
        @Nullable
        public FlutterWidget getWidget(@Nullable String name) {
            return name != null ? this.widgets.get(name) : null;
        }

        @Contract(pure=true)
        @NotNull
        public String dumpJson() {
            String string = Objects.toString(this.json);
            if (string == null) {
                Catalog.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "io/flutter/inspector/FlutterWidget$Catalog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWidgets";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dumpJson";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static abstract class Filter {
        public static final Predicate<DiagnosticsNode> PRIVATE_CLASS = Filter.forPattern("_.*");

        Filter() {
        }

        public static Predicate<DiagnosticsNode> forPatterns(String ... regexps) {
            if (regexps == null) {
                Filter.$$$reportNull$$$0(0);
            }
            return Arrays.stream(regexps).map(Filter::forPattern).reduce(node -> false, Predicate::or);
        }

        public static Predicate<DiagnosticsNode> forPattern(@NotNull String regexp) {
            if (regexp == null) {
                Filter.$$$reportNull$$$0(1);
            }
            Pattern pattern = Pattern.compile(regexp);
            return node -> {
                String description = node.getDescription();
                return description != null && pattern.matcher(description).matches();
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regexps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regexp";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/inspector/FlutterWidget$Filter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forPatterns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum Category {
        ACCESSIBILITY("Accessibility", FlutterIcons.Accessibility),
        ANIMATION_AND_MOTION("Animation and Motion", FlutterIcons.Animation),
        ASSETS_IMAGES_AND_ICONS("Assets, Images, and Icons", FlutterIcons.Assets),
        ASYNC("Async", FlutterIcons.Async),
        BASICS("Basics", null),
        CUPERTINO("Cupertino (iOS-style widgets)", null),
        INPUT("Input", FlutterIcons.Input),
        PAINTING_AND_EFFECTS("Painting and effects", FlutterIcons.Painting),
        SCROLLING("Scrolling", FlutterIcons.Scrollbar),
        STACK("Stack", FlutterIcons.Stack),
        STYLING("Styling", FlutterIcons.Styling),
        TEXT("Text", FlutterIcons.Text);

        @NotNull
        private final String label;
        private final Icon icon;

        private Category(String label, Icon icon) {
            if (label == null) {
                Category.$$$reportNull$$$0(0);
            }
            this.label = label;
            this.icon = icon;
        }

        @NotNull
        public String getLabel() {
            String string = this.label;
            if (string == null) {
                Category.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public static Category forLabel(@NotNull String label) {
            if (label == null) {
                Category.$$$reportNull$$$0(2);
            }
            return Arrays.stream(Category.values()).filter(c -> c.getLabel().equals(label)).findFirst().orElse(null);
        }

        @Contract(pure=true)
        @Nullable
        public Icon getIcon() {
            return this.icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/inspector/FlutterWidget$Category";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/inspector/FlutterWidget$Category";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "forLabel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

