/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.inspector.DiagnosticLevel;
import io.flutter.inspector.DiagnosticsTreeStyle;
import io.flutter.inspector.FlutterWidget;
import io.flutter.inspector.InspectorInstanceRef;
import io.flutter.inspector.InspectorService;
import io.flutter.inspector.InspectorSourceLocation;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.CustomIconMaker;
import io.flutter.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.dartlang.analysis.server.protocol.HoverInformation;
import org.dartlang.vm.service.element.InstanceRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagnosticsNode {
    private static final Logger LOG = Logger.getInstance(DiagnosticsNode.class);
    private static final CustomIconMaker iconMaker = new CustomIconMaker();
    private final FlutterApp app;
    private InspectorSourceLocation location;
    private DiagnosticsNode parent;
    private CompletableFuture<String> propertyDocFuture;
    private ArrayList<DiagnosticsNode> cachedProperties;
    private final CompletableFuture<InspectorService.ObjectGroup> inspectorService;
    private final JsonObject json;
    private CompletableFuture<ArrayList<DiagnosticsNode>> children;
    private CompletableFuture<Map<String, InstanceRef>> valueProperties;
    private final boolean isProperty;

    public DiagnosticsNode(JsonObject json, InspectorService.ObjectGroup inspectorService, boolean isProperty, DiagnosticsNode parent) {
        this.json = json;
        this.inspectorService = CompletableFuture.completedFuture(inspectorService);
        this.isProperty = isProperty;
        this.app = inspectorService.getApp();
    }

    public DiagnosticsNode(JsonObject json, CompletableFuture<InspectorService.ObjectGroup> inspectorService, FlutterApp app, boolean isProperty, DiagnosticsNode parent) {
        this.json = json;
        this.inspectorService = inspectorService;
        this.isProperty = isProperty;
        this.app = app;
    }

    public boolean equals(Object other) {
        if (other instanceof DiagnosticsNode) {
            DiagnosticsNode otherNode = (DiagnosticsNode)other;
            return this.getDartDiagnosticRef().equals(otherNode.getDartDiagnosticRef());
        }
        return false;
    }

    public String toString() {
        String name = this.getName();
        if (StringUtils.isEmpty((String)name) || !this.getShowName()) {
            return this.getDescription();
        }
        return name + this.getSeparator() + ' ' + this.getDescription();
    }

    public boolean isDisposed() {
        try {
            InspectorService.ObjectGroup service = this.inspectorService.getNow(null);
            return service != null && service.isDisposed();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setParent(DiagnosticsNode parent) {
        this.parent = parent;
    }

    @Nullable
    public DiagnosticsNode getParent() {
        return this.parent;
    }

    public String getSeparator() {
        return this.getShowSeparator() ? ":" : "";
    }

    public String getName() {
        return this.getStringMember("name");
    }

    public boolean getShowSeparator() {
        return this.getBooleanMember("showSeparator", true);
    }

    public String getDescription() {
        return this.getStringMember("description");
    }

    public DiagnosticLevel getLevel() {
        return this.getLevelMember("level", DiagnosticLevel.info);
    }

    public boolean getShowName() {
        return this.getBooleanMember("showName", true);
    }

    public String getEmptyBodyDescription() {
        return this.getStringMember("emptyBodyDescription");
    }

    public DiagnosticsTreeStyle getStyle() {
        return this.getStyleMember("style", DiagnosticsTreeStyle.sparse);
    }

    String getType() {
        return this.getStringMember("type");
    }

    public boolean getIsQuoted() {
        return this.getBooleanMember("quoted", false);
    }

    public boolean hasIsQuoted() {
        return this.json.has("quoted");
    }

    public String getUnit() {
        return this.getStringMember("unit");
    }

    public boolean hasUnit() {
        return this.json.has("unit");
    }

    public String getNumberToString() {
        return this.getStringMember("numberToString");
    }

    public boolean hasNumberToString() {
        return this.json.has("numberToString");
    }

    public String getIfTrue() {
        return this.getStringMember("ifTrue");
    }

    public boolean hasIfTrue() {
        return this.json.has("ifTrue");
    }

    public String getIfFalse() {
        return this.getStringMember("ifFalse");
    }

    public boolean hasIfFalse() {
        return this.json.has("ifFalse");
    }

    public ArrayList<String> getValues() {
        if (!this.json.has("values")) {
            return null;
        }
        JsonArray rawValues = this.json.getAsJsonArray("values");
        ArrayList<String> values = new ArrayList<String>(rawValues.size());
        for (int i = 0; i < rawValues.size(); ++i) {
            values.add(rawValues.get(i).getAsString());
        }
        return values;
    }

    public boolean hasValues() {
        return this.json.has("values");
    }

    public String getIfPresent() {
        return this.getStringMember("ifPresent");
    }

    public boolean hasIfPresent() {
        return this.json.has("ifPresent");
    }

    public String getDefaultValue() {
        return this.getStringMember("defaultValue");
    }

    public boolean hasDefaultValue() {
        return this.json.has("defaultValue");
    }

    public String getIfEmpty() {
        return this.getStringMember("ifEmpty");
    }

    public String getIfNull() {
        return this.getStringMember("ifNull");
    }

    public String getTooltip() {
        return this.getStringMember("tooltip");
    }

    public boolean hasTooltip() {
        return this.json.has("tooltip");
    }

    public boolean getMissingIfNull() {
        return this.getBooleanMember("missingIfNull", false);
    }

    public String exception() {
        return this.getStringMember("exception");
    }

    boolean hasException() {
        return this.json.has("exception");
    }

    public boolean hasCreationLocation() {
        return this.location != null || this.json.has("creationLocation");
    }

    public int getLocationId() {
        return JsonUtils.getIntMember(this.json, "locationId");
    }

    public InspectorSourceLocation getCreationLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (!this.hasCreationLocation()) {
            return null;
        }
        this.location = new InspectorSourceLocation(this.json.getAsJsonObject("creationLocation"), null);
        return this.location;
    }

    public String getPropertyType() {
        return this.getStringMember("propertyType");
    }

    public DiagnosticLevel getDefaultLevel() {
        return this.getLevelMember("defaultLevel", DiagnosticLevel.info);
    }

    public boolean getIsDiagnosticableValue() {
        return this.getBooleanMember("isDiagnosticableValue", false);
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    public String getStringMember(@NotNull String memberName) {
        if (memberName == null) {
            DiagnosticsNode.$$$reportNull$$$0(0);
        }
        return JsonUtils.getStringMember(this.json, memberName);
    }

    private boolean getBooleanMember(String memberName, boolean defaultValue) {
        if (!this.json.has(memberName)) {
            return defaultValue;
        }
        JsonElement value = this.json.get(memberName);
        if (value instanceof JsonNull) {
            return defaultValue;
        }
        return value.getAsBoolean();
    }

    private DiagnosticLevel getLevelMember(String memberName, DiagnosticLevel defaultValue) {
        if (!this.json.has(memberName)) {
            return defaultValue;
        }
        JsonElement value = this.json.get(memberName);
        if (value instanceof JsonNull) {
            return defaultValue;
        }
        return DiagnosticLevel.valueOf(value.getAsString());
    }

    private DiagnosticsTreeStyle getStyleMember(String memberName, DiagnosticsTreeStyle defaultValue) {
        if (!this.json.has(memberName)) {
            return defaultValue;
        }
        JsonElement value = this.json.get(memberName);
        if (value instanceof JsonNull) {
            return defaultValue;
        }
        return DiagnosticsTreeStyle.valueOf(value.getAsString());
    }

    public InspectorInstanceRef getValueRef() {
        JsonElement valueId = this.json.get("valueId");
        return new InspectorInstanceRef(valueId.isJsonNull() ? null : valueId.getAsString());
    }

    public boolean isEnumProperty() {
        String type = this.getType();
        return type != null && type.startsWith("EnumProperty<");
    }

    public CompletableFuture<Map<String, InstanceRef>> getValueProperties() {
        InspectorInstanceRef valueRef = this.getValueRef();
        if (this.valueProperties == null) {
            String[] propertyNames;
            if (this.getPropertyType() == null || valueRef == null || valueRef.getId() == null) {
                this.valueProperties = CompletableFuture.completedFuture(null);
                return this.valueProperties;
            }
            if (this.isEnumProperty()) {
                this.valueProperties = this.inspectorService.thenComposeAsync(service -> {
                    if (service == null) {
                        return null;
                    }
                    return service.getEnumPropertyValues(this.getValueRef());
                });
                return this.valueProperties;
            }
            switch (this.getPropertyType()) {
                case "Color": {
                    propertyNames = new String[]{"red", "green", "blue", "alpha"};
                    break;
                }
                case "IconData": {
                    propertyNames = new String[]{"codePoint"};
                    break;
                }
                default: {
                    this.valueProperties = CompletableFuture.completedFuture(null);
                    return this.valueProperties;
                }
            }
            this.valueProperties = this.inspectorService.thenComposeAsync(service -> {
                if (service == null) {
                    return null;
                }
                return service.getDartObjectProperties(this.getValueRef(), propertyNames);
            });
        }
        return this.valueProperties;
    }

    public JsonObject getValuePropertiesJson() {
        return this.json.getAsJsonObject("valueProperties");
    }

    public boolean hasChildren() {
        return this.getBooleanMember("hasChildren", false);
    }

    public boolean isCreatedByLocalProject() {
        return this.getBooleanMember("createdByLocalProject", false);
    }

    public boolean isSummaryTree() {
        return this.getBooleanMember("summaryTree", false);
    }

    public boolean isStateful() {
        return this.getBooleanMember("stateful", false);
    }

    public String getWidgetRuntimeType() {
        return this.getStringMember("widgetRuntimeType");
    }

    public boolean childrenReady() {
        return this.json.has("children") || this.children != null && this.children.isDone();
    }

    public CompletableFuture<ArrayList<DiagnosticsNode>> getChildren() {
        if (this.children == null) {
            if (this.json.has("children")) {
                JsonArray jsonArray = this.json.get("children").getAsJsonArray();
                ArrayList<DiagnosticsNode> nodes = new ArrayList<DiagnosticsNode>();
                for (JsonElement element : jsonArray) {
                    DiagnosticsNode child = new DiagnosticsNode(element.getAsJsonObject(), this.inspectorService, this.app, false, this.parent);
                    child.setParent(this);
                    nodes.add(child);
                }
                this.children = CompletableFuture.completedFuture(nodes);
            } else {
                this.children = this.hasChildren() ? this.inspectorService.thenComposeAsync(service -> {
                    if (service == null) {
                        return null;
                    }
                    return service.getChildren(this.getDartDiagnosticRef(), this.isSummaryTree(), this);
                }) : CompletableFuture.completedFuture(new ArrayList());
            }
        }
        return this.children;
    }

    public InspectorInstanceRef getDartDiagnosticRef() {
        JsonElement objectId = this.json.get("objectId");
        return new InspectorInstanceRef(objectId.isJsonNull() ? null : objectId.getAsString());
    }

    public ArrayList<DiagnosticsNode> getInlineProperties() {
        if (this.cachedProperties == null) {
            this.cachedProperties = new ArrayList();
            if (this.json.has("properties")) {
                JsonArray jsonArray = this.json.get("properties").getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    this.cachedProperties.add(new DiagnosticsNode(element.getAsJsonObject(), this.inspectorService, this.app, true, this.parent));
                }
                this.trackPropertiesMatchingParameters(this.cachedProperties);
            }
        }
        return this.cachedProperties;
    }

    public CompletableFuture<ArrayList<DiagnosticsNode>> getProperties(InspectorService.ObjectGroup objectGroup) {
        CompletableFuture<ArrayList<DiagnosticsNode>> properties = objectGroup.getProperties(this.getDartDiagnosticRef());
        return properties.thenApplyAsync(this::trackPropertiesMatchingParameters);
    }

    ArrayList<DiagnosticsNode> trackPropertiesMatchingParameters(ArrayList<DiagnosticsNode> nodes) {
        ArrayList<InspectorSourceLocation> parameterLocations;
        InspectorSourceLocation creationLocation = this.getCreationLocation();
        if (creationLocation != null && (parameterLocations = creationLocation.getParameterLocations()) != null) {
            String name;
            HashMap<String, InspectorSourceLocation> names = new HashMap<String, InspectorSourceLocation>();
            for (InspectorSourceLocation location : parameterLocations) {
                name = location.getName();
                if (name == null) continue;
                names.put(name, location);
            }
            for (DiagnosticsNode node : nodes) {
                InspectorSourceLocation parameterLocation;
                node.setParent(this);
                name = node.getName();
                if (name == null || (parameterLocation = (InspectorSourceLocation)names.get(name)) == null) continue;
                node.setCreationLocation(parameterLocation);
            }
        }
        return nodes;
    }

    @NotNull
    public CompletableFuture<String> getPropertyDoc() {
        if (this.propertyDocFuture == null) {
            this.propertyDocFuture = this.createPropertyDocFuture();
        }
        CompletableFuture<String> completableFuture = this.propertyDocFuture;
        if (completableFuture == null) {
            DiagnosticsNode.$$$reportNull$$$0(1);
        }
        return completableFuture;
    }

    private CompletableFuture<String> createPropertyDocFuture() {
        DiagnosticsNode parent = this.getParent();
        if (parent != null) {
            return ((CompletableFuture)this.inspectorService.thenComposeAsync(service -> service.toDartVmServiceValueForSourceLocation(parent.getValueRef()).thenComposeAsync(vmValue -> {
                if (vmValue == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return ((InspectorService.ObjectGroup)this.inspectorService.getNow(null)).getPropertyLocation(vmValue.getInstanceRef(), this.getName()).thenApplyAsync(sourcePosition -> {
                    if (sourcePosition != null) {
                        List hovers;
                        VirtualFile file = sourcePosition.getFile();
                        int offset = sourcePosition.getOffset();
                        Project project = this.getProject(file);
                        if (project != null && !(hovers = DartAnalysisServerService.getInstance((Project)project).analysis_getHover(file, offset)).isEmpty()) {
                            return ((HoverInformation)hovers.get(0)).getDartdoc();
                        }
                    }
                    return "Unable to find property source";
                });
            }))).exceptionally(t -> {
                LOG.info("ignoring exception from toObjectForSourceLocation: " + t.toString());
                return null;
            });
        }
        return CompletableFuture.completedFuture("Unable to find property source");
    }

    @Nullable
    private Project getProject(@NotNull VirtualFile file) {
        if (file == null) {
            DiagnosticsNode.$$$reportNull$$$0(2);
        }
        return this.app != null ? this.app.getProject() : ProjectUtil.guessProjectForFile((VirtualFile)file);
    }

    private void setCreationLocation(InspectorSourceLocation location) {
        this.location = location;
    }

    public CompletableFuture<InspectorService.ObjectGroup> getInspectorService() {
        return this.inspectorService;
    }

    @Nullable
    public FlutterWidget getWidget() {
        return FlutterWidget.getCatalog().getWidget(this.getDescription());
    }

    @Nullable
    public Icon getIcon() {
        Icon icon = null;
        FlutterWidget widget = this.getWidget();
        if (widget != null) {
            icon = widget.getIcon();
        }
        if (icon == null) {
            icon = iconMaker.fromWidgetName(this.getDescription());
        }
        return icon;
    }

    public boolean identicalDisplay(DiagnosticsNode node) {
        if (node == null) {
            return false;
        }
        Set entries = this.json.entrySet();
        if (entries.size() != node.json.entrySet().size()) {
            return false;
        }
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (key.equals("objectId") || key.equals("valueId") || !((JsonElement)entry.getValue()).equals(node.json.get(key))) continue;
            return false;
        }
        return true;
    }

    public <T> void safeWhenComplete(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
        try {
            InspectorService.ObjectGroup service = this.inspectorService.getNow(null);
            if (service != null) {
                service.safeWhenComplete(future, action);
                return;
            }
            this.inspectorService.whenCompleteAsync((group, t) -> {
                if (group == null || t != null) {
                    return;
                }
                group.safeWhenComplete(future, action);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelection(InspectorInstanceRef ref, boolean uiAlreadyUpdated) {
        this.inspectorService.thenAcceptAsync(service -> {
            if (service == null) {
                return;
            }
            service.setSelection(ref, uiAlreadyUpdated);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspector/DiagnosticsNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspector/DiagnosticsNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyDoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringMember";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

