/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.DartLanguage;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterUIConfig;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;

public class SdkConfigurationNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"FlutterWrongDartSdkNotification");
    private static final Logger LOG = Logger.getInstance(SdkConfigurationNotificationProvider.class);
    @NotNull
    private final Project project;

    public SdkConfigurationNotificationProvider(@NotNull Project project) {
        if (project == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    private static EditorNotificationPanel createNoFlutterSdkPanel(Project project) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.icon(FlutterIcons.Flutter);
        panel.setText(FlutterBundle.message("flutter.no.sdk.warning", new Object[0]));
        panel.createActionLabel("Dismiss", () -> panel.setVisible(false));
        panel.createActionLabel("Open Flutter settings", () -> FlutterUtils.openFlutterSettings(project));
        return panel;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(3);
        }
        if (FlutterModuleUtils.isFlutterBazelProject(this.project)) {
            return null;
        }
        if (file.getFileType() != DartFileType.INSTANCE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile == null || psiFile.getLanguage() != DartLanguage.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (!FlutterModuleUtils.isFlutterModule(module)) {
            return null;
        }
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(this.project);
        if (flutterSdk == null) {
            return SdkConfigurationNotificationProvider.createNoFlutterSdkPanel(this.project);
        }
        if (!flutterSdk.getVersion().isMinRecommendedSupported()) {
            return this.createOutOfDateFlutterSdkPanel(flutterSdk);
        }
        return null;
    }

    private EditorNotificationPanel createOutOfDateFlutterSdkPanel(@NotNull FlutterSdk sdk) {
        FlutterUIConfig settings;
        if (sdk == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(4);
        }
        if ((settings = FlutterUIConfig.getInstance()).shouldIgnoreOutOfDateFlutterSdks()) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.icon(FlutterIcons.Flutter);
        panel.setText(FlutterBundle.message("flutter.old.sdk.warning", new Object[0]));
        panel.createActionLabel("Dismiss", () -> {
            settings.setIgnoreOutOfDateFlutterSdks();
            panel.setVisible(false);
        });
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspections/SdkConfigurationNotificationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspections/SdkConfigurationNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOutOfDateFlutterSdkPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

