/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileOffsetsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import io.flutter.FlutterUtils;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.dart.FlutterOutlineListener;
import io.flutter.editor.FliteredIndentsHighlightingPass;
import io.flutter.editor.PlaceholderHighlightingPass;
import io.flutter.editor.WidgetIndentsHighlightingPass;
import io.flutter.settings.FlutterSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;

public class WidgetIndentsHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
Disposable {
    private static final boolean SIMULATE_SLOW_ANALYSIS_UPDATES = false;
    private Project project;
    private final FlutterDartAnalysisServer flutterDartAnalysisService;
    private final Map<String, FlutterOutline> currentOutlines;
    private final Map<String, FlutterOutlineListener> outlineListeners = new HashMap<String, FlutterOutlineListener>();
    private boolean isShowMultipleChildrenGuides;
    private boolean isShowBuildMethodGuides;
    private final FlutterSettings.Listener settingsListener = () -> {
        if (this.project == null || this.project.isDisposed()) {
            return;
        }
        FlutterSettings settings = FlutterSettings.getInstance();
        if (this.isShowBuildMethodGuides == settings.isShowBuildMethodGuides() && this.isShowMultipleChildrenGuides == settings.isShowMultipleChildrenGuides()) {
            return;
        }
        this.syncSettings(settings);
        for (EditorEx editor : this.getActiveDartEditors()) {
            this.updateEditorSettings(editor);
            editor.repaint(0, editor.getDocument().getTextLength());
        }
    };

    public WidgetIndentsHighlightingPassFactory(final Project project) {
        this.project = project;
        TextEditorHighlightingPassRegistrar.getInstance((Project)project).registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.AFTER, 1, false, false);
        this.currentOutlines = new HashMap<String, FlutterOutline>();
        this.flutterDartAnalysisService = FlutterDartAnalysisServer.getInstance(project);
        this.syncSettings(FlutterSettings.getInstance());
        FlutterSettings.getInstance().addListener(this.settingsListener);
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Editor editor;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor = event.getEditor()).getProject() != project) {
                    return;
                }
                if (editor.isDisposed() || project.isDisposed()) {
                    return;
                }
                if (!(editor instanceof EditorEx)) {
                    return;
                }
                EditorEx editorEx = (EditorEx)editor;
                WidgetIndentsHighlightingPass.onCaretPositionChanged(editorEx, event.getCaret());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/editor/WidgetIndentsHighlightingPassFactory$1", "caretPositionChanged"));
            }
        }, (Disposable)this);
        this.updateActiveEditors();
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                WidgetIndentsHighlightingPassFactory.this.updateActiveEditors();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/editor/WidgetIndentsHighlightingPassFactory$2", "selectionChanged"));
            }
        });
    }

    List<EditorEx> getActiveDartEditors() {
        if (this.project.isDisposed()) {
            return Collections.emptyList();
        }
        FileEditor[] editors = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
        ArrayList<EditorEx> dartEditors = new ArrayList<EditorEx>();
        for (FileEditor fileEditor : editors) {
            TextEditor textEditor;
            Editor editor;
            if (!(fileEditor instanceof TextEditor) || !((editor = (textEditor = (TextEditor)fileEditor).getEditor()) instanceof EditorEx)) continue;
            dartEditors.add((EditorEx)editor);
        }
        return dartEditors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        Map<String, Object> map = this.outlineListeners;
        synchronized (map) {
            for (Map.Entry<String, FlutterOutlineListener> entry : this.outlineListeners.entrySet()) {
                String path = entry.getKey();
                FlutterOutlineListener listener = this.outlineListeners.remove(path);
                if (listener == null) continue;
                this.flutterDartAnalysisService.removeOutlineListener(path, listener);
            }
            this.outlineListeners.clear();
        }
        map = this.currentOutlines;
        synchronized (map) {
            this.currentOutlines.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveEditors() {
        if (this.project.isDisposed()) {
            return;
        }
        if (!FlutterSettings.getInstance().isShowBuildMethodGuides()) {
            this.clearListeners();
            return;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
        VirtualFile[] files = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
        HashSet<String> newPaths = new HashSet<String>();
        for (VirtualFile file : files) {
            if (!FlutterUtils.couldContainWidgets(file)) continue;
            newPaths.add(file.getPath());
        }
        ArrayList<String> obsoletePaths = new ArrayList<String>();
        Map<String, Object> map = this.outlineListeners;
        synchronized (map) {
            FlutterOutlineListener listener;
            for (String path : this.outlineListeners.keySet()) {
                if (newPaths.contains(path)) continue;
                obsoletePaths.add(path);
            }
            for (String path : obsoletePaths) {
                listener = this.outlineListeners.remove(path);
                if (listener == null) continue;
                this.flutterDartAnalysisService.removeOutlineListener(path, listener);
            }
            for (String path : newPaths) {
                if (this.outlineListeners.containsKey(path)) continue;
                listener = (filePath, outline, instrumentedCode) -> {
                    Map<String, Object> map = this.outlineListeners;
                    synchronized (map) {
                        if (!this.outlineListeners.containsKey(path)) {
                            return;
                        }
                    }
                    map = this.currentOutlines;
                    synchronized (map) {
                        this.currentOutlines.put(path, outline);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.project.isDisposed()) {
                            return;
                        }
                        for (EditorEx editor : this.getActiveDartEditors()) {
                            if (editor.isDisposed() || !Objects.equals(editor.getVirtualFile().getCanonicalPath(), path)) continue;
                            this.runWidgetIndentsPass(editor, outline);
                        }
                    });
                };
                this.outlineListeners.put(path, listener);
                this.flutterDartAnalysisService.addOutlineListener(FileUtil.toSystemDependentName((String)path), listener);
            }
        }
        map = this.currentOutlines;
        synchronized (map) {
            for (String path : obsoletePaths) {
                this.currentOutlines.remove(path);
            }
        }
    }

    private void syncSettings(FlutterSettings settings) {
        if (this.isShowBuildMethodGuides != settings.isShowBuildMethodGuides()) {
            this.isShowBuildMethodGuides = settings.isShowBuildMethodGuides();
            this.updateActiveEditors();
        }
        this.isShowMultipleChildrenGuides = settings.isShowMultipleChildrenGuides() && this.isShowBuildMethodGuides;
    }

    private void updateEditorSettings(EditorEx editor) {
        editor.getSettings().setIndentGuidesShown(!this.isShowBuildMethodGuides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor e) {
        FlutterOutline outline;
        if (file == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (e == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        if (!FlutterSettings.getInstance().isShowBuildMethodGuides()) {
            if (e instanceof EditorEx) {
                ApplicationManager.getApplication().invokeLater(() -> WidgetIndentsHighlightingPass.cleanupHighlighters(e));
            }
            PlaceholderHighlightingPass placeholderHighlightingPass = new PlaceholderHighlightingPass(this.project, e.getDocument(), false);
            if (placeholderHighlightingPass == null) {
                WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(2);
            }
            return placeholderHighlightingPass;
        }
        FliteredIndentsHighlightingPass fliteredIndentsHighlightingPass = new FliteredIndentsHighlightingPass(this.project, e, file);
        if (!(e instanceof EditorEx)) {
            FliteredIndentsHighlightingPass fliteredIndentsHighlightingPass2 = fliteredIndentsHighlightingPass;
            if (fliteredIndentsHighlightingPass2 == null) {
                WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(3);
            }
            return fliteredIndentsHighlightingPass2;
        }
        EditorEx editor = (EditorEx)e;
        VirtualFile virtualFile = editor.getVirtualFile();
        if (!FlutterUtils.couldContainWidgets(virtualFile)) {
            FliteredIndentsHighlightingPass fliteredIndentsHighlightingPass3 = fliteredIndentsHighlightingPass;
            if (fliteredIndentsHighlightingPass3 == null) {
                WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(4);
            }
            return fliteredIndentsHighlightingPass3;
        }
        String path = virtualFile.getPath();
        Map<String, FlutterOutline> map = this.currentOutlines;
        synchronized (map) {
            outline = this.currentOutlines.get(path);
        }
        if (outline != null) {
            this.updateEditorSettings(editor);
            ApplicationManager.getApplication().invokeLater(() -> this.runWidgetIndentsPass(editor, outline));
        }
        FliteredIndentsHighlightingPass fliteredIndentsHighlightingPass4 = fliteredIndentsHighlightingPass;
        if (fliteredIndentsHighlightingPass4 == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(5);
        }
        return fliteredIndentsHighlightingPass4;
    }

    void runWidgetIndentsPass(EditorEx editor, @NotNull FlutterOutline outline) {
        if (outline == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(6);
        }
        if (editor.isDisposed()) {
            return;
        }
        VirtualFile file = editor.getVirtualFile();
        if (!FlutterUtils.couldContainWidgets(file)) {
            return;
        }
        FileOffsetsManager offsetManager = FileOffsetsManager.getInstance();
        DocumentEx document = editor.getDocument();
        if (document.getTextLength() != offsetManager.getConvertedOffset(file, outline.getLength())) {
            return;
        }
        WidgetIndentsHighlightingPass.run(this.project, editor, outline);
    }

    public void dispose() {
        this.clearListeners();
        FlutterSettings.getInstance().removeListener(this.settingsListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/WidgetIndentsHighlightingPassFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/WidgetIndentsHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runWidgetIndentsPass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

