/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.Document;
import io.flutter.editor.OutlineLocation;
import java.util.ArrayList;

public class WidgetIndentGuideDescriptor {
    public final WidgetIndentGuideDescriptor parent;
    public final ArrayList<OutlineLocation> childLines;
    public final OutlineLocation widget;
    public final int indentLevel;
    public final int startLine;
    public final int endLine;

    public WidgetIndentGuideDescriptor(WidgetIndentGuideDescriptor parent, int indentLevel, int startLine, int endLine, ArrayList<OutlineLocation> childLines, OutlineLocation widget) {
        this.parent = parent;
        this.childLines = childLines;
        this.widget = widget;
        this.indentLevel = indentLevel;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
        }
        if (this.childLines == null) {
            return;
        }
        for (OutlineLocation childLine : this.childLines) {
            childLine.dispose();
        }
        this.childLines.clear();
    }

    public void trackLocations(Document document) {
        if (this.widget != null) {
            this.widget.track(document);
        }
        if (this.childLines == null) {
            return;
        }
        for (OutlineLocation childLine : this.childLines) {
            childLine.track(document);
        }
    }

    public int hashCode() {
        int result = this.indentLevel;
        result = 31 * result + this.startLine;
        result = 31 * result + this.endLine;
        if (this.childLines != null) {
            for (OutlineLocation location : this.childLines) {
                result = 31 * result + location.hashCode();
            }
        }
        if (this.widget != null) {
            result = 31 * result + this.widget.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetIndentGuideDescriptor that = (WidgetIndentGuideDescriptor)o;
        if (this.endLine != that.endLine) {
            return false;
        }
        if (this.indentLevel != that.indentLevel) {
            return false;
        }
        if (this.startLine != that.startLine) {
            return false;
        }
        if (this.childLines == null || that.childLines == null) {
            return this.childLines == that.childLines;
        }
        if (this.childLines.size() != that.childLines.size()) {
            return false;
        }
        for (int i = 0; i < this.childLines.size(); ++i) {
            if (!this.childLines.get(i).equals(that.childLines.get(i))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(WidgetIndentGuideDescriptor that) {
        int answer = this.endLine - that.endLine;
        if (answer != 0) {
            return answer;
        }
        answer = this.indentLevel - that.indentLevel;
        if (answer != 0) {
            return answer;
        }
        answer = this.startLine - that.startLine;
        if (answer != 0) {
            return answer;
        }
        if (this.childLines == that.childLines) {
            return 0;
        }
        if (this.childLines == null || that.childLines == null) {
            return this.childLines == null ? -1 : 1;
        }
        answer = this.childLines.size() - that.childLines.size();
        if (answer != 0) {
            return answer;
        }
        for (int i = 0; i < this.childLines.size(); ++i) {
            answer = this.childLines.get(i).compareTo(that.childLines.get(i));
            if (answer == 0) continue;
            return answer;
        }
        return 0;
    }
}

