/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.Nullable;

public class OutlineLocation
implements Comparable<OutlineLocation> {
    private final int line;
    private final int column;
    private final int indent;
    private final int offset;
    private final int endOffset;
    @Nullable
    private RangeMarker marker;
    @Nullable
    private String nodeStartingWord;

    private static String getCurrentWord(Document document, int offset) {
        int end;
        int documentLength = document.getTextLength();
        if (offset < 0 || offset >= documentLength) {
            return "";
        }
        CharSequence chars = document.getCharsSequence();
        int maxWordEnd = Math.min(documentLength, offset + 20);
        for (end = offset; end < maxWordEnd && Character.isAlphabetic(chars.charAt(end)); ++end) {
        }
        if (offset == end) {
            return "";
        }
        return chars.subSequence(offset, end).toString();
    }

    public OutlineLocation(FlutterOutline node, int line, int column, int indent, VirtualFile file, DartAnalysisServerService analysisService) {
        this.line = line;
        this.column = column;
        assert (indent >= 0);
        assert (column >= 0);
        assert (column >= indent);
        assert (line >= 0);
        this.indent = indent;
        this.offset = analysisService.getConvertedOffset(file, node.getOffset());
        this.endOffset = analysisService.getConvertedOffset(file, node.getOffset() + node.getLength());
    }

    public void dispose() {
        if (this.marker != null) {
            this.marker.dispose();
        }
        this.marker = null;
    }

    public void track(Document document) {
        if (this.marker != null) {
            assert (this.marker.getDocument() == document);
            return;
        }
        assert (this.indent <= this.column);
        int delta = Math.max(this.column - this.indent, 0);
        int markerEnd = this.offset;
        int docLength = document.getTextLength();
        int startOffset = Math.max(markerEnd - delta, 0);
        startOffset = Math.min(startOffset, docLength);
        int endOffset = Math.min(markerEnd + 1, docLength);
        this.marker = document.createRangeMarker(startOffset, endOffset);
        this.nodeStartingWord = OutlineLocation.getCurrentWord(document, markerEnd);
    }

    public int hashCode() {
        int hashCode = this.line;
        hashCode = hashCode * 31 + this.column;
        hashCode = hashCode * 31 + this.indent;
        hashCode = hashCode * 31 + this.offset;
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OutlineLocation)) {
            return false;
        }
        OutlineLocation other = (OutlineLocation)o;
        return this.line == other.line && this.column == other.column && this.indent == other.indent && this.offset == other.offset && this.getOffset() == other.getOffset();
    }

    public int getOffset() {
        return this.marker == null ? this.offset : this.marker.getStartOffset();
    }

    public boolean isValid() {
        if (this.marker == null) {
            return true;
        }
        return this.marker.isValid() && this.nodeStartingWord != null && this.nodeStartingWord.equals(OutlineLocation.getCurrentWord(this.marker.getDocument(), this.marker.getEndOffset() - 1));
    }

    public int getLine() {
        return this.marker == null ? this.line : this.marker.getDocument().getLineNumber(this.marker.getStartOffset());
    }

    private int getColumnForOffset(int offset) {
        assert (this.marker != null);
        Document document = this.marker.getDocument();
        int currentLine = document.getLineNumber(offset);
        return offset - document.getLineStartOffset(currentLine);
    }

    public int getIndent() {
        return this.marker == null ? this.indent : this.getColumnForOffset(this.marker.getStartOffset());
    }

    public int getColumn() {
        return this.marker == null ? this.column : this.getColumnForOffset(Math.max(this.marker.getStartOffset(), this.marker.getEndOffset() - 1));
    }

    public TextRange getTextRange() {
        return this.marker == null ? new TextRange(this.offset, this.endOffset) : new TextRange(this.marker.getStartOffset(), this.marker.getEndOffset());
    }

    @Override
    public int compareTo(OutlineLocation o) {
        int delta = Integer.compare(this.line, o.line);
        if (delta != 0) {
            return delta;
        }
        delta = Integer.compare(this.column, o.column);
        if (delta != 0) {
            return delta;
        }
        return Integer.compare(this.indent, o.indent);
    }
}

