/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import icons.FlutterIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"flutter.native.editor.notification");
    private final Project myProject;

    public NativeEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!file.isInLocalFileSystem()) {
            return null;
        }
        return this.createPanelForFile(file, NativeEditorNotificationProvider.findRootDir(file, this.myProject.getBaseDir()));
    }

    private EditorNotificationPanel createPanelForFile(VirtualFile file, VirtualFile root) {
        if (root == null) {
            return null;
        }
        return this.createPanelForAction(file, root, NativeEditorNotificationProvider.getActionName(root));
    }

    private EditorNotificationPanel createPanelForAction(VirtualFile file, VirtualFile root, String actionName) {
        if (actionName == null) {
            return null;
        }
        NativeEditorActionsPanel panel = new NativeEditorActionsPanel(file, root, actionName);
        return panel.isValidForFile() ? panel : null;
    }

    private static String getActionName(VirtualFile root) {
        if (root == null) {
            return null;
        }
        if (root.getName().equals("android")) {
            return "flutter.androidstudio.open";
        }
        if (root.getName().equals("ios")) {
            return "flutter.xcode.open";
        }
        return null;
    }

    @Nullable
    private static VirtualFile findRootDir(@NotNull VirtualFile file, @Nullable VirtualFile projectDir) {
        if (file == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        if (projectDir == null) {
            return null;
        }
        VirtualFile parent = file.getParent();
        if (projectDir.equals(parent)) {
            return null;
        }
        VirtualFile root = parent;
        while (parent != null) {
            if (projectDir.equals(parent = parent.getParent())) {
                return root;
            }
            root = parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/NativeEditorNotificationProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/NativeEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRootDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class NativeEditorActionsPanel
    extends EditorNotificationPanel {
        final VirtualFile myFile;
        final VirtualFile myRoot;
        final AnAction myAction;
        final boolean isVisible;

        NativeEditorActionsPanel(VirtualFile file, VirtualFile root, String actionName) {
            super(EditorColors.GUTTER_BACKGROUND);
            this.myFile = file;
            this.myRoot = root;
            this.myAction = ActionManager.getInstance().getAction(actionName);
            this.icon(FlutterIcons.Flutter);
            this.text("Flutter commands");
            this.myAction.update(AnActionEvent.createFromDataContext((String)"EditorToolbar", (Presentation)this.myAction.getTemplatePresentation(), (DataContext)this.makeContext()));
            this.isVisible = this.myAction.getTemplatePresentation().isVisible();
            this.createActionLabel(this.myAction.getTemplatePresentation().getText(), this::performAction).setToolTipText(this.myAction.getTemplatePresentation().getDescription());
        }

        private boolean isValidForFile() {
            if (this.isVisible) {
                return FileUtil.isAncestor((String)this.myRoot.getPath(), (String)this.myFile.getPath(), (boolean)true);
            }
            return false;
        }

        private void performAction() {
            this.myAction.actionPerformed(AnActionEvent.createFromDataContext((String)"EditorToolbar", (Presentation)this.myAction.getTemplatePresentation(), (DataContext)this.makeContext()));
        }

        private DataContext makeContext() {
            return dataId -> {
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                    return this.myFile;
                }
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return NativeEditorNotificationProvider.this.myProject;
                }
                return null;
            };
        }
    }
}

