/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import icons.FlutterIcons;
import io.flutter.FlutterUtils;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterSettings;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterPubspecNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"flutter.pubspec");
    @NotNull
    private final Project project;
    @NotNull
    private final FlutterSettings settings;

    public FlutterPubspecNotificationProvider(@NotNull Project project, @NotNull FlutterSettings settings) {
        if (project == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.settings = settings;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(2);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor editor) {
        if (file == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!file.isInLocalFileSystem()) {
            return null;
        }
        if (this.settings.shouldUseBazel()) {
            return null;
        }
        if (!PubRoot.isPubspec(file)) {
            return null;
        }
        if (!FlutterUtils.declaresFlutter(file)) {
            return null;
        }
        if (FlutterSdk.getFlutterSdk(this.project) == null) {
            return null;
        }
        return new FlutterPubspecActionsPanel(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/FlutterPubspecNotificationProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/FlutterPubspecNotificationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FlutterPubspecActionsPanel
    extends EditorNotificationPanel {
        @NotNull
        final VirtualFile myFile;

        FlutterPubspecActionsPanel(@NotNull VirtualFile file) {
            if (file == null) {
                FlutterPubspecActionsPanel.$$$reportNull$$$0(0);
            }
            super(EditorColors.GUTTER_BACKGROUND);
            this.myFile = file;
            this.icon(FlutterIcons.Flutter);
            this.text("Flutter commands");
            HyperlinkLabel label = this.createActionLabel("Packages get", () -> this.runPackagesGet(false));
            label.setToolTipText("Install referenced packages");
            label = this.createActionLabel("Packages upgrade", () -> this.runPackagesGet(true));
            label.setToolTipText("Upgrade referenced packages to the latest versions");
            this.myLinksPanel.add(new JSeparator(1));
            label = this.createActionLabel("Flutter upgrade", "flutter.upgrade");
            label.setToolTipText("Upgrade the Flutter framework to the latest version");
            this.myLinksPanel.add(new JSeparator(1));
            label = this.createActionLabel("Flutter doctor", "flutter.doctor");
            label.setToolTipText("Validate installed tools and their versions");
        }

        private void runPackagesGet(boolean upgrade) {
            Project project = ProjectLocator.getInstance().guessProjectForFile(this.myFile);
            assert (project != null);
            FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
            assert (sdk != null);
            PubRoot root = PubRoot.forDirectory(this.myFile.getParent());
            if (root != null) {
                if (!upgrade) {
                    sdk.startPackagesGet(root, project);
                } else {
                    sdk.startPackagesUpgrade(root, project);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "io/flutter/editor/FlutterPubspecNotificationProvider$FlutterPubspecActionsPanel", "<init>"));
        }
    }
}

