/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.ColorIcon;
import com.jetbrains.lang.dart.psi.DartArrayAccessExpression;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import io.flutter.editor.FlutterColors;
import io.flutter.editor.FlutterCupertinoIcons;
import io.flutter.editor.FlutterIconRenderer;
import io.flutter.editor.FlutterMaterialIcons;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FlutterEditorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            FlutterEditorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            FlutterEditorAnnotator.$$$reportNull$$$0(1);
        }
        if (holder.isBatchMode()) {
            return;
        }
        if (element instanceof DartReferenceExpression || element instanceof DartArrayAccessExpression) {
            String key;
            Icon icon;
            String text = element.getText();
            if (text.startsWith("Colors.")) {
                String key2 = text.substring("Colors.".length());
                FlutterColors.FlutterColor color = FlutterColors.getColor(key2);
                if (color != null) {
                    if (!color.isPrimary()) {
                        FlutterEditorAnnotator.attachColorIcon(element, holder, color.getAWTColor());
                    } else {
                        boolean inShadeExpression;
                        boolean inColorIndexExpression = element.getParent() instanceof DartArrayAccessExpression;
                        boolean bl = inShadeExpression = element.getParent() instanceof DartReferenceExpression && element.getParent().getText().startsWith(text + ".shade");
                        if (!inShadeExpression && !inColorIndexExpression) {
                            FlutterEditorAnnotator.attachColorIcon(element, holder, color.getAWTColor());
                        }
                    }
                }
            } else if (text.startsWith("Icons.")) {
                String key3 = text.substring("Icons.".length());
                Icon icon2 = FlutterMaterialIcons.getIconForName(key3);
                if (icon2 != null) {
                    FlutterEditorAnnotator.attachIcon(element, holder, icon2);
                }
            } else if (text.startsWith("CupertinoIcons.") && (icon = FlutterCupertinoIcons.getIconForName(key = text.substring("CupertinoIcons.".length()))) != null) {
                FlutterEditorAnnotator.attachIcon(element, holder, icon);
            }
        } else if (element instanceof DartNewExpression) {
            Integer val;
            String text = element.getText();
            String constIconDataText = "const IconData(";
            String constColorText = "const Color(";
            if (text.startsWith("const IconData(")) {
                Integer val2 = FlutterEditorAnnotator.parseNumberFromCallParam(text, "const IconData(");
                if (val2 != null) {
                    String hex = Long.toHexString(val2.intValue());
                    Icon icon = FlutterMaterialIcons.getIconForHex(hex);
                    if (icon != null) {
                        FlutterEditorAnnotator.attachIcon(element, holder, icon);
                    } else {
                        icon = FlutterCupertinoIcons.getIconForHex(hex);
                        if (icon != null) {
                            FlutterEditorAnnotator.attachIcon(element, holder, icon);
                        }
                    }
                }
            } else if (text.startsWith("const Color(") && (val = FlutterEditorAnnotator.parseNumberFromCallParam(text, "const Color(")) != null) {
                int value = val;
                Color color = new Color(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, value >> 24 & 0xFF);
                FlutterEditorAnnotator.attachColorIcon(element, holder, color);
            }
        } else if (element instanceof DartCallExpression) {
            Integer val;
            String text = element.getText();
            String iconDataText = "IconData(";
            String colorText = "Color(";
            if (text.startsWith("IconData(")) {
                Integer val3 = FlutterEditorAnnotator.parseNumberFromCallParam(text, "IconData(");
                if (val3 != null) {
                    String hex = Long.toHexString(val3.intValue());
                    Icon icon = FlutterMaterialIcons.getIconForHex(hex);
                    if (icon != null) {
                        FlutterEditorAnnotator.attachIcon(element, holder, icon);
                    } else {
                        icon = FlutterCupertinoIcons.getIconForHex(hex);
                        if (icon != null) {
                            FlutterEditorAnnotator.attachIcon(element, holder, icon);
                        }
                    }
                }
            } else if (text.startsWith("Color(") && (val = FlutterEditorAnnotator.parseNumberFromCallParam(text, "Color(")) != null) {
                int value = val;
                Color color = new Color(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, value >> 24 & 0xFF);
                FlutterEditorAnnotator.attachColorIcon(element, holder, color);
            }
        }
    }

    private static Integer parseNumberFromCallParam(String callText, String prefix) {
        if (callText.startsWith(prefix) && callText.endsWith(")")) {
            String val = callText.substring(prefix.length(), callText.length() - 1).trim();
            int index = val.indexOf(44);
            if (index != -1) {
                val = val.substring(0, index);
            }
            try {
                return val.startsWith("0x") ? Integer.parseUnsignedInt(val.substring(2), 16) : Integer.parseUnsignedInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void attachColorIcon(PsiElement element, AnnotationHolder holder, Color color) {
        FlutterEditorAnnotator.attachIcon(element, holder, (Icon)new ColorIcon(16, 12, color, true));
    }

    private static void attachIcon(PsiElement element, AnnotationHolder holder, Icon icon) {
        try {
            Annotation annotation = holder.createInfoAnnotation(element, null);
            annotation.setGutterIconRenderer((GutterIconRenderer)new FlutterIconRenderer(icon, element));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "io/flutter/editor/FlutterEditorAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

