/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.devtools;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import io.flutter.console.FlutterConsoles;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterSdk;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class WebDevManager {
    @NotNull
    private final Project project;
    private boolean installedWebdev;

    public static WebDevManager getInstance(@NotNull Project project) {
        if (project == null) {
            WebDevManager.$$$reportNull$$$0(0);
        }
        return (WebDevManager)ServiceManager.getService((Project)project, WebDevManager.class);
    }

    private WebDevManager(@NotNull Project project) {
        if (project == null) {
            WebDevManager.$$$reportNull$$$0(1);
        }
        this.installedWebdev = false;
        this.project = project;
    }

    public boolean hasInstalledWebDev() {
        return this.installedWebdev;
    }

    public CompletableFuture<Boolean> installWebdev() {
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.project);
        if (sdk == null) {
            return this.createCompletedFuture(false);
        }
        List<PubRoot> pubRoots = PubRoots.forProject(this.project);
        if (pubRoots.isEmpty()) {
            return this.createCompletedFuture(false);
        }
        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        final FlutterCommand command = sdk.flutterPackagesPub(pubRoots.get(0), "global", "activate", "webdev");
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.project, "Installing webdev...", true){
            Process process;

            public void run(@NotNull ProgressIndicator indicator) {
                block4: {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setText(this.getTitle());
                    indicator.setIndeterminate(true);
                    this.process = command.start(output -> {
                        if (output.getExitCode() != 0) {
                            String message = (output.getStdout() + "\n" + output.getStderr()).trim();
                            FlutterConsoles.displayMessage(WebDevManager.this.project, null, message, true);
                        }
                    }, null);
                    try {
                        int resultCode = this.process.waitFor();
                        if (resultCode == 0) {
                            WebDevManager.this.installedWebdev = true;
                        }
                        result.complete(resultCode == 0);
                    }
                    catch (InterruptedException | RuntimeException re) {
                        if (result.isDone()) break block4;
                        result.complete(false);
                    }
                }
                this.process = null;
            }

            public void onCancel() {
                if (this.process != null && this.process.isAlive()) {
                    this.process.destroy();
                    if (!result.isDone()) {
                        result.complete(false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "io/flutter/devtools/WebDevManager$1", "run"));
            }
        });
        return result;
    }

    private CompletableFuture<Boolean> createCompletedFuture(boolean value) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        result.complete(value);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "io/flutter/devtools/WebDevManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

