/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.devtools;

import io.flutter.sdk.FlutterSdkUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class DevToolsUtils {
    public static String generateDevToolsUrl(String devtoolsHost, int devtoolsPort, String serviceProtocolUri, String page) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("ide=" + FlutterSdkUtil.getFlutterHostEnvValue());
        if (serviceProtocolUri != null) {
            try {
                String urlParam = URLEncoder.encode(serviceProtocolUri, "UTF-8");
                String pageParam = page == null ? "" : "#" + page;
                params.add("uri=" + urlParam + pageParam);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "http://" + devtoolsHost + ":" + devtoolsPort + "/?" + String.join((CharSequence)"&", params);
    }
}

