/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.devtools;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import io.flutter.console.FlutterConsoles;
import io.flutter.devtools.DevToolsInstance;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterSdk;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class DevToolsManager {
    private final Project project;
    private boolean installedDevTools;
    private DevToolsInstance devToolsInstance;

    public static DevToolsManager getInstance(@NotNull Project project) {
        if (project == null) {
            DevToolsManager.$$$reportNull$$$0(0);
        }
        return (DevToolsManager)ServiceManager.getService((Project)project, DevToolsManager.class);
    }

    private DevToolsManager(@NotNull Project project) {
        if (project == null) {
            DevToolsManager.$$$reportNull$$$0(1);
        }
        this.installedDevTools = false;
        this.project = project;
    }

    public boolean hasInstalledDevTools() {
        return this.installedDevTools;
    }

    public CompletableFuture<Boolean> installDevTools() {
        FlutterSdk sdk = FlutterSdk.forPubOrBazel(this.project);
        if (sdk == null) {
            return this.createCompletedFuture(false);
        }
        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        PubRoot pubRoot = PubRoots.forProject(this.project).stream().findFirst().orElse(null);
        final FlutterCommand command = sdk.flutterPackagesPub(pubRoot, "global", "activate", "devtools");
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.project, "Installing DevTools...", true){
            Process process;

            public void run(@NotNull ProgressIndicator indicator) {
                block4: {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setText(this.getTitle());
                    indicator.setIndeterminate(true);
                    this.process = command.start(output -> {
                        if (output.getExitCode() != 0) {
                            String message = (output.getStdout() + "\n" + output.getStderr()).trim();
                            FlutterConsoles.displayMessage(DevToolsManager.this.project, null, message, true);
                        }
                    }, null);
                    try {
                        int resultCode = this.process.waitFor();
                        if (resultCode == 0) {
                            DevToolsManager.this.installedDevTools = true;
                        }
                        result.complete(resultCode == 0);
                    }
                    catch (InterruptedException | RuntimeException re) {
                        if (result.isDone()) break block4;
                        result.complete(false);
                    }
                }
                this.process = null;
            }

            public void onCancel() {
                if (this.process != null && this.process.isAlive()) {
                    this.process.destroy();
                    if (!result.isDone()) {
                        result.complete(false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "io/flutter/devtools/DevToolsManager$1", "run"));
            }
        });
        return result;
    }

    public void openBrowser() {
        this.openBrowserImpl(null, null);
    }

    public void openBrowserAndConnect(String uri) {
        this.openBrowserAndConnect(uri, null);
    }

    public void openBrowserAndConnect(String uri, String page) {
        this.openBrowserImpl(uri, page);
    }

    private void openBrowserImpl(String uri, String page) {
        if (this.devToolsInstance != null) {
            this.devToolsInstance.openBrowserAndConnect(uri, page);
            return;
        }
        FlutterSdk sdk = FlutterSdk.forPubOrBazel(this.project);
        if (sdk == null) {
            return;
        }
        DevToolsInstance.startServer(this.project, sdk, instance -> {
            this.devToolsInstance = instance;
            this.devToolsInstance.openBrowserAndConnect(uri, page);
        }, instance -> {
            this.devToolsInstance = null;
        });
    }

    private CompletableFuture<Boolean> createCompletedFuture(boolean value) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        result.complete(value);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "io/flutter/devtools/DevToolsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

