/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.devtools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import io.flutter.devtools.Callback;
import io.flutter.devtools.DevToolsUtils;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;

class DevToolsInstance {
    final String devtoolsHost;
    final int devtoolsPort;

    public static void startServer(Project project, FlutterSdk sdk, final Callback<DevToolsInstance> onSuccess, final Callback<DevToolsInstance> onClose) {
        PubRoot pubRoot = PubRoots.forProject(project).stream().findFirst().orElse(null);
        FlutterCommand command = sdk.flutterPackagesPub(pubRoot, "global", "run", "devtools", "--machine", "--port=0");
        final OSProcessHandler processHandler = command.startInConsole(project);
        if (processHandler == null) {
            return;
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((text = event.getText().trim()).startsWith("{") && text.endsWith("}")) {
                    try {
                        JsonParser jsonParser = new JsonParser();
                        JsonElement element = jsonParser.parse(text);
                        JsonObject obj = element.getAsJsonObject();
                        JsonObject params = obj.getAsJsonObject("params");
                        String host = JsonUtils.getStringMember(params, "host");
                        int port = JsonUtils.getIntMember(params, "port");
                        if (port != -1) {
                            DevToolsInstance instance = new DevToolsInstance(host, port);
                            onSuccess.call(instance);
                        } else {
                            processHandler.destroyProcess();
                        }
                    }
                    catch (JsonSyntaxException e) {
                        processHandler.destroyProcess();
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                onClose.call(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/devtools/DevToolsInstance$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    DevToolsInstance(String devtoolsHost, int devtoolsPort) {
        this.devtoolsHost = devtoolsHost;
        this.devtoolsPort = devtoolsPort;
    }

    public void openBrowserAndConnect(String serviceProtocolUri, String page) {
        BrowserLauncher.getInstance().browse(DevToolsUtils.generateDevToolsUrl(this.devtoolsHost, this.devtoolsPort, serviceProtocolUri, page), null);
    }
}

