/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FlutterRequestUtilities {
    private static final String FILE = "file";
    private static final String ID = "id";
    private static final String METHOD = "method";
    private static final String PARAMS = "params";
    private static final String OFFSET = "offset";
    private static final String SUBSCRIPTIONS = "subscriptions";
    private static final String METHOD_FLUTTER_SET_SUBSCRIPTIONS = "flutter.setSubscriptions";

    private FlutterRequestUtilities() {
    }

    public static JsonObject generateAnalysisSetSubscriptions(String id, Map<String, List<String>> subscriptions) {
        JsonObject params = new JsonObject();
        params.add(SUBSCRIPTIONS, FlutterRequestUtilities.buildJsonElement(subscriptions));
        return FlutterRequestUtilities.buildJsonObjectRequest(id, METHOD_FLUTTER_SET_SUBSCRIPTIONS, params);
    }

    @NotNull
    private static JsonElement buildJsonElement(Object object) {
        if (object instanceof Boolean) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Boolean)object);
            if (jsonPrimitive == null) {
                FlutterRequestUtilities.$$$reportNull$$$0(0);
            }
            return jsonPrimitive;
        }
        if (object instanceof Number) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)object);
            if (jsonPrimitive == null) {
                FlutterRequestUtilities.$$$reportNull$$$0(1);
            }
            return jsonPrimitive;
        }
        if (object instanceof String) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((String)object);
            if (jsonPrimitive == null) {
                FlutterRequestUtilities.$$$reportNull$$$0(2);
            }
            return jsonPrimitive;
        }
        if (object instanceof List) {
            List list = (List)object;
            JsonArray jsonArray = new JsonArray();
            for (Object item : list) {
                JsonElement jsonItem = FlutterRequestUtilities.buildJsonElement(item);
                jsonArray.add(jsonItem);
            }
            JsonArray jsonArray2 = jsonArray;
            if (jsonArray2 == null) {
                FlutterRequestUtilities.$$$reportNull$$$0(3);
            }
            return jsonArray2;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Unable to convert to string: " + FlutterRequestUtilities.getClassName(key));
                }
                String keyString = (String)key;
                Object value = entry.getValue();
                JsonElement valueJson = FlutterRequestUtilities.buildJsonElement(value);
                jsonObject.add(keyString, valueJson);
            }
            JsonObject jsonObject2 = jsonObject;
            if (jsonObject2 == null) {
                FlutterRequestUtilities.$$$reportNull$$$0(4);
            }
            return jsonObject2;
        }
        throw new IllegalArgumentException("Unable to convert to JSON: " + object);
    }

    private static JsonObject buildJsonObjectRequest(String idValue, String methodValue) {
        return FlutterRequestUtilities.buildJsonObjectRequest(idValue, methodValue, null);
    }

    private static JsonObject buildJsonObjectRequest(String idValue, String methodValue, JsonObject params) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(ID, idValue);
        jsonObject.addProperty(METHOD, methodValue);
        if (params != null) {
            jsonObject.add(PARAMS, (JsonElement)params);
        }
        return jsonObject;
    }

    private static String getClassName(Object object) {
        return object != null ? object.getClass().getName() : "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/dart/FlutterRequestUtilities", "buildJsonElement"));
    }
}

