/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.google.common.collect.Lists;
import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.AnalysisServerListenerAdapter;
import com.google.dart.server.ResponseListener;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.dart.DartPlugin;
import io.flutter.dart.FlutterOutlineListener;
import io.flutter.dart.FlutterRequestUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;

public class FlutterDartAnalysisServer {
    private static final String FLUTTER_NOTIFICATION_OUTLINE = "flutter.outline";
    @NotNull
    final DartAnalysisServerService analysisService;
    private final Map<String, List<String>> subscriptions;
    private final Map<String, List<FlutterOutlineListener>> fileOutlineListeners;

    @NotNull
    public static FlutterDartAnalysisServer getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(0);
        }
        FlutterDartAnalysisServer flutterDartAnalysisServer = (FlutterDartAnalysisServer)ServiceManager.getService((Project)project, FlutterDartAnalysisServer.class);
        if (flutterDartAnalysisServer == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(1);
        }
        return flutterDartAnalysisServer;
    }

    private FlutterDartAnalysisServer(@NotNull Project project) {
        if (project == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(2);
        }
        this.subscriptions = new HashMap<String, List<String>>();
        this.fileOutlineListeners = new HashMap<String, List<FlutterOutlineListener>>();
        this.analysisService = DartPlugin.getInstance().getAnalysisService(project);
        this.analysisService.addResponseListener((ResponseListener)new CompatibleResponseListener());
        this.analysisService.addAnalysisServerListener((AnalysisServerListener)new AnalysisServerListenerAdapter(){

            public void serverConnected(String s) {
                if (!FlutterDartAnalysisServer.this.subscriptions.isEmpty()) {
                    FlutterDartAnalysisServer.this.sendSubscriptions();
                }
            }
        });
    }

    public void addOutlineListener(@NotNull String filePath, @NotNull FlutterOutlineListener listener) {
        List listeners;
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(3);
        }
        if (listener == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(4);
        }
        if ((listeners = this.fileOutlineListeners.computeIfAbsent(filePath, k -> new ArrayList())).add(listener)) {
            this.addSubscription("OUTLINE", filePath);
        }
    }

    public void removeOutlineListener(@NotNull String filePath, @NotNull FlutterOutlineListener listener) {
        List<FlutterOutlineListener> listeners;
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(5);
        }
        if (listener == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(6);
        }
        if ((listeners = this.fileOutlineListeners.get(filePath)) != null && listeners.remove(listener)) {
            this.removeSubscription("OUTLINE", filePath);
        }
    }

    private void addSubscription(@NotNull String service, @NotNull String filePath) {
        List files;
        if (service == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(8);
        }
        if ((files = this.subscriptions.computeIfAbsent(service, k -> new ArrayList())).add(filePath)) {
            this.sendSubscriptions();
        }
    }

    private void removeSubscription(@NotNull String service, @NotNull String filePath) {
        List<String> files;
        if (service == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(9);
        }
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(10);
        }
        if ((files = this.subscriptions.get(service)) != null && files.remove(filePath)) {
            this.sendSubscriptions();
        }
    }

    private void sendSubscriptions() {
        String id = this.analysisService.generateUniqueId();
        this.analysisService.sendRequest(id, FlutterRequestUtilities.generateAnalysisSetSubscriptions(id, this.subscriptions));
    }

    @NotNull
    public List<SourceChange> edit_getAssists(@NotNull VirtualFile file, int offset, int length) {
        if (file == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(11);
        }
        List list = this.analysisService.edit_getAssists(file, offset, length);
        if (list == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(12);
        }
        return list;
    }

    private void processString(String jsonString) {
        this.processResponse((JsonObject)new Gson().fromJson(jsonString, JsonObject.class));
    }

    private void processResponse(JsonObject response) {
        this.processNotification(response);
    }

    private boolean processNotification(JsonObject response) {
        JsonElement eventElement = response.get("event");
        if (eventElement == null || !eventElement.isJsonPrimitive()) {
            return false;
        }
        String event = eventElement.getAsString();
        if (event.equals(FLUTTER_NOTIFICATION_OUTLINE)) {
            JsonObject paramsObject = response.get("params").getAsJsonObject();
            String file = paramsObject.get("file").getAsString();
            JsonElement instrumentedCodeElement = paramsObject.get("instrumentedCode");
            String instrumentedCode = instrumentedCodeElement != null ? instrumentedCodeElement.getAsString() : null;
            JsonObject outlineObject = paramsObject.get("outline").getAsJsonObject();
            FlutterOutline outline = FlutterOutline.fromJson(outlineObject);
            List<FlutterOutlineListener> listeners = this.fileOutlineListeners.get(file);
            if (listeners != null) {
                for (FlutterOutlineListener listener : Lists.newArrayList(listeners)) {
                    listener.outlineUpdated(file, outline, instrumentedCode);
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/dart/FlutterDartAnalysisServer";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/dart/FlutterDartAnalysisServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "edit_getAssists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addOutlineListener";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeOutlineListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSubscription";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeSubscription";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "edit_getAssists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class CompatibleResponseListener
    implements ResponseListener {
        CompatibleResponseListener() {
        }

        public void onResponse(JsonObject jsonObject) {
            FlutterDartAnalysisServer.this.processResponse(jsonObject);
        }

        public void onResponse(String jsonString) {
            FlutterDartAnalysisServer.this.processString(jsonString);
        }
    }
}

