/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.actions.DartPubActionBase;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateOption;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPlugin {
    private static final Version MINIMUM_VERSION = Version.parseVersion((String)"171.3780.79");
    private static final DartPlugin INSTANCE = new DartPlugin();
    private Version myVersion;

    public static DartPlugin getInstance() {
        return INSTANCE;
    }

    @Nullable
    public static DartSdk getDartSdk(@NotNull Project project) {
        if (project == null) {
            DartPlugin.$$$reportNull$$$0(0);
        }
        return DartSdk.getDartSdk((Project)project);
    }

    public static boolean isDartSdkEnabled(@NotNull Module module) {
        if (module == null) {
            DartPlugin.$$$reportNull$$$0(1);
        }
        return DartSdkLibUtil.isDartSdkEnabled((Module)module);
    }

    public static void enableDartSdk(@NotNull Module module) {
        if (module == null) {
            DartPlugin.$$$reportNull$$$0(2);
        }
        DartSdkLibUtil.enableDartSdk((Module)module);
    }

    public static void ensureDartSdkConfigured(@NotNull Project project, @NotNull String sdkHomePath) {
        if (project == null) {
            DartPlugin.$$$reportNull$$$0(3);
        }
        if (sdkHomePath == null) {
            DartPlugin.$$$reportNull$$$0(4);
        }
        DartSdkLibUtil.ensureDartSdkConfigured((Project)project, (String)sdkHomePath);
    }

    public static void disableDartSdk(@NotNull Collection<Module> modules) {
        if (modules == null) {
            DartPlugin.$$$reportNull$$$0(5);
        }
        DartSdkLibUtil.disableDartSdk(modules);
    }

    public static boolean isDartSdkHome(@Nullable String path) {
        return DartSdkUtil.isDartSdkHome((String)path);
    }

    public static boolean isPubActionInProgress() {
        return DartPubActionBase.isInProgress();
    }

    public static void setPubActionInProgress(boolean inProgress) {
        DartPubActionBase.setIsInProgress((boolean)inProgress);
    }

    public static boolean isDartRunConfiguration(ConfigurationType type) {
        return type.getId().equals("DartCommandLineRunConfigurationType");
    }

    public static boolean isDartTestConfiguration(ConfigurationType type) {
        return type.getId().equals("DartTestRunConfigurationType");
    }

    public static DartSdkUpdateOption doCheckForUpdates() {
        return DartSdkUpdateOption.getDartSdkUpdateOption();
    }

    public static void setCheckForUpdates(DartSdkUpdateOption sdkUpdateOption) {
        DartSdkUpdateOption.setDartSdkUpdateOption((DartSdkUpdateOption)sdkUpdateOption);
    }

    public Version getMinimumVersion() {
        return MINIMUM_VERSION;
    }

    public Version getVersion() {
        if (this.myVersion == null) {
            IdeaPluginDescriptor descriptor = PluginManager.getPlugin((PluginId)PluginId.getId((String)"Dart"));
            assert (descriptor != null);
            this.myVersion = Version.parseVersion((String)descriptor.getVersion());
        }
        return this.myVersion;
    }

    public DartAnalysisServerService getAnalysisService(@NotNull Project project) {
        if (project == null) {
            DartPlugin.$$$reportNull$$$0(6);
        }
        return (DartAnalysisServerService)ServiceManager.getService((Project)project, DartAnalysisServerService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        objectArray2[1] = "io/flutter/dart/DartPlugin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDartSdk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDartSdkEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enableDartSdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureDartSdkConfigured";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "disableDartSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnalysisService";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

