/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.console;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import io.flutter.console.FlutterConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterConsoles {
    static final Key<FlutterConsole> KEY = Key.create((String)"FLUTTER_CONSOLE_KEY");

    private FlutterConsoles() {
    }

    public static void displayProcessLater(@NotNull OSProcessHandler process, @NotNull Project project, @Nullable Module module, @NotNull Runnable onReady) {
        if (process == null) {
            FlutterConsoles.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlutterConsoles.$$$reportNull$$$0(1);
        }
        if (onReady == null) {
            FlutterConsoles.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)project);
            messageView.runWhenInitialized(() -> {
                FlutterConsole console = FlutterConsoles.findOrCreate(project, module);
                console.watchProcess(process);
                console.bringToFront();
                onReady.run();
            });
        });
    }

    public static void displayMessage(@NotNull Project project, @Nullable Module module, @NotNull String message) {
        if (project == null) {
            FlutterConsoles.$$$reportNull$$$0(3);
        }
        if (message == null) {
            FlutterConsoles.$$$reportNull$$$0(4);
        }
        FlutterConsoles.displayMessage(project, module, message, false);
    }

    public static void displayMessage(@NotNull Project project, @Nullable Module module, @NotNull String message, boolean clearContent) {
        if (project == null) {
            FlutterConsoles.$$$reportNull$$$0(5);
        }
        if (message == null) {
            FlutterConsoles.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)project);
            messageView.runWhenInitialized(() -> {
                FlutterConsole console = FlutterConsoles.findOrCreate(project, module);
                if (clearContent) {
                    console.view.clear();
                }
                console.view.print(message, ConsoleViewContentType.NORMAL_OUTPUT);
                console.bringToFront();
            });
        });
    }

    @NotNull
    static FlutterConsole findOrCreate(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            FlutterConsoles.$$$reportNull$$$0(7);
        }
        for (Content content : MessageView.SERVICE.getInstance((Project)project).getContentManager().getContents()) {
            FlutterConsole console = (FlutterConsole)content.getUserData(KEY);
            if (console == null || console.module != module) continue;
            assert (project == console.project);
            FlutterConsole flutterConsole = console;
            if (flutterConsole == null) {
                FlutterConsoles.$$$reportNull$$$0(8);
            }
            return flutterConsole;
        }
        FlutterConsole console = FlutterConsole.create(project, module);
        console.content.putUserData(KEY, (Object)console);
        FlutterConsole flutterConsole = console;
        if (flutterConsole == null) {
            FlutterConsoles.$$$reportNull$$$0(9);
        }
        return flutterConsole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onReady";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/console/FlutterConsoles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/console/FlutterConsoles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "displayProcessLater";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "displayMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreate";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

