/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.console;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import io.flutter.console.FlutterConsoleFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlutterConsole {
    @NotNull
    final ConsoleView view;
    @NotNull
    final Content content;
    @NotNull
    final Project project;
    @Nullable
    final Module module;
    @Nullable
    private Runnable cancelProcessSubscription;

    private FlutterConsole(@NotNull ConsoleView view, @NotNull Content content, @NotNull Project project, @Nullable Module module) {
        if (view == null) {
            FlutterConsole.$$$reportNull$$$0(0);
        }
        if (content == null) {
            FlutterConsole.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FlutterConsole.$$$reportNull$$$0(2);
        }
        this.view = view;
        this.content = content;
        this.project = project;
        this.module = module;
    }

    @NotNull
    static FlutterConsole create(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            FlutterConsole.$$$reportNull$$$0(3);
        }
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        builder.setViewer(true);
        if (module != null) {
            builder.addFilter((Filter)new FlutterConsoleFilter(module));
        }
        ConsoleView view = builder.getConsole();
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
        panel.setContent(view.getComponent());
        String title = module != null ? "[" + module.getName() + "] Flutter" : "Flutter";
        Content content = ContentFactory.SERVICE.getInstance().createContent(panel.getComponent(), title, true);
        Disposer.register((Disposable)content, (Disposable)view);
        FlutterConsole flutterConsole = new FlutterConsole(view, content, project, module);
        if (flutterConsole == null) {
            FlutterConsole.$$$reportNull$$$0(4);
        }
        return flutterConsole;
    }

    void watchProcess(@NotNull OSProcessHandler process) {
        if (process == null) {
            FlutterConsole.$$$reportNull$$$0(5);
        }
        if (this.cancelProcessSubscription != null) {
            this.cancelProcessSubscription.run();
            this.cancelProcessSubscription = null;
        }
        this.view.clear();
        this.view.attachToProcess((ProcessHandler)process);
        ProcessAdapter listener = new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                FlutterConsole.this.view.print("Process finished with exit code " + event.getExitCode(), ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        };
        process.addProcessListener((ProcessListener)listener);
        this.cancelProcessSubscription = () -> process.removeProcessListener((ProcessListener)listener);
    }

    void bringToFront() {
        MessageView messageView = MessageView.SERVICE.getInstance((Project)this.project);
        ContentManager contentManager = messageView.getContentManager();
        contentManager.addContent(this.content);
        contentManager.setSelectedContent(this.content);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        toolWindow.activate(null, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/console/FlutterConsole";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/console/FlutterConsole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "watchProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

