/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.bazel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.bazel.PluginConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Workspace {
    private static final String PLUGIN_CONFIG_PATH = "dart/config/intellij-plugins/flutter.json";
    @NotNull
    private final VirtualFile root;
    @Nullable
    private final PluginConfig config;
    @Nullable
    private final String daemonScript;
    @Nullable
    private final String doctorScript;
    @Nullable
    private final String testScript;
    @Nullable
    private final String sdkHome;
    @Nullable
    private final String versionFile;
    private static final Logger LOG = Logger.getInstance(Workspace.class);

    private Workspace(@NotNull VirtualFile root, @Nullable PluginConfig config, @Nullable String daemonScript, @Nullable String doctorScript, @Nullable String testScript, @Nullable String sdkHome, @Nullable String versionFile) {
        if (root == null) {
            Workspace.$$$reportNull$$$0(0);
        }
        this.root = root;
        this.config = config;
        this.daemonScript = daemonScript;
        this.doctorScript = doctorScript;
        this.testScript = testScript;
        this.sdkHome = sdkHome;
        this.versionFile = versionFile;
    }

    @NotNull
    public ImmutableSet<String> getContentPaths(@NotNull Module module) {
        if (module == null) {
            Workspace.$$$reportNull$$$0(1);
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (VirtualFile root : contentRoots) {
            String path = this.getRelativePath(root);
            if (path == null) continue;
            result.add((Object)path);
        }
        ImmutableSet immutableSet = result.build();
        if (immutableSet == null) {
            Workspace.$$$reportNull$$$0(2);
        }
        return immutableSet;
    }

    @Nullable
    public String getRelativePath(@Nullable VirtualFile file) {
        ArrayList<String> path = new ArrayList<String>();
        while (file != null) {
            if (file.equals(this.root)) {
                if (path.isEmpty()) {
                    return null;
                }
                Collections.reverse(path);
                return Joiner.on((char)'/').join(path);
            }
            path.add(file.getName());
            file = file.getParent();
        }
        return null;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.root;
        if (virtualFile == null) {
            Workspace.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    public String getDaemonScript() {
        return this.daemonScript;
    }

    @Nullable
    public String getDoctorScript() {
        return this.doctorScript;
    }

    @Nullable
    public String getLaunchScript() {
        return this.config == null ? null : this.config.getLaunchScript();
    }

    @Nullable
    public String getTestScript() {
        return this.testScript;
    }

    @Nullable
    public String getSdkHome() {
        return this.sdkHome;
    }

    @Nullable
    public String getVersionFile() {
        return this.versionFile;
    }

    public boolean hasPluginConfig() {
        return this.config != null;
    }

    @NotNull
    public Set<String> getDependencies() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)"WORKSPACE", (Object)PLUGIN_CONFIG_PATH);
        if (immutableSet == null) {
            Workspace.$$$reportNull$$$0(4);
        }
        return immutableSet;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Workspace)) {
            return false;
        }
        Workspace other = (Workspace)obj;
        return Objects.equal((Object)this.root, (Object)other.root) && Objects.equal((Object)this.config, (Object)other.config);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.root, this.config});
    }

    @Nullable
    public static Workspace load(@NotNull Project project) {
        VirtualFile workspaceFile;
        if (project == null) {
            Workspace.$$$reportNull$$$0(5);
        }
        if ((workspaceFile = Workspace.findWorkspaceFile(project)) == null) {
            return null;
        }
        VirtualFile root = workspaceFile.getParent();
        String readonlyPath = "../READONLY/" + root.getName();
        VirtualFile readonlyRoot = root.findFileByRelativePath(readonlyPath);
        VirtualFile configFile = root.findFileByRelativePath(PLUGIN_CONFIG_PATH);
        if (configFile == null && readonlyRoot != null) {
            configFile = readonlyRoot.findFileByRelativePath(PLUGIN_CONFIG_PATH);
        }
        PluginConfig config = configFile == null ? null : PluginConfig.load(configFile);
        String daemonScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getDaemonScript());
        String doctorScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getDoctorScript());
        String testScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getTestScript());
        String sdkHome = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getSdkHome());
        String versionFile = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getVersionFile());
        return new Workspace(root, config, daemonScript, doctorScript, testScript, sdkHome, versionFile);
    }

    @VisibleForTesting
    public static Workspace forTest(VirtualFile workspaceRoot, PluginConfig pluginConfig) {
        return new Workspace(workspaceRoot, pluginConfig, pluginConfig.getDaemonScript(), pluginConfig.getDoctorScript(), pluginConfig.getTestScript(), pluginConfig.getSdkHome(), pluginConfig.getVersionFile());
    }

    private static String getScriptFromPath(@NotNull VirtualFile root, @NotNull String readonlyPath, @Nullable String relativeScriptPath) {
        if (root == null) {
            Workspace.$$$reportNull$$$0(6);
        }
        if (readonlyPath == null) {
            Workspace.$$$reportNull$$$0(7);
        }
        if (relativeScriptPath == null) {
            return null;
        }
        String readonlyScriptPath = readonlyPath + "/" + relativeScriptPath;
        if (root.findFileByRelativePath(relativeScriptPath) != null) {
            return relativeScriptPath;
        }
        if (root.findFileByRelativePath(readonlyScriptPath) != null) {
            return readonlyScriptPath;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findWorkspaceFile(@NotNull Project p) {
        if (p == null) {
            Workspace.$$$reportNull$$$0(8);
        }
        Computable readAction = () -> {
            HashMap<String, VirtualFile> candidates = new HashMap<String, VirtualFile>();
            for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)p).getContentRoots()) {
                VirtualFile wf = Workspace.findContainingWorkspaceFile(contentRoot);
                if (wf == null) continue;
                candidates.put(wf.getPath(), wf);
            }
            if (candidates.size() == 1) {
                return (VirtualFile)candidates.values().iterator().next();
            }
            return null;
        };
        return (VirtualFile)ApplicationManager.getApplication().runReadAction(readAction);
    }

    @Nullable
    private static VirtualFile findContainingWorkspaceFile(@NotNull VirtualFile dir) {
        if (dir == null) {
            Workspace.$$$reportNull$$$0(9);
        }
        while (dir != null) {
            VirtualFile child = dir.findChild("WORKSPACE");
            if (child != null && child.exists() && !child.isDirectory()) {
                return child;
            }
            dir = dir.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/bazel/Workspace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readonlyPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/bazel/Workspace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContentPaths";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFromPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findContainingWorkspaceFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

