/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.bazel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginConfig {
    @NotNull
    private final Fields fields;
    private static final Gson GSON = new Gson();
    private static final Logger LOG = Logger.getInstance(PluginConfig.class);

    private PluginConfig(@NotNull Fields fields) {
        if (fields == null) {
            PluginConfig.$$$reportNull$$$0(0);
        }
        this.fields = fields;
    }

    @Nullable
    String getDaemonScript() {
        return this.fields.daemonScript;
    }

    @Nullable
    String getDoctorScript() {
        return this.fields.doctorScript;
    }

    @Nullable
    String getLaunchScript() {
        return this.fields.launchScript;
    }

    @Nullable
    String getTestScript() {
        return this.fields.testScript;
    }

    @Nullable
    String getSdkHome() {
        return this.fields.sdkHome;
    }

    @Nullable
    String getVersionFile() {
        return this.fields.versionFile;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginConfig)) {
            return false;
        }
        PluginConfig other = (PluginConfig)obj;
        return Objects.equal((Object)this.fields, (Object)other.fields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fields});
    }

    @Nullable
    public static PluginConfig load(@NotNull VirtualFile file) {
        if (file == null) {
            PluginConfig.$$$reportNull$$$0(1);
        }
        Computable readAction = () -> {
            try (InputStreamReader input = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);){
                Fields fields = (Fields)GSON.fromJson((Reader)input, Fields.class);
                PluginConfig pluginConfig = new PluginConfig(fields);
                return pluginConfig;
            }
            catch (FileNotFoundException e) {
                LOG.info("Flutter plugin didn't find flutter.json at " + file.getPath());
                return null;
            }
            catch (IOException e) {
                FlutterUtils.warn(LOG, "Flutter plugin failed to load config file at " + file.getPath(), e);
                return null;
            }
            catch (JsonSyntaxException e) {
                FlutterUtils.warn(LOG, "Flutter plugin failed to parse JSON in config file at " + file.getPath());
                return null;
            }
            catch (PatternSyntaxException e) {
                FlutterUtils.warn(LOG, "Flutter plugin failed to parse directory pattern (" + e.getPattern() + ") in config file at " + file.getPath());
                return null;
            }
        };
        return (PluginConfig)ApplicationManager.getApplication().runReadAction(readAction);
    }

    @VisibleForTesting
    public static PluginConfig forTest(@Nullable String daemonScript, @Nullable String doctorScript, @Nullable String launchScript, @Nullable String testScript, @Nullable String sdkHome, @Nullable String versionFile) {
        Fields fields = new Fields(daemonScript, doctorScript, launchScript, testScript, sdkHome, versionFile);
        return new PluginConfig(fields);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "io/flutter/bazel/PluginConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Fields {
        @SerializedName(value="daemonScript")
        private String daemonScript;
        @SerializedName(value="doctorScript")
        private String doctorScript;
        @SerializedName(value="launchScript")
        private String launchScript;
        @SerializedName(value="testScript")
        private String testScript;
        @SerializedName(value="sdkHome")
        private String sdkHome;
        @SerializedName(value="versionFile")
        private String versionFile;

        Fields() {
        }

        Fields(String daemonScript, String doctorScript, String launchScript, String testScript, String sdkHome, String versionFile) {
            this.daemonScript = daemonScript;
            this.doctorScript = doctorScript;
            this.launchScript = launchScript;
            this.testScript = testScript;
            this.sdkHome = sdkHome;
            this.versionFile = versionFile;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Fields)) {
                return false;
            }
            Fields other = (Fields)obj;
            return Objects.equal((Object)this.daemonScript, (Object)other.daemonScript) && Objects.equal((Object)this.doctorScript, (Object)other.doctorScript) && Objects.equal((Object)this.launchScript, (Object)other.launchScript) && Objects.equal((Object)this.testScript, (Object)other.testScript) && Objects.equal((Object)this.sdkHome, (Object)other.sdkHome) && Objects.equal((Object)this.versionFile, (Object)other.versionFile);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.daemonScript, this.doctorScript, this.launchScript, this.testScript, this.sdkHome, this.versionFile});
        }
    }
}

