/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.analytics;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.QueueProcessor;
import io.flutter.analytics.ThrottlingBucket;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Analytics {
    public static final String GROUP_DISPLAY_ID = "Flutter Usage Statistics";
    private static final String analyticsUrl = "https://www.google-analytics.com/collect";
    private static final String applicationName = "Flutter IntelliJ Plugin";
    private static final String trackingId = "UA-67589403-7";
    private static final int maxExceptionLength = 512;
    @NotNull
    private final String clientId;
    @NotNull
    private final String pluginVersion;
    @NotNull
    private final String platformName;
    @NotNull
    private final String platformVersion;
    private Transport transport;
    private final ThrottlingBucket bucket;
    private boolean myCanSend;

    public Analytics(@NotNull String clientId, @NotNull String pluginVersion, @NotNull String platformName, @NotNull String platformVersion) {
        if (clientId == null) {
            Analytics.$$$reportNull$$$0(0);
        }
        if (pluginVersion == null) {
            Analytics.$$$reportNull$$$0(1);
        }
        if (platformName == null) {
            Analytics.$$$reportNull$$$0(2);
        }
        if (platformVersion == null) {
            Analytics.$$$reportNull$$$0(3);
        }
        this.transport = new HttpTransport();
        this.bucket = new ThrottlingBucket(20);
        this.myCanSend = false;
        this.clientId = clientId;
        this.pluginVersion = pluginVersion;
        this.platformName = platformName;
        this.platformVersion = platformVersion;
    }

    @NotNull
    public String getClientId() {
        String string = this.clientId;
        if (string == null) {
            Analytics.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean canSend() {
        return this.myCanSend;
    }

    public void setCanSend(boolean value) {
        this.myCanSend = value;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void sendScreenView(@NotNull String viewName) {
        if (viewName == null) {
            Analytics.$$$reportNull$$$0(5);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("cd", viewName);
        this.sendPayload("screenview", args);
    }

    public void sendEvent(String category, String action) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("ec", category);
        args.put("ea", action);
        this.sendPayload("event", args);
    }

    public void sendEventMetric(String category, String action, int value) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("ec", category);
        args.put("ea", action);
        args.put("ev", Integer.toString(value));
        this.sendPayload("event", args);
    }

    public void sendTiming(String category, String variable, long timeMillis) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("utc", category);
        args.put("utv", variable);
        args.put("utt", Long.toString(timeMillis));
        this.sendPayload("timing", args);
    }

    public void sendException(Throwable throwable, boolean isFatal) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(throwable.getClass().getName() + ":");
        for (StackTraceElement element : throwable.getStackTrace()) {
            printWriter.println(element.toString());
        }
        String description = stringWriter.toString().trim();
        description = description.replaceAll("com.intellij.openapi.", "c.i.o.");
        if ((description = description.replaceAll("com.intellij.", "c.i.")).length() > 512) {
            description = description.substring(0, 512);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("exd", description);
        if (isFatal) {
            args.put("'exf'", "1");
        }
        this.sendPayload("exception", args);
    }

    private void sendPayload(@NotNull String hitType, @NotNull Map<String, String> args) {
        if (hitType == null) {
            Analytics.$$$reportNull$$$0(6);
        }
        if (args == null) {
            Analytics.$$$reportNull$$$0(7);
        }
        if (!this.canSend()) {
            return;
        }
        if (!this.bucket.removeDrop()) {
            return;
        }
        args.put("v", "1");
        args.put("ds", "app");
        args.put("an", applicationName);
        args.put("av", this.pluginVersion);
        args.put("aiid", this.platformName);
        args.put("cd1", this.platformVersion);
        args.put("tid", trackingId);
        args.put("cid", this.clientId);
        args.put("t", hitType);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        args.put("sr", screenSize.width + "x" + screenSize.height);
        String language = System.getProperty("user.language");
        if (language != null) {
            args.put("ul", language);
        }
        this.transport.send(analyticsUrl, args);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/analytics/Analytics";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hitType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/analytics/Analytics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendScreenView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendPayload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpTransport
    implements Transport {
        private final QueueProcessor<Runnable> sendingQueue = QueueProcessor.createRunnableQueueProcessor();

        private HttpTransport() {
        }

        @Nullable
        private static String createUserAgent() {
            String locale = Locale.getDefault().toString();
            if (SystemInfo.isWindows) {
                return "Mozilla/5.0 (Windows; Windows; Windows; " + locale + ")";
            }
            if (SystemInfo.isMac) {
                return "Mozilla/5.0 (Macintosh; Intel Mac OS X; Macintosh; " + locale + ")";
            }
            if (SystemInfo.isLinux) {
                return "Mozilla/5.0 (Linux; Linux; Linux; " + locale + ")";
            }
            return null;
        }

        @Override
        public void send(String url, Map<String, String> values) {
            this.sendingQueue.add(() -> {
                try {
                    StringBuilder postData = new StringBuilder();
                    for (Map.Entry param : values.entrySet()) {
                        if (postData.length() != 0) {
                            postData.append('&');
                        }
                        postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
                        postData.append('=');
                        postData.append(URLEncoder.encode((String)param.getValue(), "UTF-8"));
                    }
                    byte[] postDataBytes = postData.toString().getBytes(StandardCharsets.UTF_8);
                    HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                    String userAgent = HttpTransport.createUserAgent();
                    if (userAgent != null) {
                        conn.setRequestProperty("User-Agent", HttpTransport.createUserAgent());
                    }
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(postDataBytes);
                    InputStream in = conn.getInputStream();
                    in.read();
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public static interface Transport {
        public void send(String var1, Map<String, String> var2);
    }
}

