/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterConstants;
import io.flutter.FlutterInitializer;
import io.flutter.actions.FlutterAppAction;
import io.flutter.actions.RestartFlutterApp;
import io.flutter.run.FlutterReloadManager;
import io.flutter.run.daemon.FlutterApp;
import org.jetbrains.annotations.NotNull;

public class ReloadFlutterApp
extends FlutterAppAction {
    public static final String ID = "Flutter.ReloadFlutterApp";
    public static final String TEXT = FlutterBundle.message("app.reload.action.text", new Object[0]);
    public static final String DESCRIPTION = FlutterBundle.message("app.reload.action.description", new Object[0]);

    public ReloadFlutterApp(@NotNull FlutterApp app, @NotNull Computable<Boolean> isApplicable) {
        if (app == null) {
            ReloadFlutterApp.$$$reportNull$$$0(0);
        }
        if (isApplicable == null) {
            ReloadFlutterApp.$$$reportNull$$$0(1);
        }
        super(app, TEXT, DESCRIPTION, FlutterIcons.HotReload, isApplicable, ID);
        this.copyShortcutFrom(ActionManager.getInstance().getAction("Flutter.Toolbar.ReloadAction"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean shouldRestart;
        Project project;
        if (e == null) {
            ReloadFlutterApp.$$$reportNull$$$0(2);
        }
        if ((project = ReloadFlutterApp.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        boolean bl = shouldRestart = (e.getModifiers() & 1) != 0 && !"GoToAction".equals(e.getPlace());
        if (shouldRestart) {
            FlutterInitializer.sendAnalyticsAction(RestartFlutterApp.class.getSimpleName());
            FlutterReloadManager.getInstance(project).saveAllAndRestart(this.getApp(), FlutterConstants.RELOAD_REASON_MANUAL);
        } else {
            FlutterInitializer.sendAnalyticsAction((AnAction)this);
            FlutterReloadManager.getInstance(project).saveAllAndReload(this.getApp(), FlutterConstants.RELOAD_REASON_MANUAL);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ReloadFlutterApp.$$$reportNull$$$0(3);
        }
        super.update(e);
        if (!this.getApp().appSupportsHotReload()) {
            e.getPresentation().setEnabled(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/ReloadFlutterApp";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

