/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterExternalIdeActionGroup;
import io.flutter.actions.FlutterSdkAction;
import io.flutter.actions.OpenInAndroidStudioAction;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.ProgressHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInXcodeAction
extends AnAction {
    private static VirtualFile findProjectFile(@Nullable AnActionEvent e) {
        if (e != null) {
            Project project;
            VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (file != null && file.exists()) {
                if (FlutterUtils.isXcodeFileName(file.getName())) {
                    return file;
                }
                project = e.getProject();
                assert (project != null);
                if (FlutterExternalIdeActionGroup.isWithinAndroidDirectory(file, project) || OpenInAndroidStudioAction.isProjectFileName(file.getName())) {
                    return null;
                }
            }
            if ((project = e.getProject()) != null) {
                return FlutterModuleUtils.findXcodeProjectFile(project);
            }
        }
        return null;
    }

    private static void openFile(final @NotNull VirtualFile file) {
        Project project;
        FlutterSdk sdk;
        if (file == null) {
            OpenInXcodeAction.$$$reportNull$$$0(0);
        }
        FlutterSdk flutterSdk = sdk = (project = ProjectUtil.guessProjectForFile((VirtualFile)file)) != null ? FlutterSdk.getFlutterSdk(project) : null;
        if (sdk == null) {
            FlutterSdkAction.showMissingSdkDialog(project);
            return;
        }
        PubRoot pubRoot = PubRoot.forFile(file);
        if (pubRoot == null) {
            FlutterMessages.showError("Error Opening Xcode", "Unable to run `flutter build` (no pub root found)");
            return;
        }
        if (!OpenInXcodeAction.hasBeenBuilt(pubRoot)) {
            final ProgressHelper progressHelper = new ProgressHelper(project);
            progressHelper.start("Building for iOS");
            OSProcessHandler processHandler = sdk.flutterBuild(pubRoot, "ios", "--simulator").startInConsole(project);
            if (processHandler == null) {
                progressHelper.done();
                FlutterMessages.showError("Error Opening Xcode", "unable to run `flutter build`");
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        progressHelper.done();
                        int exitCode = event.getExitCode();
                        if (exitCode != 0) {
                            FlutterMessages.showError("Error Opening Xcode", "`flutter build` returned: " + exitCode);
                            return;
                        }
                        OpenInXcodeAction.openWithXcode(file.getPath());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenInXcodeAction$1", "processTerminated"));
                    }
                });
            }
        } else {
            OpenInXcodeAction.openWithXcode(file.getPath());
        }
    }

    private static boolean hasBeenBuilt(@NotNull PubRoot pubRoot) {
        VirtualFile buildDir;
        if (pubRoot == null) {
            OpenInXcodeAction.$$$reportNull$$$0(1);
        }
        return (buildDir = pubRoot.getRoot().findChild("build")) != null && buildDir.isDirectory() && buildDir.findChild("ios") != null;
    }

    private static void openWithXcode(final String path) {
        try {
            GeneralCommandLine cmd = new GeneralCommandLine().withExePath("open").withParameters(new String[]{path});
            OSProcessHandler handler = new OSProcessHandler(cmd);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        FlutterMessages.showError("Error Opening", path);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenInXcodeAction$2", "processTerminated"));
                }
            });
            handler.startNotify();
        }
        catch (ExecutionException ex) {
            FlutterMessages.showError("Error Opening", "Exception: " + ex.getMessage());
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenInXcodeAction.$$$reportNull$$$0(2);
        }
        if (!SystemInfo.isMac) {
            event.getPresentation().setVisible(false);
        } else {
            Presentation presentation = event.getPresentation();
            boolean enabled = OpenInXcodeAction.findProjectFile(event) != null;
            presentation.setEnabled(enabled);
            presentation.setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile projectFile;
        if (e == null) {
            OpenInXcodeAction.$$$reportNull$$$0(3);
        }
        if ((projectFile = OpenInXcodeAction.findProjectFile(e)) != null) {
            OpenInXcodeAction.openFile(projectFile);
        } else {
            FlutterMessages.showError("Error Opening Xcode", "Project not found.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/OpenInXcodeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasBeenBuilt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

