/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import io.flutter.android.AndroidEmulator;
import io.flutter.android.AndroidSdk;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OpenEmulatorAction
extends AnAction {
    final AndroidEmulator emulator;

    public static List<OpenEmulatorAction> getEmulatorActions(Project project) {
        AndroidSdk sdk = AndroidSdk.createFromProject(project);
        if (sdk == null) {
            return Collections.emptyList();
        }
        List<AndroidEmulator> emulators = sdk.getEmulators();
        emulators.sort((emulator1, emulator2) -> emulator1.getName().compareToIgnoreCase(emulator2.getName()));
        return emulators.stream().map(OpenEmulatorAction::new).collect(Collectors.toList());
    }

    public OpenEmulatorAction(AndroidEmulator emulator) {
        super("Open Android Emulator: " + emulator.getName());
        this.emulator = emulator;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenEmulatorAction.$$$reportNull$$$0(0);
        }
        this.emulator.startEmulator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenEmulatorAction", "actionPerformed"));
    }
}

