/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.components.labels.LinkLabel;
import io.flutter.FlutterConstants;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.sdk.FlutterSdkUtil;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallSdkAction
extends DumbAwareAction {
    private static final String GIT_EXECUTABLE = "git";
    private final InstallAction myInstallAction;

    public InstallSdkAction(Model peer) {
        this.myInstallAction = InstallSdkAction.createInstallAction(peer);
    }

    private static GeneralCommandLine gitCommandBase() {
        return new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(GIT_EXECUTABLE);
    }

    private static InstallAction createInstallAction(Model peer) {
        return InstallSdkAction.hasGit() ? new GitCloneAction(peer) : new ViewDocsAction(peer);
    }

    private static boolean hasGit() {
        return FlutterUtils.runsCleanly(InstallSdkAction.gitCommandBase().withParameters(new String[]{"version"}));
    }

    public void actionPerformed(@Nullable AnActionEvent e) {
        this.myInstallAction.perform();
    }

    public Icon getLinkIcon() {
        return this.myInstallAction.getLinkIcon();
    }

    public String getLinkText() {
        return this.myInstallAction.getLinkText();
    }

    private static class GitCloneAction
    extends InstallAction {
        private static final String ANALYTICS_KEY = "InstallSdkRunGitAction";
        private OSProcessHandler handler;

        GitCloneAction(Model peer) {
            super(peer);
        }

        @Override
        void perform() {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFolderDescriptor()){

                public void validateSelectedFiles(VirtualFile[] files) {
                    for (VirtualFile file : files) {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
                        if (file.findChild("flutter") == null) continue;
                        throw new IllegalArgumentException("A file called 'flutter' already exists in this location.");
                    }
                }
            }.withTitle("Flutter SDK Directory").withDescription("Choose a directory to install the Flutter SDK");
            VirtualFile installTarget = FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, null);
            if (installTarget != null) {
                FlutterInitializer.sendAnalyticsAction(ANALYTICS_KEY);
                this.installTo(installTarget);
            } else {
                this.validatePeer();
            }
        }

        @Override
        public void actionCanceled() {
            this.handler.destroyProcess();
            this.validatePeer();
        }

        private void installTo(@NotNull VirtualFile directory) {
            if (directory == null) {
                GitCloneAction.$$$reportNull$$$0(0);
            }
            String installPath = directory.getPath();
            String sdkDir = new File(installPath, "flutter").getPath();
            this.setSdkPath(sdkDir);
            this.runCommand(new GitCloneCommand(installPath, sdkDir));
        }

        @Override
        String getLinkText() {
            return "Install SDK\u2026";
        }

        @Override
        Icon getLinkIcon() {
            return AllIcons.Actions.Download;
        }

        private void runCommand(@NotNull InstallCommand cmd) {
            if (cmd == null) {
                GitCloneAction.$$$reportNull$$$0(1);
            }
            try {
                this.handler = new OSProcessHandler(cmd.getCommandLine());
            }
            catch (ExecutionException e) {
                cmd.onError(e);
                return;
            }
            cmd.registerTo(this.handler);
            this.handler.startNotify();
        }

        private void setInProgress(boolean visible) {
            if (visible) {
                this.setErrorDetails(null);
            }
            this.setSdkComboEnablement(!visible);
            this.setProgressVisible(visible);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmd";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/actions/InstallSdkAction$GitCloneAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "installTo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runCommand";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class FlutterPrecacheCommand
        extends InstallCommand {
            @NotNull
            private final String mySdkDir;

            FlutterPrecacheCommand(String sdkDir) {
                if (sdkDir == null) {
                    FlutterPrecacheCommand.$$$reportNull$$$0(0);
                }
                this.mySdkDir = sdkDir;
            }

            @Override
            @NotNull
            GeneralCommandLine getCommandLine() {
                String flutterTool = FileUtil.toSystemDependentName((String)(this.mySdkDir + "/bin/" + FlutterSdkUtil.flutterScriptName()));
                GeneralCommandLine generalCommandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(this.mySdkDir).withExePath(flutterTool).withParameters(new String[]{"precache"});
                if (generalCommandLine == null) {
                    FlutterPrecacheCommand.$$$reportNull$$$0(1);
                }
                return generalCommandLine;
            }

            @Override
            @NotNull
            String getTitle() {
                if ("Running 'flutter precache'\u2026" == null) {
                    FlutterPrecacheCommand.$$$reportNull$$$0(2);
                }
                return "Running 'flutter precache'\u2026";
            }

            @Override
            void onTextAvailable(ProcessEvent event, Key outputType) {
                String details = event.getText();
                if (!details.startsWith(" ") && details.length() < 70) {
                    GitCloneAction.this.setProgressText(details);
                }
            }

            @Override
            void onSuccess(@NotNull ProcessEvent event) {
                if (event == null) {
                    FlutterPrecacheCommand.$$$reportNull$$$0(3);
                }
                ApplicationManager.getApplication().invokeAndWait(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(this.mySdkDir), ModalityState.NON_MODAL);
                GitCloneAction.this.requestNextStep();
            }

            @Override
            void onError(@NotNull ExecutionException event) {
                if (event == null) {
                    FlutterPrecacheCommand.$$$reportNull$$$0(4);
                }
                GitCloneAction.this.showError("Error installing Flutter: " + event.getMessage());
            }

            @Override
            void onError(@NotNull ProcessEvent event) {
                if (event == null) {
                    FlutterPrecacheCommand.$$$reportNull$$$0(5);
                }
                GitCloneAction.this.showError("Error installing Flutter: " + event.getText() + " returned " + event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sdkDir";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/actions/InstallSdkAction$GitCloneAction$FlutterPrecacheCommand";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/actions/InstallSdkAction$GitCloneAction$FlutterPrecacheCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommandLine";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTitle";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "onSuccess";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "onError";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class GitCloneCommand
        extends InstallCommand {
            @NotNull
            private final String myInstallPath;
            @NotNull
            private final String mySdkDir;

            GitCloneCommand(@NotNull String installPath, String sdkDir) {
                if (installPath == null) {
                    GitCloneCommand.$$$reportNull$$$0(0);
                }
                if (sdkDir == null) {
                    GitCloneCommand.$$$reportNull$$$0(1);
                }
                this.myInstallPath = installPath;
                this.mySdkDir = sdkDir;
            }

            @Override
            @NotNull
            GeneralCommandLine getCommandLine() {
                GeneralCommandLine generalCommandLine = InstallSdkAction.gitCommandBase().withWorkDirectory(this.myInstallPath).withParameters(new String[]{"clone", "-b", "beta", "https://github.com/flutter/flutter.git"});
                if (generalCommandLine == null) {
                    GitCloneCommand.$$$reportNull$$$0(2);
                }
                return generalCommandLine;
            }

            @Override
            @NotNull
            String getTitle() {
                if ("Cloning Flutter repository\u2026" == null) {
                    GitCloneCommand.$$$reportNull$$$0(3);
                }
                return "Cloning Flutter repository\u2026";
            }

            @Override
            void onError(@NotNull ExecutionException exception) {
                if (exception == null) {
                    GitCloneCommand.$$$reportNull$$$0(4);
                }
                GitCloneAction.this.showError("Error cloning Flutter repository: " + exception.getMessage());
            }

            @Override
            void onError(@NotNull ProcessEvent event) {
                if (event == null) {
                    GitCloneCommand.$$$reportNull$$$0(5);
                }
                GitCloneAction.this.showError("Flutter SDK download canceled.");
            }

            @Override
            protected void onSuccess(@NotNull ProcessEvent event) {
                if (event == null) {
                    GitCloneCommand.$$$reportNull$$$0(6);
                }
                GitCloneAction.this.runCommand(new FlutterPrecacheCommand(this.mySdkDir));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "installPath";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sdkDir";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/actions/InstallSdkAction$GitCloneAction$GitCloneCommand";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exception";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/actions/InstallSdkAction$GitCloneAction$GitCloneCommand";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommandLine";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTitle";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "onError";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "onSuccess";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private abstract class InstallCommand {
            InstallCommand() {
                GitCloneAction.this.setProgressText(this.getTitle());
            }

            @NotNull
            abstract String getTitle();

            @NotNull
            abstract GeneralCommandLine getCommandLine();

            final void registerTo(OSProcessHandler handler) {
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        GitCloneAction.this.setInProgress(true);
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        GitCloneAction.this.setInProgress(false);
                        if (event.getExitCode() == 0) {
                            InstallCommand.this.onSuccess(event);
                        } else {
                            InstallCommand.this.onError(event);
                        }
                    }

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        InstallCommand.this.onTextAvailable(event, outputType);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "io/flutter/actions/InstallSdkAction$GitCloneAction$InstallCommand$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "startNotified";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            void onSuccess(@NotNull ProcessEvent event) {
                if (event == null) {
                    InstallCommand.$$$reportNull$$$0(0);
                }
                GitCloneAction.this.validatePeer();
            }

            void onError(@NotNull ExecutionException event) {
                if (event == null) {
                    InstallCommand.$$$reportNull$$$0(1);
                }
            }

            void onError(@NotNull ProcessEvent event) {
                if (event == null) {
                    InstallCommand.$$$reportNull$$$0(2);
                }
                GitCloneAction.this.validatePeer();
            }

            void onTextAvailable(ProcessEvent event, Key outputType) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "io/flutter/actions/InstallSdkAction$GitCloneAction$InstallCommand";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ViewDocsAction
    extends InstallAction {
        private static final String ANALYTICS_KEY = "InstallSdkViewDocsAction";

        ViewDocsAction(Model peer) {
            super(peer);
        }

        @Override
        void perform() {
            FlutterInitializer.sendAnalyticsAction(ANALYTICS_KEY);
            BrowserUtil.browse((String)FlutterConstants.URL_GETTING_STARTED);
        }

        @Override
        String getLinkText() {
            return "View setup docs\u2026";
        }

        @Override
        Icon getLinkIcon() {
            return AllIcons.General.Web;
        }
    }

    public static abstract class InstallAction
    implements CancelActionListener {
        @NotNull
        private final Model myPeer;

        InstallAction(@NotNull Model peer) {
            if (peer == null) {
                InstallAction.$$$reportNull$$$0(0);
            }
            peer.addCancelActionListener(this);
            this.myPeer = peer;
        }

        @Override
        public void actionCanceled() {
        }

        abstract void perform();

        abstract Icon getLinkIcon();

        abstract String getLinkText();

        void showError(@NotNull String message) {
            if (message == null) {
                InstallAction.$$$reportNull$$$0(1);
            }
            this.setErrorDetails(message);
        }

        void setProgressText(String text) {
            this.myPeer.getProgressText().setText(text);
        }

        void setSdkPath(String path) {
            this.myPeer.setSdkPath(path);
        }

        void validatePeer() {
            this.myPeer.validate();
        }

        void cancelAction() {
            this.myPeer.getCancelProgressButton().setEnabled(false);
        }

        void requestNextStep() {
            this.myPeer.requestNextStep();
        }

        void setProgressVisible(boolean visible) {
            this.myPeer.getInstallActionLink().setVisible(!visible);
            this.myPeer.getCancelProgressButton().setVisible(visible);
            this.myPeer.getCancelProgressButton().setEnabled(visible);
            this.myPeer.getProgressBar().setVisible(visible);
            this.myPeer.getProgressText().setVisible(visible);
        }

        void setErrorDetails(String details) {
            this.myPeer.setErrorDetails(details);
        }

        void setSdkComboEnablement(boolean enabled) {
            this.myPeer.getSdkComboBox().setEnabled(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "peer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/actions/InstallSdkAction$InstallAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface CancelActionListener {
        public void actionCanceled();
    }

    public static interface Model {
        public JTextPane getProgressText();

        public void setSdkPath(String var1);

        public boolean validate();

        public JLabel getCancelProgressButton();

        public void requestNextStep();

        public LinkLabel getInstallActionLink();

        public JProgressBar getProgressBar();

        public void setErrorDetails(String var1);

        public ComboboxWithBrowseButton getSdkComboBox();

        public void addCancelActionListener(CancelActionListener var1);
    }
}

