/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import io.flutter.FlutterUtils;
import io.flutter.actions.ExtractWidgetDialog;
import io.flutter.refactoring.ExtractWidgetRefactoring;

public class ExtractWidgetAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)dataContext.getData(PlatformDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)dataContext.getData(PlatformDataKeys.VIRTUAL_FILE);
        Editor editor = (Editor)dataContext.getData(PlatformDataKeys.EDITOR);
        Caret caret = (Caret)dataContext.getData(PlatformDataKeys.CARET);
        if (project != null && file != null && editor != null && caret != null) {
            int length;
            int offset = caret.getSelectionStart();
            ExtractWidgetRefactoring refactoring = new ExtractWidgetRefactoring(project, file, offset, length = caret.getSelectionEnd() - offset);
            RefactoringStatus initialStatus = refactoring.checkInitialConditions();
            if (initialStatus == null) {
                return;
            }
            if (initialStatus.hasError()) {
                String message = initialStatus.getMessage();
                assert (message != null);
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)CommonBundle.getErrorTitle(), null);
                return;
            }
            new ExtractWidgetDialog(project, editor, refactoring).show();
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(ExtractWidgetAction.isVisibleFor(e));
        super.update(e);
    }

    protected static boolean isVisibleFor(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)dataContext.getData(PlatformDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)dataContext.getData(PlatformDataKeys.VIRTUAL_FILE);
        return file != null && FlutterUtils.isDartFile(file);
    }

    public boolean startInTransaction() {
        return true;
    }
}

