/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.google.common.base.Joiner;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindowId;
import io.flutter.FlutterConstants;
import io.flutter.FlutterInitializer;
import io.flutter.actions.FlutterSdkAction;
import io.flutter.actions.RunFlutterAction;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.SdkAttachConfig;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachDebuggerAction
extends FlutterSdkAction {
    @Override
    public void startCommand(@NotNull Project project, @NotNull FlutterSdk sdk, @Nullable PubRoot root, @NotNull DataContext context) {
        Executor executor;
        if (project == null) {
            AttachDebuggerAction.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            AttachDebuggerAction.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AttachDebuggerAction.$$$reportNull$$$0(2);
        }
        FlutterInitializer.sendAnalyticsAction((AnAction)this);
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
        if (settings == null) {
            AttachDebuggerAction.showSelectConfigDialog();
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (!(configuration instanceof SdkRunConfig)) {
            if (project.isDefault() || !FlutterSdkUtil.hasFlutterModules(project)) {
                return;
            }
            AttachDebuggerAction.showSelectConfigDialog();
            return;
        }
        SdkAttachConfig sdkRunConfig = new SdkAttachConfig((SdkRunConfig)configuration);
        SdkFields fields = sdkRunConfig.getFields();
        String additionalArgs = fields.getAdditionalArgs();
        String flavorArg = null;
        if (fields.getBuildFlavor() != null) {
            flavorArg = "--flavor=" + fields.getBuildFlavor();
        }
        ArrayList<String> args = new ArrayList<String>();
        if (additionalArgs != null) {
            args.add(additionalArgs);
        }
        if (flavorArg != null) {
            args.add(flavorArg);
        }
        if (!args.isEmpty()) {
            fields.setAdditionalArgs(Joiner.on((String)" ").join(args));
        }
        if ((executor = RunFlutterAction.getExecutor(ToolWindowId.DEBUG)) == null) {
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)sdkRunConfig);
        ExecutionEnvironment env = builder.activeTarget().dataContext(context).build();
        FlutterLaunchMode.addToEnvironment(env, FlutterLaunchMode.DEBUG);
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Project project = e.getProject();
        if (project == null || project.isDefault()) {
            super.update(e);
            return;
        }
        if (!FlutterSdkUtil.hasFlutterModules(project)) {
            e.getPresentation().setVisible(false);
            return;
        }
        RunnerAndConfigurationSettings settings = RunFlutterAction.getRunConfigSettings(e);
        if (settings == null) {
            enabled = false;
        } else {
            RunConfiguration configuration = settings.getConfiguration();
            enabled = configuration instanceof SdkRunConfig;
        }
        e.getPresentation().setEnabled(enabled);
    }

    private static void showSelectConfigDialog() {
        ApplicationManager.getApplication().invokeLater(() -> new SelectConfigDialog().show(), ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "io/flutter/actions/AttachDebuggerAction";
        objectArray[2] = "startCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SelectConfigDialog
    extends DialogWrapper {
        private JPanel myPanel;
        private JTextPane myTextPane;

        SelectConfigDialog() {
            super(null, false, false);
            this.setTitle("Run Configuration");
            this.myPanel = new JPanel();
            this.myTextPane = new JTextPane();
            Messages.installHyperlinkSupport((JTextPane)this.myTextPane);
            String selectConfig = "<html><body><p>The run configuration for the Flutter module must be selected.<p>Please change the run configuration to the one created when the<br>module was created. See <a href=\"" + FlutterConstants.URL_RUN_AND_DEBUG + "\">the Flutter documentation</a> for more information.</body></html>";
            this.myTextPane.setText(selectConfig);
            this.myPanel.add(this.myTextPane);
            this.init();
            this.getButton(this.getCancelAction()).setVisible(false);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel;
        }
    }
}

