/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import icons.FlutterIcons;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenActivity
implements StartupActivity,
DumbAware {
    public static final ProjectType FLUTTER_PROJECT_TYPE = new ProjectType("io.flutter");
    private static final Logger LOG = Logger.getInstance(ProjectOpenActivity.class);
    @Nullable
    private FlutterSettings settings;

    public ProjectOpenActivity() {
    }

    public ProjectOpenActivity(@NotNull FlutterSettings settings) {
        if (settings == null) {
            ProjectOpenActivity.$$$reportNull$$$0(0);
        }
        this.settings = settings;
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ProjectOpenActivity.$$$reportNull$$$0(1);
        }
        if (!FlutterModuleUtils.declaresFlutter(project)) {
            return;
        }
        FlutterSdk sdk = FlutterSdk.getIncomplete(project);
        if (sdk == null) {
            return;
        }
        if (this.settings != null && this.settings.shouldUseBazel()) {
            return;
        }
        for (PubRoot pubRoot : PubRoots.forProject(project)) {
            if (pubRoot.hasUpToDatePackages()) continue;
            Notifications.Bus.notify((Notification)new PackagesOutOfDateNotification(project, pubRoot));
        }
        if (!FLUTTER_PROJECT_TYPE.equals((Object)ProjectTypeService.getProjectType((Project)project))) {
            ProjectTypeService.setProjectType((Project)project, (ProjectType)FLUTTER_PROJECT_TYPE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "io/flutter/ProjectOpenActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PackagesOutOfDateNotification
    extends Notification {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PubRoot myRoot;

        public PackagesOutOfDateNotification(final @NotNull Project project, final @NotNull PubRoot root) {
            if (project == null) {
                PackagesOutOfDateNotification.$$$reportNull$$$0(0);
            }
            if (root == null) {
                PackagesOutOfDateNotification.$$$reportNull$$$0(1);
            }
            super("Flutter Packages", FlutterIcons.Flutter, "Flutter packages get.", null, "The pubspec.yaml file has been modified since the last time 'flutter packages get' was run.", NotificationType.INFORMATION, null);
            this.myProject = project;
            this.myRoot = root;
            this.addAction(new AnAction("Run 'flutter packages get'"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.expire();
                    FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
                    if (sdk == null) {
                        Messages.showErrorDialog((Project)project, (String)"Flutter SDK not found", (String)"Error");
                        return;
                    }
                    if (sdk.startPackagesGet(root, project) == null) {
                        Messages.showErrorDialog((String)"Unable to run 'flutter packages get'", (String)"Error");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/ProjectOpenActivity$PackagesOutOfDateNotification$1", "actionPerformed"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "io/flutter/ProjectOpenActivity$PackagesOutOfDateNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

