/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.analytics.Analytics;
import io.flutter.analytics.ToolWindowTracker;
import io.flutter.android.IntelliJAndroidSdk;
import io.flutter.devtools.WebDevManager;
import io.flutter.editor.FlutterSaveActionsManager;
import io.flutter.perf.FlutterWidgetPerfManager;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.run.FlutterReloadManager;
import io.flutter.run.FlutterRunNotifications;
import io.flutter.run.daemon.DeviceService;
import io.flutter.samples.FlutterSampleManager;
import io.flutter.sdk.FlutterPluginsLibraryManager;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkManager;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.view.FlutterPerfViewFactory;
import io.flutter.view.FlutterViewFactory;
import java.util.UUID;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class FlutterInitializer
implements StartupActivity {
    private static final String analyticsClientIdKey = "io.flutter.analytics.clientId";
    private static final String analyticsOptOutKey = "io.flutter.analytics.optOut";
    private static final String analyticsToastShown = "io.flutter.analytics.toastShown";
    private static Analytics analytics;

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            FlutterInitializer.$$$reportNull$$$0(0);
        }
        if (FlutterModuleUtils.convertFromDeprecatedModuleType(project)) {
            FlutterMessages.showInfo(FlutterBundle.message("flutter.initializer.module.converted.title", new Object[0]), "Converted from 'WEB_MODULE' to '" + FlutterModuleUtils.getModuleTypeIDForFlutter() + "'.");
        }
        FlutterUtils.disableGradleProjectMigrationNotification(project);
        DeviceService.getInstance(project);
        FlutterViewFactory.init(project);
        FlutterPerfViewFactory.init(project);
        boolean hasFlutterModule = false;
        boolean hasFlutterWebModule = false;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            boolean declaresFlutter = FlutterModuleUtils.declaresFlutter(module);
            boolean declaresFlutterWeb = FlutterModuleUtils.declaresFlutterWeb(module);
            hasFlutterModule = hasFlutterModule || declaresFlutter;
            boolean bl = hasFlutterWebModule = hasFlutterWebModule || declaresFlutterWeb;
            if (!declaresFlutter && !declaresFlutterWeb) continue;
            FlutterModuleUtils.enableDartSDK(module);
            for (PubRoot root : PubRoots.forModule(module)) {
                if (root.hasAndroidModule(project)) {
                    this.ensureAndroidSdk(project);
                }
                FlutterModuleUtils.autoCreateRunConfig(project, root);
                if (FileEditorManager.getInstance((Project)project).getOpenFiles().length != 0) continue;
                FlutterModuleUtils.autoShowMain(project, root);
            }
        }
        if (hasFlutterModule) {
            FlutterModuleUtils.ensureRunConfigSelected(project);
        }
        if (hasFlutterModule) {
            FlutterInitializer.performAndroidStudioCanaryCheck();
        }
        if (hasFlutterWebModule) {
            this.installWebDev(project);
        }
        FlutterRunNotifications.init(project);
        FlutterWidgetPerfManager.init(project);
        FlutterSampleManager.initialize(project);
        FlutterReloadManager.init(project);
        FlutterSaveActionsManager.init(project);
        FlutterPluginsLibraryManager libraryManager = new FlutterPluginsLibraryManager(project);
        libraryManager.startWatching();
        NotificationsConfiguration.getNotificationsConfiguration().register("Flutter Usage Statistics", NotificationDisplayType.STICKY_BALLOON, false);
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (!properties.getBoolean(analyticsToastShown)) {
            properties.setValue(analyticsToastShown, true);
            final Notification notification = new Notification("Flutter Usage Statistics", "Welcome to Flutter!", FlutterBundle.message("flutter.analytics.notification.content", new Object[0]), NotificationType.INFORMATION, (notification1, event) -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "url".equals(event.getDescription())) {
                    BrowserUtil.browse((String)"https://www.google.com/policies/privacy/");
                }
            });
            notification.addAction(new AnAction("Sounds good!"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    notification.expire();
                    Analytics analytics = FlutterInitializer.getAnalytics();
                    if (FlutterModuleUtils.declaresFlutter(project)) {
                        ToolWindowTracker.track(project, analytics);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/FlutterInitializer$1", "actionPerformed"));
                }
            });
            notification.addAction(new AnAction("No thanks"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    notification.expire();
                    FlutterInitializer.setCanReportAnalytics(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/FlutterInitializer$2", "actionPerformed"));
                }
            });
            Notifications.Bus.notify((Notification)notification);
        } else if (FlutterModuleUtils.declaresFlutter(project)) {
            ToolWindowTracker.track(project, FlutterInitializer.getAnalytics());
        }
    }

    private void installWebDev(final @NotNull Project project) {
        if (project == null) {
            FlutterInitializer.$$$reportNull$$$0(1);
        }
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        final WebDevManager webDevManager = WebDevManager.getInstance(project);
        if (flutterSdk != null) {
            if (!webDevManager.hasInstalledWebDev()) {
                webDevManager.installWebdev();
            }
        } else {
            FlutterSdkManager.getInstance(project).addListener(new FlutterSdkManager.Listener(){
                boolean installAttempted = false;

                @Override
                public void flutterSdkAdded() {
                    FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
                    if (flutterSdk == null) {
                        return;
                    }
                    if (!this.installAttempted && !webDevManager.hasInstalledWebDev()) {
                        this.installAttempted = true;
                        webDevManager.installWebdev();
                    }
                }
            });
        }
    }

    private void ensureAndroidSdk(@NotNull Project project) {
        if (project == null) {
            FlutterInitializer.$$$reportNull$$$0(2);
        }
        if (ProjectRootManager.getInstance((Project)project).getProjectSdk() != null) {
            return;
        }
        IntelliJAndroidSdk wanted = IntelliJAndroidSdk.fromEnvironment();
        if (wanted == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> wanted.setCurrent(project));
    }

    @NotNull
    public static Analytics getAnalytics() {
        if (analytics == null) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String clientId = properties.getValue(analyticsClientIdKey);
            if (clientId == null) {
                clientId = UUID.randomUUID().toString();
                properties.setValue(analyticsClientIdKey, clientId);
            }
            IdeaPluginDescriptor descriptor = PluginManager.getPlugin((PluginId)FlutterUtils.getPluginId());
            assert (descriptor != null);
            ApplicationInfo info = ApplicationInfo.getInstance();
            analytics = new Analytics(clientId, descriptor.getVersion(), info.getVersionName(), info.getFullVersion());
            analytics.setCanSend(FlutterInitializer.getCanReportAnalytics());
            analytics.sendScreenView("main");
            FlutterSettings.getInstance().sendSettingsToAnalytics(analytics);
        }
        Analytics analytics = FlutterInitializer.analytics;
        if (analytics == null) {
            FlutterInitializer.$$$reportNull$$$0(3);
        }
        return analytics;
    }

    public static boolean getCanReportAnalytics() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        return !properties.getBoolean(analyticsOptOutKey, false);
    }

    public static void setCanReportAnalytics(boolean canReportAnalytics) {
        if (FlutterInitializer.getCanReportAnalytics() != canReportAnalytics) {
            boolean wasReporting = FlutterInitializer.getCanReportAnalytics();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            properties.setValue(analyticsOptOutKey, !canReportAnalytics);
            if (analytics != null) {
                analytics.setCanSend(FlutterInitializer.getCanReportAnalytics());
            }
            if (!wasReporting && canReportAnalytics) {
                FlutterInitializer.getAnalytics().sendScreenView("main");
            }
        }
    }

    public static void sendAnalyticsAction(@NotNull AnAction action) {
        if (action == null) {
            FlutterInitializer.$$$reportNull$$$0(4);
        }
        FlutterInitializer.sendAnalyticsAction(action.getClass().getSimpleName());
    }

    public static void sendAnalyticsAction(@NotNull String name) {
        if (name == null) {
            FlutterInitializer.$$$reportNull$$$0(5);
        }
        FlutterInitializer.getAnalytics().sendEvent("intellij", name);
    }

    private static void performAndroidStudioCanaryCheck() {
        if (!FlutterUtils.isAndroidStudio()) {
            return;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        if (info.getFullVersion().contains("Canary") && !info.getBuild().isSnapshot()) {
            FlutterMessages.showWarning("Unsupported Android Studio version", "Canary versions of Android Studio are not supported by the Flutter plugin.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/FlutterInitializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/FlutterInitializer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalytics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installWebDev";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureAndroidSdk";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendAnalyticsAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

