/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import io.flutter.FlutterBundle;
import io.flutter.project.FlutterProjectModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSettingsStep
extends ModelWizardStep<FlutterProjectModel> {
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private JBScrollPane myRoot;
    private JPanel myRootPanel;
    private ValidatorPanel myValidatorPanel;
    private JTextField myCompanyDomain;
    private LabelWithEditButton myPackageName;
    private JCheckBox myKotlinCheckBox;
    private JCheckBox mySwiftCheckBox;
    private JLabel myLanguageLabel;
    private boolean hasEntered;
    private FocusListener focusListener;

    public FlutterSettingsStep(FlutterProjectModel model, String title, Icon icon) {
        super((WizardModel)model, title, icon);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.hasEntered = false;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        this.myRoot = StudioWizardStepPanel.wrappedWithVScroll((JPanel)this.myRootPanel);
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myRoot);
    }

    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            FlutterSettingsStep.$$$reportNull$$$0(0);
        }
        FlutterProjectModel model = (FlutterProjectModel)this.getModel();
        this.myKotlinCheckBox.setText(FlutterBundle.message((String)"module.wizard.language.name_kotlin", (Object[])new Object[0]));
        this.mySwiftCheckBox.setText(FlutterBundle.message((String)"module.wizard.language.name_swift", (Object[])new Object[0]));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(model.companyDomain(), model.projectName()){

            public String get() {
                return super.get().replaceAll("_", "");
            }
        };
        BoolValueProperty isPackageSynced = new BoolValueProperty(Boolean.valueOf(true));
        this.myBindings.bind((SettableValue)packageNameText, (ObservableValue)computedPackageName, (ObservableValue)isPackageSynced);
        this.myBindings.bind((SettableValue)model.packageName(), (ObservableValue)packageNameText);
        this.myListeners.receive((ObservableValue)packageNameText, arg_0 -> FlutterSettingsStep.lambda$onWizardStarting$0((BoolProperty)isPackageSynced, (Expression)computedPackageName, arg_0));
        this.myBindings.bindTwoWay((SettableValue)new TextProperty((JTextComponent)this.myCompanyDomain), (SettableValue)model.companyDomain());
        ApplicationInfo info = ApplicationInfo.getInstance();
        if (info.getMajorVersion().equals("3") && info.getMinorVersion().equals("4")) {
            return;
        }
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Object parent;
                super.focusGained(e);
                for (parent = FlutterSettingsStep.this.myRoot; parent != null && !(parent instanceof JBLayeredPane); parent = parent.getParent()) {
                }
                if (parent != null) {
                    parent.validate();
                }
                FlutterSettingsStep.this.myCompanyDomain.removeFocusListener(FlutterSettingsStep.this.focusListener);
            }
        };
        this.myCompanyDomain.addFocusListener(this.focusListener);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    protected JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myRoot;
        if (jBScrollPane == null) {
            FlutterSettingsStep.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myCompanyDomain;
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            FlutterSettingsStep.$$$reportNull$$$0(2);
        }
        return observableBool;
    }

    protected void onEntering() {
        if (this.hasEntered) {
            return;
        }
        if (((FlutterProjectModel)this.getModel()).isModule()) {
            this.myLanguageLabel.setVisible(false);
            this.myKotlinCheckBox.setVisible(false);
            this.mySwiftCheckBox.setVisible(false);
        } else {
            this.myLanguageLabel.setVisible(true);
            this.myKotlinCheckBox.setVisible(true);
            this.mySwiftCheckBox.setVisible(true);
            this.myBindings.bindTwoWay((SettableValue)new SelectedProperty((AbstractButton)this.myKotlinCheckBox), (SettableValue)((FlutterProjectModel)this.getModel()).useKotlin());
            this.myBindings.bindTwoWay((SettableValue)new SelectedProperty((AbstractButton)this.mySwiftCheckBox), (SettableValue)((FlutterProjectModel)this.getModel()).useSwift());
        }
        this.hasEntered = true;
    }

    protected void onProceeding() {
    }

    private static /* synthetic */ void lambda$onWizardStarting$0(BoolProperty isPackageSynced, Expression computedPackageName, String value) {
        isPackageSynced.set((Object)value.equals(computedPackageName.get()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        LabelWithEditButton labelWithEditButton;
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(13, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        Font font = jBLabel.getFont();
        if (font != null) {
            jBLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jBLabel.setText("Company domain");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLanguageLabel = jLabel = new JLabel();
        Font font2 = jLabel.getFont();
        if (font2 != null) {
            jLabel.setFont(new Font(font2.getName(), 1, font2.getSize()));
        }
        jLabel.setHorizontalAlignment(2);
        jLabel.setText("Platform channel language");
        jPanel.add((Component)jLabel, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        Font font3 = jBLabel2.getFont();
        if (font3 != null) {
            jBLabel2.setFont(new Font(font3.getName(), 1, font3.getSize()));
        }
        jBLabel2.setText("Package name");
        jPanel.add((Component)jBLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompanyDomain = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(4, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = labelWithEditButton = new LabelWithEditButton();
        jPanel.add((Component)labelWithEditButton, new GridConstraints(7, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myKotlinCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Kotlin");
        jCheckBox2.setToolTipText("Java support will be included");
        jPanel.add((Component)jCheckBox2, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySwiftCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Swift");
        jCheckBox.setToolTipText("Objective-C support will be included");
        jPanel.add((Component)jCheckBox, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        Font font4 = jBLabel3.getFont();
        if (font4 != null) {
            jBLabel3.setFont(new Font(font4.getName(), 1, 20));
        }
        jBLabel3.setText("Set the package name");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Applications and plugins need to generate platform-specific code");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterSettingsStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterSettingsStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

